/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.core.instrument.binder.httpcomponents.hc5;

import io.micrometer.common.KeyValue;
import io.micrometer.common.KeyValues;
import io.micrometer.core.instrument.binder.http.HttpMethods;
import io.micrometer.core.instrument.binder.http.Outcome;
import io.micrometer.core.instrument.binder.httpcomponents.hc5.ApacheHttpClientContext;
import io.micrometer.core.instrument.binder.httpcomponents.hc5.ApacheHttpClientObservationConvention;
import io.micrometer.core.instrument.binder.httpcomponents.hc5.OpenTelemetryApacheHttpClientObservationDocumentation;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import org.apache.hc.client5.http.RouteInfo;
import org.apache.hc.core5.http.HttpException;
import org.apache.hc.core5.http.HttpRequest;
import org.apache.hc.core5.http.HttpResponse;
import org.jspecify.annotations.Nullable;

public class OpenTelemetryApacheHttpClientObservationConvention
implements ApacheHttpClientObservationConvention {
    public static final OpenTelemetryApacheHttpClientObservationConvention INSTANCE = new OpenTelemetryApacheHttpClientObservationConvention();
    private static final KeyValue METHOD_OTHER = OpenTelemetryApacheHttpClientObservationDocumentation.LowCardinalityKeyNames.METHOD.withValue("_OTHER");
    private static final KeyValue URL_UNKNOWN = OpenTelemetryApacheHttpClientObservationDocumentation.HighCardinalityKeyNames.URL.withValue("UNKNOWN");
    private static final KeyValue STATUS_UNKNOWN = OpenTelemetryApacheHttpClientObservationDocumentation.LowCardinalityKeyNames.STATUS.withValue("0");
    private static final KeyValue EXCEPTION_NONE = OpenTelemetryApacheHttpClientObservationDocumentation.LowCardinalityKeyNames.ERROR_TYPE.withNoneValue();
    private static final KeyValue OUTCOME_UNKNOWN = OpenTelemetryApacheHttpClientObservationDocumentation.LowCardinalityKeyNames.OUTCOME.withValue(Outcome.UNKNOWN.name());
    private static final KeyValue SERVER_ADDRESS_UNKNOWN = OpenTelemetryApacheHttpClientObservationDocumentation.LowCardinalityKeyNames.SERVER_ADDRESS.withValue("UNKNOWN");
    private static final KeyValue SERVER_PORT_UNKNOWN = OpenTelemetryApacheHttpClientObservationDocumentation.LowCardinalityKeyNames.SERVER_PORT.withValue("-1");

    protected OpenTelemetryApacheHttpClientObservationConvention() {
    }

    @Override
    public String getName() {
        return "http.client.request.duration";
    }

    @Override
    public String getContextualName(ApacheHttpClientContext context2) {
        HttpRequest carrier = (HttpRequest)context2.getCarrier();
        if (carrier == null) {
            return "HTTP";
        }
        String maybeMethod = this.maybeGetKnownMethod(carrier);
        return maybeMethod == null ? "HTTP" : maybeMethod;
    }

    @Override
    public KeyValues getLowCardinalityKeyValues(ApacheHttpClientContext context2) {
        return KeyValues.of(this.exception(context2), this.method(context2), this.status(context2), this.outcome(context2), this.serverAddress(context2), this.serverPort(context2));
    }

    @Override
    public KeyValues getHighCardinalityKeyValues(ApacheHttpClientContext context2) {
        return KeyValues.of(this.urlFull(context2));
    }

    protected @Nullable String maybeGetKnownMethod(HttpRequest request) {
        String httpMethod = request.getMethod();
        if (HttpMethods.isStandard(httpMethod)) {
            return httpMethod;
        }
        return null;
    }

    protected KeyValue method(ApacheHttpClientContext context2) {
        String method;
        HttpRequest request = (HttpRequest)context2.getCarrier();
        if (request != null && (method = this.maybeGetKnownMethod(request)) != null) {
            return OpenTelemetryApacheHttpClientObservationDocumentation.LowCardinalityKeyNames.METHOD.withValue(method);
        }
        return METHOD_OTHER;
    }

    protected KeyValue serverAddress(ApacheHttpClientContext context2) {
        String serverAddressValue = this.getServerAddressValue(context2);
        return serverAddressValue != null ? OpenTelemetryApacheHttpClientObservationDocumentation.LowCardinalityKeyNames.SERVER_ADDRESS.withValue(serverAddressValue) : SERVER_ADDRESS_UNKNOWN;
    }

    private @Nullable String getServerAddressValue(ApacheHttpClientContext context2) {
        RouteInfo httpRoute = OpenTelemetryApacheHttpClientObservationConvention.getHttpRoute(context2);
        if (httpRoute != null) {
            return httpRoute.getTargetHost().getHostName();
        }
        URI uri = OpenTelemetryApacheHttpClientObservationConvention.getUri(context2);
        if (uri != null && uri.getHost() != null) {
            return uri.getHost();
        }
        return null;
    }

    protected KeyValue serverPort(ApacheHttpClientContext context2) {
        Integer serverPortValue = this.getServerPortValue(context2);
        return serverPortValue != null ? OpenTelemetryApacheHttpClientObservationDocumentation.LowCardinalityKeyNames.SERVER_PORT.withValue(String.valueOf(serverPortValue)) : SERVER_PORT_UNKNOWN;
    }

    private @Nullable Integer getServerPortValue(ApacheHttpClientContext context2) {
        RouteInfo httpRoute = OpenTelemetryApacheHttpClientObservationConvention.getHttpRoute(context2);
        if (httpRoute != null) {
            return httpRoute.getTargetHost().getPort();
        }
        URI uri = OpenTelemetryApacheHttpClientObservationConvention.getUri(context2);
        if (uri != null && uri.getPort() != -1) {
            return uri.getPort();
        }
        return null;
    }

    protected KeyValue exception(ApacheHttpClientContext context2) {
        Throwable error = context2.getError();
        if (error != null) {
            return OpenTelemetryApacheHttpClientObservationDocumentation.LowCardinalityKeyNames.ERROR_TYPE.withValue(error.getClass().getSimpleName());
        }
        return EXCEPTION_NONE;
    }

    protected KeyValue status(ApacheHttpClientContext context2) {
        Throwable error = context2.getError();
        if (error instanceof IOException || error instanceof HttpException || error instanceof RuntimeException) {
            return STATUS_UNKNOWN;
        }
        HttpResponse response = (HttpResponse)context2.getResponse();
        if (response == null) {
            return STATUS_UNKNOWN;
        }
        return OpenTelemetryApacheHttpClientObservationDocumentation.LowCardinalityKeyNames.STATUS.withValue(String.valueOf(response.getCode()));
    }

    protected KeyValue outcome(ApacheHttpClientContext context2) {
        HttpResponse response = (HttpResponse)context2.getResponse();
        if (response == null) {
            return OUTCOME_UNKNOWN;
        }
        return OpenTelemetryApacheHttpClientObservationDocumentation.LowCardinalityKeyNames.OUTCOME.withValue(Outcome.forStatus(response.getCode()).name());
    }

    protected KeyValue urlFull(ApacheHttpClientContext context2) {
        URI uri;
        HttpRequest request = (HttpRequest)context2.getCarrier();
        if (request != null && (uri = OpenTelemetryApacheHttpClientObservationConvention.getUri(context2)) != null) {
            return OpenTelemetryApacheHttpClientObservationDocumentation.HighCardinalityKeyNames.URL.withValue(uri.toString());
        }
        return URL_UNKNOWN;
    }

    private static @Nullable URI getUri(ApacheHttpClientContext context2) {
        HttpRequest request = (HttpRequest)context2.getCarrier();
        if (request != null) {
            try {
                return request.getUri();
            }
            catch (URISyntaxException uRISyntaxException) {
                // empty catch block
            }
        }
        return null;
    }

    private static @Nullable RouteInfo getHttpRoute(ApacheHttpClientContext context2) {
        return context2.getHttpClientContext().getHttpRoute();
    }
}

