/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.xml;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.lang.invoke.LambdaMetafactory;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Parameter;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.net.UnknownHostException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Queue;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.eclipse.jetty.util.ConcurrentPool;
import org.eclipse.jetty.util.IO;
import org.eclipse.jetty.util.LazyList;
import org.eclipse.jetty.util.Loader;
import org.eclipse.jetty.util.Pool;
import org.eclipse.jetty.util.StringUtil;
import org.eclipse.jetty.util.TypeUtil;
import org.eclipse.jetty.util.annotation.Name;
import org.eclipse.jetty.util.component.ContainerLifeCycle;
import org.eclipse.jetty.util.component.Environment;
import org.eclipse.jetty.util.component.LifeCycle;
import org.eclipse.jetty.util.resource.Resource;
import org.eclipse.jetty.util.resource.ResourceFactory;
import org.eclipse.jetty.xml.ConfigurationProcessor;
import org.eclipse.jetty.xml.ConfigurationProcessorFactory;
import org.eclipse.jetty.xml.EnvironmentBuilder;
import org.eclipse.jetty.xml.XmlConfigurationException;
import org.eclipse.jetty.xml.XmlParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public class XmlConfiguration {
    private static final Logger LOG = LoggerFactory.getLogger(XmlConfiguration.class);
    private static final Class<?>[] PRIMITIVES = new Class[]{Boolean.TYPE, Character.TYPE, Byte.TYPE, Short.TYPE, Integer.TYPE, Long.TYPE, Float.TYPE, Double.TYPE, Void.TYPE};
    private static final Class<?>[] BOXED_PRIMITIVES = new Class[]{Boolean.class, Character.class, Byte.class, Short.class, Integer.class, Long.class, Float.class, Double.class, Void.class};
    private static final Class<?>[] SUPPORTED_COLLECTIONS = new Class[]{ArrayList.class, HashSet.class, Queue.class, List.class, Set.class, Collection.class};
    private static final List<ConfigurationProcessorFactory> PROCESSOR_FACTORIES = TypeUtil.serviceProviderStream(ServiceLoader.load(ConfigurationProcessorFactory.class)).flatMap(p -> Stream.of((ConfigurationProcessorFactory)p.get())).toList();
    private static final Pool<ConfigurationParser> __parsers = new ConcurrentPool<ConfigurationParser>(ConcurrentPool.StrategyType.THREAD_ID, Math.min(8, Runtime.getRuntime().availableProcessors()));
    public static final Comparator<Executable> EXECUTABLE_COMPARATOR = (e1, e2) -> {
        int count = e1.getParameterCount();
        int compare = Integer.compare(count, e2.getParameterCount());
        if (compare == 0 && count > 0) {
            Parameter[] p1 = e1.getParameters();
            Parameter[] p2 = e2.getParameters();
            compare = Boolean.compare(p1[count - 1].isVarArgs(), p2[count - 1].isVarArgs());
            if (compare == 0) {
                for (int i = 0; i < count; ++i) {
                    Class<?> t2;
                    Class<?> t1 = p1[i].getType();
                    if (t1 != (t2 = p2[i].getType()) && (compare = Boolean.compare(t2.isPrimitive(), t1.isPrimitive())) == 0 && (compare = XmlConfiguration.compare(t1, t2)) == 0) {
                        int d1 = XmlConfiguration.calculateDepth(t1);
                        int d2 = XmlConfiguration.calculateDepth(t2);
                        compare = Integer.compare(d2, d1);
                    }
                    if (compare != 0) break;
                }
            }
        }
        if (compare == 0) {
            compare = e1.toGenericString().compareTo(e2.toGenericString());
        }
        return Integer.compare(compare, 0);
    };
    private final Map<String, Object> _idMap;
    private final Map<String, String> _propertyMap;
    private final Resource _location;
    private final String _dtd;
    private ConfigurationProcessor _processor;

    private static int compare(Class<?> t1, Class<?> t2) {
        if (t1 == Object.class) {
            if (t2 == Object.class) {
                return 0;
            }
            return 1;
        }
        if (t2 == Object.class) {
            return -1;
        }
        return Boolean.compare(t1.isInterface(), t2.isInterface());
    }

    private static int calculateDepth(Class<?> c) {
        int depth = 0;
        if (c.isPrimitive()) {
            return Integer.MIN_VALUE;
        }
        if (c.isInterface()) {
            Set<Class<Object>> interfaces = Set.of(c);
            while (!interfaces.isEmpty()) {
                ++depth;
                interfaces = interfaces.stream().flatMap(i -> Arrays.stream(i.getInterfaces())).collect(Collectors.toSet());
            }
        } else {
            while (c != Object.class && !c.isPrimitive()) {
                ++depth;
                c = c.getSuperclass();
            }
        }
        return depth;
    }

    public void setJettyStandardIdsAndProperties(Object server, Path webapp) {
        try {
            if (server != null) {
                this.getIdMap().put("Server", server);
            }
            Path home = Paths.get(System.getProperty("jetty.home", "."), new String[0]);
            this.getProperties().put("jetty.home", home.toString());
            this.getProperties().put("jetty.home.uri", XmlConfiguration.normalizeURI(home.toUri().toASCIIString()));
            Path base = Paths.get(System.getProperty("jetty.base", home.toString()), new String[0]);
            this.getProperties().put("jetty.base", base.toString());
            this.getProperties().put("jetty.base.uri", XmlConfiguration.normalizeURI(base.toUri().toASCIIString()));
            if (webapp != null) {
                this.getProperties().put("jetty.webapp", webapp.toString());
                this.getProperties().put("jetty.webapps", webapp.getParent().toString());
                this.getProperties().put("jetty.webapps.uri", XmlConfiguration.normalizeURI(webapp.getParent().toUri().toString()));
            }
        }
        catch (Exception e2) {
            LOG.warn("Unable to get webapp file reference", e2);
        }
    }

    public static String normalizeURI(String uri) {
        if (uri.endsWith("/")) {
            return uri.substring(0, uri.length() - 1);
        }
        return uri;
    }

    public XmlParser getXmlParser() {
        Pool.Entry<ConfigurationParser> entry = __parsers.acquire(ConfigurationParser::new);
        if (entry == null) {
            return new ConfigurationParser(null);
        }
        return entry.getPooled();
    }

    public XmlConfiguration(Resource resource) throws SAXException, IOException {
        this(resource, null, null);
    }

    public XmlConfiguration(Resource resource, Map<String, Object> idMap, Map<String, String> properties) throws SAXException, IOException {
        XmlParser parser = this.getXmlParser();
        try (InputStream inputStream = resource.newInputStream();){
            this._location = resource;
            this.setConfig(parser.parse(inputStream));
            this._dtd = parser.getDTD();
            this._idMap = idMap == null ? new HashMap() : idMap;
            this._propertyMap = properties == null ? new HashMap() : properties;
        }
        catch (Throwable t) {
            throw new XmlConfigurationException("Bad Jetty XML configuration in " + String.valueOf(this), t);
        }
        finally {
            if (parser instanceof Closeable) {
                Closeable closeable = (Closeable)((Object)parser);
                IO.close(closeable);
            }
        }
    }

    public String toString() {
        return Objects.toString(this._location, "UNKNOWN-LOCATION");
    }

    private void setConfig(XmlParser.Node config) {
        if ("Configure".equals(config.getTag())) {
            this._processor = new JettyXmlConfiguration();
        } else if (PROCESSOR_FACTORIES != null) {
            for (ConfigurationProcessorFactory factory : PROCESSOR_FACTORIES) {
                this._processor = factory.getConfigurationProcessor(this._dtd, config.getTag());
                if (this._processor == null) continue;
                break;
            }
            if (this._processor == null) {
                throw new IllegalStateException("Unknown configuration type: " + config.getTag());
            }
        } else {
            throw new IllegalArgumentException("Unknown XML tag:" + config.getTag());
        }
        this._processor.init(this._location, config, this);
    }

    public Map<String, Object> getIdMap() {
        return this._idMap;
    }

    public Map<String, String> getProperties() {
        return this._propertyMap;
    }

    public Object configure(Object obj) throws Exception {
        return this._processor.configure(obj);
    }

    public Object configure() throws Exception {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Configure {}", (Object)this._location);
        }
        return this._processor.configure();
    }

    public void initializeDefaults(Object object) {
    }

    public static String resolvePath(String dir, String destPath) {
        Path resolved = XmlConfiguration.resolvedPath(dir, destPath);
        if (resolved == null) {
            return null;
        }
        return resolved.toString();
    }

    public static Path resolvedPath(String dir, String destPath) {
        if (StringUtil.isEmpty(dir) || StringUtil.isEmpty(destPath)) {
            return null;
        }
        return Paths.get(dir, new String[0]).resolve(destPath).normalize();
    }

    public static List<Path> csvSplitAndResolvePaths(String dir, String csvList) {
        return Arrays.stream(StringUtil.csvSplit(csvList)).map(s -> XmlConfiguration.resolvedPath(dir, s)).toList();
    }

    private static List<XmlParser.Node> getNodes(XmlParser.Node node, String elementName) {
        XmlParser.Node n;
        String attrName = StringUtil.asciiToLowerCase(elementName);
        ArrayList<XmlParser.Node> values = new ArrayList<XmlParser.Node>();
        String attr = node.getAttribute(attrName);
        if (attr != null) {
            for (String a : StringUtil.csvSplit(null, attr, 0, attr.length())) {
                n = new XmlParser.Node(null, elementName, null);
                n.add(a);
                values.add(n);
            }
        }
        for (Object o : node) {
            if (!(o instanceof XmlParser.Node) || !elementName.equals((n = (XmlParser.Node)o).getTag())) continue;
            if (attr != null) {
                throw new IllegalStateException("Cannot have attr '" + attrName + "' and element '" + elementName + "'");
            }
            values.add(n);
        }
        return values;
    }

    public static void main(String ... args) throws Exception {
        if (LOG.isDebugEnabled()) {
            LOG.debug("args={}", (Object)Arrays.asList(args));
        }
        EnvironmentBuilder envBuilder = null;
        Environment environment = null;
        Properties coreProperties = new Properties();
        Properties envProperties = new Properties();
        coreProperties.putAll((Map<?, ?>)System.getProperties());
        XmlConfiguration lastEnvConfiguration = null;
        XmlConfiguration lastCoreConfiguration = null;
        ArrayList<ContainerLifeCycle> objects = new ArrayList<ContainerLifeCycle>();
        ContainerLifeCycle mountContainer = new ContainerLifeCycle();
        objects.add(mountContainer);
        block27: for (int i = 0; i < args.length; ++i) {
            String arg;
            switch (arg = args[i]) {
                case "--env": {
                    String envName;
                    if (envBuilder != null) {
                        envBuilder.build();
                    }
                    if ((environment = Environment.get(envName = args[++i])) != null) {
                        throw new IllegalArgumentException("Duplicated --env " + envName + " command line arguments");
                    }
                    envBuilder = new EnvironmentBuilder(envName);
                    envProperties.clear();
                    lastEnvConfiguration = null;
                    continue block27;
                }
                case "--class-path": 
                case "-cp": {
                    envBuilder.addClassPath(args[++i]);
                    continue block27;
                }
                case "--module-path": 
                case "-p": {
                    envBuilder.addModulePath(args[++i]);
                    continue block27;
                }
                case "--add-modules": {
                    envBuilder.addModules(args[++i]);
                    continue block27;
                }
                case "--patch-module": {
                    envBuilder.patchModule(args[++i]);
                    continue block27;
                }
                case "--add-opens": {
                    envBuilder.addOpens(args[++i]);
                    continue block27;
                }
                case "--add-exports": {
                    envBuilder.addExports(args[++i]);
                    continue block27;
                }
                case "--add-reads": {
                    envBuilder.addReads(args[++i]);
                    continue block27;
                }
                default: {
                    if (envBuilder != null) {
                        environment = envBuilder.build();
                        envBuilder = null;
                    }
                    if (arg.startsWith("-")) {
                        throw new IllegalArgumentException("unknown arg " + arg);
                    }
                    if (arg.indexOf(61) >= 0) {
                        int equals = arg.indexOf(61);
                        String name = arg.substring(0, equals);
                        String string = arg.substring(equals + 1);
                        (environment == null ? coreProperties : envProperties).put(name, string);
                        continue block27;
                    }
                    if (arg.toLowerCase(Locale.ENGLISH).endsWith(".properties")) {
                        Resource resource = ResourceFactory.of(mountContainer).newResource(arg);
                        try (Iterator<Object> inputStream = Files.newInputStream(resource.getPath(), StandardOpenOption.READ);){
                            (environment == null ? coreProperties : envProperties).load((InputStream)((Object)inputStream));
                            continue block27;
                        }
                    }
                    if (arg.toLowerCase(Locale.ENGLISH).endsWith(".xml")) {
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("Parsing xml file {}", (Object)arg);
                        }
                        XmlConfiguration configuration = new XmlConfiguration(ResourceFactory.of(mountContainer).newResource(arg));
                        if (lastCoreConfiguration != null) {
                            configuration.getIdMap().putAll(lastCoreConfiguration.getIdMap());
                        }
                        if (lastEnvConfiguration != null) {
                            configuration.getIdMap().putAll(lastEnvConfiguration.getIdMap());
                        }
                        if (environment != null) {
                            configuration.getIdMap().put("Environment", environment);
                        }
                        for (Object e2 : coreProperties.keySet()) {
                            configuration.getProperties().put(String.valueOf(e2), String.valueOf(coreProperties.get(e2)));
                        }
                        for (Object object : envProperties.keySet()) {
                            configuration.getProperties().put(String.valueOf(object), String.valueOf(envProperties.get(object)));
                        }
                        if (environment == null) {
                            lastCoreConfiguration = configuration;
                        } else {
                            lastEnvConfiguration = configuration;
                        }
                        Runnable configure = () -> {
                            try {
                                Object obj = configuration.configure();
                                if (obj != null && !objects.contains(obj)) {
                                    objects.add((ContainerLifeCycle)obj);
                                }
                            }
                            catch (Exception e2) {
                                throw new RuntimeException(e2);
                            }
                        };
                        if (environment == null) {
                            configure.run();
                            continue block27;
                        }
                        environment.run(configure);
                        continue block27;
                    }
                    throw new IllegalArgumentException(arg);
                }
            }
        }
        if (envBuilder != null) {
            envBuilder.build();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("objects={}", (Object)objects);
        }
        ArrayList<LifeCycle> started = new ArrayList<LifeCycle>(objects.size());
        for (Object e3 : objects) {
            LifeCycle lifeCycle;
            if (!(e3 instanceof LifeCycle) || (lifeCycle = (LifeCycle)e3).isRunning()) continue;
            lifeCycle.start();
            if (lifeCycle.isStarted()) {
                started.add(lifeCycle);
                continue;
            }
            Collections.reverse(started);
            for (LifeCycle slc : started) {
                slc.stop();
            }
        }
    }

    private static class ConfigurationParser
    extends XmlParser
    implements Closeable {
        private final Pool.Entry<ConfigurationParser> _entry;

        private ConfigurationParser(Pool.Entry<ConfigurationParser> entry) {
            this._entry = entry;
            URL catalogUrl = XmlConfiguration.class.getResource("catalog-configure.xml");
            if (catalogUrl == null) {
                throw new IllegalStateException("Catalog not found: catalog-configure.xml");
            }
            this.addCatalog(URI.create(catalogUrl.toExternalForm()));
        }

        @Override
        protected SAXParserFactory newSAXParserFactory() {
            SAXParserFactory factory = SAXParserFactory.newDefaultInstance();
            ConfigurationParser.setFeature(factory, "http://javax.xml.XMLConstants/feature/secure-processing", true);
            factory.setXIncludeAware(false);
            return factory;
        }

        @Override
        protected void configure(SAXParser saxParser) {
            try {
                XMLReader xmlReader = this.getSAXParser().getXMLReader();
                ConfigurationParser.setFeature(xmlReader, "http://xml.org/sax/features/external-general-entities", false);
                ConfigurationParser.setFeature(xmlReader, "http://xml.org/sax/features/external-parameter-entities", false);
                ConfigurationParser.setFeature(xmlReader, "http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
            }
            catch (SAXException e2) {
                LOG.warn(e2.getMessage());
            }
        }

        @Override
        public void close() {
            if (this._entry != null) {
                this._entry.release();
            }
        }
    }

    private static class JettyXmlConfiguration
    implements ConfigurationProcessor {
        XmlParser.Node _root;
        XmlConfiguration _configuration;

        private JettyXmlConfiguration() {
        }

        @Override
        public void init(Resource resource, XmlParser.Node root2, XmlConfiguration configuration) {
            this._root = root2;
            this._configuration = configuration;
        }

        @Override
        public Object configure(Object obj) throws Exception {
            Class<?> oClass = JettyXmlConfiguration.nodeClass(this._root);
            if (oClass != null && !oClass.isInstance(obj)) {
                String loaders = oClass.getClassLoader() == obj.getClass().getClassLoader() ? "" : "Object Class and type Class are from different loaders.";
                throw new IllegalArgumentException("Object of class '" + obj.getClass().getCanonicalName() + "' is not of type '" + oClass.getCanonicalName() + "'. " + loaders);
            }
            String id = this._root.getAttribute("id");
            if (id != null) {
                this._configuration.getIdMap().put(id, obj);
            }
            AttrOrElementNode aoeNode = new AttrOrElementNode(obj, this._root, "Id", "Class", "Arg");
            aoeNode.getNodes("Arg").forEach(node -> LOG.warn("Ignored arg {} in {}", node, (Object)this._configuration));
            this.configure(obj, this._root, aoeNode.getNext());
            return obj;
        }

        /*
         * Unable to fully structure code
         * Could not resolve type clashes
         */
        @Override
        public Object configure() throws Exception {
            aoeNode = new AttrOrElementNode(this._root, new String[]{"Id", "Class", "Arg"});
            id = aoeNode.getString("Id");
            clazz = aoeNode.getString("Class");
            v0 = obj = id == null ? null : this._configuration.getIdMap().get(id);
            v1 /* !! */  = clazz != null ? Loader.loadClass(clazz) : (oClass = obj == null ? null : obj.getClass());
            if (XmlConfiguration.LOG.isDebugEnabled()) {
                XmlConfiguration.LOG.debug("Configure {} {}", (Object)oClass, obj);
            }
            if (obj == null && oClass != null) {
                try {
                    obj = this.construct(oClass, new Args(null, oClass, aoeNode.getNodes("Arg")));
                    if (id == null) ** GOTO lbl18
                    this._configuration.getIdMap().put(id, obj);
                }
                catch (NoSuchMethodException x) {
                    throw new IllegalStateException("No matching constructor " + String.valueOf(oClass));
                }
            } else {
                aoeNode.getNodes("Arg").forEach((Consumer<XmlParser.Node>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, lambda$configure$1(org.eclipse.jetty.xml.XmlParser$Node ), (Lorg/eclipse/jetty/xml/XmlParser$Node;)V)((JettyXmlConfiguration)this));
            }
lbl18:
            // 3 sources

            this._configuration.initializeDefaults(obj);
            this.configure(obj, this._root, aoeNode.getNext());
            return obj;
        }

        private static Class<?> nodeClass(XmlParser.Node node) throws ClassNotFoundException {
            String className = node.getAttribute("class");
            if (className == null) {
                return null;
            }
            return Loader.loadClass(className);
        }

        public void configure(Object obj, XmlParser.Node cfg, int i) throws Exception {
            while (i < cfg.size()) {
                Object o = cfg.get(i);
                if (!(o instanceof String)) {
                    XmlParser.Node node = (XmlParser.Node)o;
                    try {
                        String tag;
                        switch (tag = node.getTag()) {
                            case "Arg": 
                            case "Class": 
                            case "Id": {
                                throw new IllegalStateException("Element '" + tag + "' not skipped");
                            }
                            case "Set": {
                                this.set(obj, node);
                                break;
                            }
                            case "Put": {
                                this.put(obj, node);
                                break;
                            }
                            case "Call": {
                                this.call(obj, node);
                                break;
                            }
                            case "Get": {
                                this.get(obj, node);
                                break;
                            }
                            case "New": {
                                this.newObj(obj, node);
                                break;
                            }
                            case "Array": {
                                this.newArray(obj, node);
                                break;
                            }
                            case "Map": {
                                this.newMap(obj, node);
                                break;
                            }
                            case "Ref": {
                                this.refObj(node);
                                break;
                            }
                            case "Property": {
                                this.propertyObj(node);
                                break;
                            }
                            case "SystemProperty": {
                                this.systemPropertyObj(node);
                                break;
                            }
                            case "Env": {
                                this.envObj(node);
                                break;
                            }
                            default: {
                                throw new IllegalStateException("Unknown tag: " + tag);
                            }
                        }
                    }
                    catch (Exception e2) {
                        LOG.warn("Config error {} at {} in {}", e2, node, this._configuration);
                        throw e2;
                    }
                }
                ++i;
            }
        }

        /*
         * Exception decompiling
         */
        private void set(Object obj, XmlParser.Node node) throws Exception {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        private Object invokeConstructor(Constructor<?> constructor, Object ... args) throws IllegalAccessException, InvocationTargetException, InstantiationException {
            Object result = constructor.newInstance(args);
            if (constructor.getAnnotation(Deprecated.class) != null) {
                LOG.warn("Deprecated constructor {} in {}", (Object)constructor, (Object)this._configuration);
            }
            return result;
        }

        private Object invokeMethod(Method method, Object obj, Object ... args) throws IllegalAccessException, InvocationTargetException {
            Object result = method.invoke(obj, args);
            if (method.getAnnotation(Deprecated.class) != null) {
                LOG.warn("Deprecated method {} in {}", (Object)method, (Object)this._configuration);
            }
            return result;
        }

        private Object getField(Field field, Object object) throws IllegalAccessException {
            Object result = field.get(object);
            if (field.getAnnotation(Deprecated.class) != null) {
                LOG.warn("Deprecated field {} in {}", (Object)field, (Object)this._configuration);
            }
            return result;
        }

        private void setField(Field field, Object obj, Object arg) throws IllegalAccessException {
            field.set(obj, arg);
            if (field.getAnnotation(Deprecated.class) != null) {
                LOG.warn("Deprecated field {} in {}", (Object)field, (Object)this._configuration);
            }
        }

        private static Collection<?> convertArrayToCollection(Object array, Class<?> collectionType) {
            if (array == null) {
                return null;
            }
            AbstractCollection collection = null;
            if (array.getClass().isArray()) {
                if (collectionType.isAssignableFrom(ArrayList.class)) {
                    collection = JettyXmlConfiguration.convertArrayToArrayList(array);
                } else if (collectionType.isAssignableFrom(HashSet.class)) {
                    collection = new HashSet<Object>(JettyXmlConfiguration.convertArrayToArrayList(array));
                }
            }
            if (collection == null) {
                throw new IllegalArgumentException("Can't convert \"" + String.valueOf(array.getClass()) + "\" to " + String.valueOf(collectionType));
            }
            return collection;
        }

        private static ArrayList<Object> convertArrayToArrayList(Object array) {
            int length = Array.getLength(array);
            ArrayList<Object> list = new ArrayList<Object>(length);
            for (int i = 0; i < length; ++i) {
                list.add(Array.get(array, i));
            }
            return list;
        }

        private void put(Object obj, XmlParser.Node node) throws Exception {
            if (!(obj instanceof Map)) {
                throw new IllegalArgumentException("Object for put is not a Map: " + String.valueOf(obj));
            }
            Map map = (Map)obj;
            String name = node.getAttribute("name");
            Object value = this.value(obj, node);
            map.put(name, value);
            if (LOG.isDebugEnabled()) {
                LOG.debug("XML {}.put({},{})", obj, name, value);
            }
        }

        private Object get(Object obj, XmlParser.Node node) throws Exception {
            Class<?> oClass;
            AttrOrElementNode aoeNode = new AttrOrElementNode(obj, node, "Id", "Name", "Class");
            String id = aoeNode.getString("Id");
            String name = aoeNode.getString("Name");
            String clazz = aoeNode.getString("Class");
            if (clazz != null) {
                oClass = Loader.loadClass(clazz);
            } else if (obj != null) {
                oClass = obj.getClass();
            } else {
                throw new IllegalArgumentException(node.toString());
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("XML get {}", (Object)name);
            }
            try {
                if ("class".equalsIgnoreCase(name)) {
                    obj = oClass;
                } else {
                    Method method = oClass.getMethod("get" + name.substring(0, 1).toUpperCase(Locale.ENGLISH) + name.substring(1), new Class[0]);
                    obj = this.invokeMethod(method, obj, new Object[0]);
                }
                if (id != null) {
                    this._configuration.getIdMap().put(id, obj);
                }
                this.configure(obj, node, aoeNode.getNext());
            }
            catch (NoSuchMethodException nsme1) {
                try {
                    Method method = oClass.getMethod("is" + name.substring(0, 1).toUpperCase(Locale.ENGLISH) + name.substring(1), new Class[0]);
                    obj = this.invokeMethod(method, obj, new Object[0]);
                    if (id != null) {
                        this._configuration.getIdMap().put(id, obj);
                    }
                    this.configure(obj, node, aoeNode.getNext());
                }
                catch (NoSuchMethodException nsme2) {
                    Field field = oClass.getField(name);
                    obj = this.getField(field, obj);
                    if (id != null) {
                        this._configuration.getIdMap().put(id, obj);
                    }
                    this.configure(obj, node, aoeNode.getNext());
                }
            }
            return obj;
        }

        private Object call(Object obj, XmlParser.Node node) throws Exception {
            Class<?> oClass;
            AttrOrElementNode aoeNode = new AttrOrElementNode(obj, node, "Id", "Name", "Class", "Arg");
            String id = aoeNode.getString("Id");
            String name = aoeNode.getString("Name");
            String clazz = aoeNode.getString("Class");
            if (clazz != null) {
                oClass = Loader.loadClass(clazz);
            } else if (obj != null) {
                oClass = obj.getClass();
            } else {
                throw new IllegalArgumentException(node.toString());
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("XML call {}", (Object)name);
            }
            try {
                Object nobj = this.call(oClass, name, obj, new Args(obj, oClass, aoeNode.getNodes("Arg")));
                if (id != null) {
                    this._configuration.getIdMap().put(id, nobj);
                }
                this.configure(nobj, node, aoeNode.getNext());
                return nobj;
            }
            catch (NoSuchMethodException e2) {
                throw new IllegalStateException("No Method: " + String.valueOf(node) + " on " + String.valueOf(oClass), e2);
            }
        }

        private Object call(Class<?> oClass, String methodName, Object obj, Args args) throws InvocationTargetException, NoSuchMethodException {
            Method[] methods;
            Objects.requireNonNull(oClass, "Class cannot be null");
            Objects.requireNonNull(methodName, "Method name cannot be null");
            if (StringUtil.isBlank(methodName)) {
                throw new IllegalArgumentException("Method name cannot be blank");
            }
            for (Method method : methods = (Method[])Arrays.stream(oClass.getMethods()).filter(m -> m.getName().equals(methodName)).sorted(EXECUTABLE_COMPARATOR).toArray(Method[]::new)) {
                Object[] arguments;
                if (!method.getName().equals(methodName) || (arguments = args.applyTo(method)) == null) continue;
                try {
                    return this.invokeMethod(method, obj, arguments);
                }
                catch (IllegalAccessException | IllegalArgumentException e2) {
                    LOG.trace("IGNORED", e2);
                }
            }
            throw new NoSuchMethodException(String.valueOf(obj) + " . " + methodName + "(" + String.valueOf(args) + ")");
        }

        private Object newObj(Object obj, XmlParser.Node node) throws Exception {
            Object nobj;
            AttrOrElementNode aoeNode = new AttrOrElementNode(obj, node, "Id", "Class", "Arg");
            String id = aoeNode.getString("Id");
            String clazz = aoeNode.getString("Class");
            if (LOG.isDebugEnabled()) {
                LOG.debug("XML new {}", (Object)clazz);
            }
            Class oClass = Loader.loadClass(clazz);
            try {
                nobj = this.construct(oClass, new Args(obj, oClass, aoeNode.getNodes("Arg")));
            }
            catch (NoSuchMethodException e2) {
                throw new IllegalStateException("No suitable constructor: " + String.valueOf(node) + " on " + String.valueOf(obj));
            }
            if (id != null) {
                this._configuration.getIdMap().put(id, nobj);
            }
            this._configuration.initializeDefaults(nobj);
            this.configure(nobj, node, aoeNode.getNext());
            return nobj;
        }

        private Object construct(Class<?> klass, Args args) throws InvocationTargetException, NoSuchMethodException {
            Objects.requireNonNull(klass, "Class cannot be null");
            Objects.requireNonNull(args, "Named list cannot be null");
            Constructor<?>[] constructors = klass.getConstructors();
            Arrays.sort(constructors, EXECUTABLE_COMPARATOR);
            for (Constructor<?> constructor : constructors) {
                try {
                    Object[] arguments = args.applyTo(constructor);
                    if (arguments == null) continue;
                    return this.invokeConstructor(constructor, arguments);
                }
                catch (IllegalAccessException | IllegalArgumentException | InstantiationException e2) {
                    LOG.trace("IGNORED", e2);
                }
            }
            throw new NoSuchMethodException("<init>");
        }

        private Object refObj(XmlParser.Node node) throws Exception {
            Object obj;
            AttrOrElementNode aoeNode = new AttrOrElementNode(node, "Id");
            String refid = aoeNode.getString("Id");
            if (refid == null) {
                refid = node.getAttribute("refid");
            }
            if ((obj = this._configuration.getIdMap().get(refid)) == null && node.size() > 0) {
                throw new IllegalStateException("No object for refid=" + refid);
            }
            this.configure(obj, node, aoeNode.getNext());
            return obj;
        }

        private Object newArray(Object obj, XmlParser.Node node) throws Exception {
            AttrOrElementNode aoeNode = new AttrOrElementNode(obj, node, "Id", "Type", "Item");
            String id = aoeNode.getString("Id");
            String type = aoeNode.getString("Type");
            List<XmlParser.Node> items = aoeNode.getNodes("Item");
            Class aClass = Object.class;
            if (type != null && (aClass = TypeUtil.fromName(type)) == null) {
                switch (type) {
                    case "String": {
                        aClass = String.class;
                        break;
                    }
                    case "URL": {
                        aClass = URL.class;
                        break;
                    }
                    case "InetAddress": {
                        aClass = InetAddress.class;
                        break;
                    }
                    default: {
                        aClass = Loader.loadClass(type);
                    }
                }
            }
            Object al = null;
            for (XmlParser.Node item : items) {
                String nid = item.getAttribute("id");
                Object v = this.value(obj, item);
                al = LazyList.add(al, v == null && aClass.isPrimitive() ? Integer.valueOf(0) : v);
                if (nid == null) continue;
                this._configuration.getIdMap().put(nid, v);
            }
            Object array = LazyList.toArray(al, aClass);
            if (id != null) {
                this._configuration.getIdMap().put(id, array);
            }
            return array;
        }

        private Object newMap(Object obj, XmlParser.Node node) throws Exception {
            AttrOrElementNode aoeNode = new AttrOrElementNode(node, "Id", "Entry", "Class");
            String id = aoeNode.getString("Id");
            List<XmlParser.Node> entries = aoeNode.getNodes("Entry");
            String clazz = aoeNode.getString("Class");
            if (clazz == null) {
                clazz = HashMap.class.getName();
            }
            Class oClass = Loader.loadClass(clazz);
            Map map = (Map)oClass.getConstructor(new Class[0]).newInstance(new Object[0]);
            if (id != null) {
                this._configuration.getIdMap().put(id, map);
            }
            for (XmlParser.Node entry : entries) {
                if (!entry.getTag().equals("Entry")) {
                    throw new IllegalStateException("Not an Entry");
                }
                XmlParser.Node key = null;
                XmlParser.Node value = null;
                for (Object object : entry) {
                    if (object instanceof String) continue;
                    XmlParser.Node item = (XmlParser.Node)object;
                    if (!item.getTag().equals("Item")) {
                        throw new IllegalStateException("Not an Item");
                    }
                    if (key == null) {
                        key = item;
                        continue;
                    }
                    value = item;
                }
                if (key == null || value == null) {
                    throw new IllegalStateException("Missing Item in Entry");
                }
                String kid = key.getAttribute("id");
                String vid = value.getAttribute("id");
                Object k = this.value(obj, key);
                Object v = this.value(obj, value);
                map.put(k, v);
                if (kid != null) {
                    this._configuration.getIdMap().put(kid, k);
                }
                if (vid == null) continue;
                this._configuration.getIdMap().put(vid, v);
            }
            return map;
        }

        private Object propertyObj(XmlParser.Node node) throws Exception {
            AttrOrElementNode aoeNode = new AttrOrElementNode(node, "Id", "Name", "Deprecated", "Default");
            String id = aoeNode.getString("Id");
            String name = aoeNode.getString("Name", false);
            List<Object> deprecated = aoeNode.getList("Deprecated");
            String dftValue = aoeNode.getString("Default");
            if (name == null && deprecated.isEmpty()) {
                throw new IllegalStateException("Invalid <Property> element");
            }
            Map<String, String> properties = this._configuration.getProperties();
            String value = name == null ? null : properties.get(name);
            String alternate = null;
            if (!deprecated.isEmpty()) {
                for (Object d : deprecated) {
                    if (d == null) continue;
                    String v = properties.get(d.toString());
                    if (v != null) {
                        if (value == null) {
                            if (name == null) {
                                LOG.warn("Property '{}' is deprecated, no replacement available", d);
                            } else {
                                LOG.warn("Property '{}' is deprecated, use '{}' instead", d, (Object)name);
                            }
                        } else {
                            LOG.warn("Property '{}' is deprecated, value from '{}' used instead", d, (Object)name);
                        }
                    }
                    if (alternate != null) continue;
                    alternate = v;
                }
            }
            if (value == null) {
                value = alternate;
            }
            if (value == null) {
                value = dftValue;
            }
            if (id != null) {
                this._configuration.getIdMap().put(id, value);
            }
            return value;
        }

        private Object systemPropertyObj(XmlParser.Node node) throws Exception {
            AttrOrElementNode aoeNode = new AttrOrElementNode(node, "Id", "Name", "Deprecated", "Default");
            String id = aoeNode.getString("Id");
            String name = aoeNode.getString("Name", false);
            List<Object> deprecated = aoeNode.getList("Deprecated");
            String dftValue = aoeNode.getString("Default");
            if (name == null && deprecated.isEmpty()) {
                throw new IllegalStateException("Invalid <SystemProperty> element");
            }
            String value = name == null ? null : System.getProperty(name);
            String alternate = null;
            if (!deprecated.isEmpty()) {
                for (Object d : deprecated) {
                    if (d == null) continue;
                    String v = System.getProperty(d.toString());
                    if (v != null) {
                        if (value == null) {
                            if (name == null) {
                                LOG.warn("SystemProperty '{}' is deprecated, no replacement available", d);
                            } else {
                                LOG.warn("SystemProperty '{}' is deprecated, use '{}' instead", d, (Object)name);
                            }
                        } else {
                            LOG.warn("SystemProperty '{}' is deprecated, value from '{}' used", d, (Object)name);
                        }
                    }
                    if (alternate != null) continue;
                    alternate = v;
                }
            }
            if (value == null) {
                value = alternate;
            }
            if (value == null) {
                value = dftValue;
            }
            if (id != null) {
                this._configuration.getIdMap().put(id, value);
            }
            return value;
        }

        private Object envObj(XmlParser.Node node) throws Exception {
            String value;
            AttrOrElementNode aoeNode = new AttrOrElementNode(node, "Id", "Name", "Deprecated", "Default");
            String id = aoeNode.getString("Id");
            String name = aoeNode.getString("Name", false);
            List<Object> deprecated = aoeNode.getList("Deprecated");
            String dftValue = aoeNode.getString("Default");
            if (name == null && deprecated.isEmpty()) {
                throw new IllegalStateException("Invalid <Env> element");
            }
            String string = value = name == null ? null : System.getenv(name);
            if (value == null && !deprecated.isEmpty()) {
                for (Object d : deprecated) {
                    if (d == null || (value = System.getenv(d.toString())) == null) continue;
                    if (name == null) {
                        LOG.warn("Property '{}' is deprecated, no replacement available", d);
                        break;
                    }
                    LOG.warn("Property '{}' is deprecated, use '{}' instead", d, (Object)name);
                    break;
                }
            }
            if (value == null) {
                value = dftValue;
            }
            if (id != null) {
                this._configuration.getIdMap().put(id, value);
            }
            return value;
        }

        private Object value(Object obj, XmlParser.Node node) throws Exception {
            Object value;
            String type = node.getAttribute("type");
            String ref = node.getAttribute("ref");
            if (ref != null) {
                value = this._configuration.getIdMap().get(ref);
            } else {
                if (node.size() == 0) {
                    if ("String".equals(type)) {
                        return "";
                    }
                    return null;
                }
                int last = node.size() - 1;
                if ("String".equals(type)) {
                    if (first == last) {
                        value = this.itemValue(obj, node.get(first));
                    } else {
                        StringBuilder buf = new StringBuilder();
                        for (int i = first; i <= last; ++i) {
                            Object item = node.get(i);
                            buf.append(this.itemValue(obj, item));
                        }
                        value = buf.toString();
                    }
                } else {
                    Object item;
                    for (first = 0; first <= last && (item = node.get(first)) instanceof String && ((String)item).trim().length() <= 0; ++first) {
                    }
                    while (first < last && (item = node.get(last)) instanceof String && ((String)item).trim().length() <= 0) {
                        --last;
                    }
                    if (first > last) {
                        return null;
                    }
                    if (first == last) {
                        value = this.itemValue(obj, node.get(first));
                        if (value instanceof String) {
                            value = ((String)value).trim();
                        }
                    } else {
                        StringBuilder buf = new StringBuilder();
                        for (int i = first; i <= last; ++i) {
                            buf.append(this.itemValue(obj, node.get(i)));
                        }
                        value = buf.toString().trim();
                    }
                }
            }
            return this.toType(value, type);
        }

        private Object toType(Object value, String type) throws Exception {
            if (value == null) {
                if ("String".equals(type)) {
                    return "";
                }
                return null;
            }
            if (type == null) {
                return value;
            }
            if (JettyXmlConfiguration.isTypeMatchingClass(type, String.class)) {
                return value.toString();
            }
            Class<?> pClass = TypeUtil.fromName(type);
            if (pClass != null) {
                return TypeUtil.valueOf(pClass, value.toString());
            }
            if (JettyXmlConfiguration.isTypeMatchingClass(type, URL.class)) {
                if (value instanceof URL) {
                    return value;
                }
                try {
                    return new URL(value.toString());
                }
                catch (MalformedURLException e2) {
                    throw new InvocationTargetException(e2);
                }
            }
            if (JettyXmlConfiguration.isTypeMatchingClass(type, InetAddress.class)) {
                if (value instanceof InetAddress) {
                    return value;
                }
                try {
                    return InetAddress.getByName(value.toString());
                }
                catch (UnknownHostException e3) {
                    throw new InvocationTargetException(e3);
                }
            }
            for (Class<?> collectionClass : SUPPORTED_COLLECTIONS) {
                if (!JettyXmlConfiguration.isTypeMatchingClass(type, collectionClass)) continue;
                return JettyXmlConfiguration.convertArrayToCollection(value, collectionClass);
            }
            throw new IllegalStateException("Unknown type " + type);
        }

        private static boolean isTypeMatchingClass(String type, Class<?> classToMatch) {
            return classToMatch.getSimpleName().equalsIgnoreCase(type) || classToMatch.getName().equals(type);
        }

        private Object itemValue(Object obj, Object item) throws Exception {
            if (item instanceof String) {
                return item;
            }
            XmlParser.Node node = (XmlParser.Node)item;
            String tag = node.getTag();
            if ("Call".equals(tag)) {
                return this.call(obj, node);
            }
            if ("Get".equals(tag)) {
                return this.get(obj, node);
            }
            if ("New".equals(tag)) {
                return this.newObj(obj, node);
            }
            if ("Ref".equals(tag)) {
                return this.refObj(node);
            }
            if ("Array".equals(tag)) {
                return this.newArray(obj, node);
            }
            if ("Map".equals(tag)) {
                return this.newMap(obj, node);
            }
            if ("Property".equals(tag)) {
                return this.propertyObj(node);
            }
            if ("SystemProperty".equals(tag)) {
                return this.systemPropertyObj(node);
            }
            if ("Env".equals(tag)) {
                return this.envObj(node);
            }
            LOG.warn("Unknown value tag: {} in {}", node, this._configuration, new Throwable());
            return null;
        }

        private static /* synthetic */ boolean lambda$set$3(String name, Field f) {
            return f.getName().equals(name);
        }

        private static /* synthetic */ boolean lambda$set$2(Field f) {
            return Modifier.isPublic(f.getModifiers());
        }

        private static /* synthetic */ boolean lambda$set$1(String name, Method m) {
            return m.getName().equals(name);
        }

        private static /* synthetic */ boolean lambda$set$0(String setter, Method m) {
            return m.getName().equals(setter);
        }

        private /* synthetic */ void lambda$configure$1(XmlParser.Node node) {
            LOG.warn("Ignored arg {} in {}", (Object)node, (Object)this._configuration);
        }

        private class AttrOrElementNode {
            final Object _obj;
            final XmlParser.Node _node;
            final Set<String> _elements = new HashSet<String>();
            final int _next;

            AttrOrElementNode(XmlParser.Node node, String ... elements) {
                this(null, node, elements);
            }

            AttrOrElementNode(Object obj, XmlParser.Node node, String ... elements) {
                this._obj = obj;
                this._node = node;
                Collections.addAll(this._elements, elements);
                int next = 0;
                for (Object o : this._node) {
                    XmlParser.Node n;
                    if (o instanceof String) {
                        if (((String)o).trim().length() != 0) break;
                        ++next;
                        continue;
                    }
                    if (!(o instanceof XmlParser.Node) || !this._elements.contains((n = (XmlParser.Node)o).getTag())) break;
                    ++next;
                }
                this._next = next;
            }

            public int getNext() {
                return this._next;
            }

            public String getString(String elementName) throws Exception {
                return StringUtil.valueOf(this.get(elementName, false));
            }

            public String getString(String elementName, boolean mandatory) throws Exception {
                return StringUtil.valueOf(this.get(elementName, mandatory));
            }

            public Object get(String elementName, boolean mandatory) throws Exception {
                String attrName = StringUtil.asciiToLowerCase(elementName);
                String attr = this._node.getAttribute(attrName);
                Object value = attr;
                for (int i = 0; i < this._next; ++i) {
                    XmlParser.Node n;
                    Object o = this._node.get(i);
                    if (!(o instanceof XmlParser.Node) || !elementName.equals((n = (XmlParser.Node)o).getTag())) continue;
                    if (attr != null) {
                        throw new IllegalStateException("Cannot have attr '" + attrName + "' and element '" + elementName + "'");
                    }
                    value = JettyXmlConfiguration.this.value(this._obj, n);
                    break;
                }
                if (mandatory && value == null) {
                    throw new IllegalStateException("Must have attr '" + attrName + "' or element '" + elementName + "'");
                }
                return value;
            }

            public List<Object> getList(String elementName) throws Exception {
                return this.getList(elementName, false);
            }

            public List<Object> getList(String elementName, boolean manditory) throws Exception {
                String attrName = StringUtil.asciiToLowerCase(elementName);
                ArrayList<Object> values = new ArrayList<Object>();
                String attr = this._node.getAttribute(attrName);
                if (attr != null) {
                    values.addAll(StringUtil.csvSplit(null, attr, 0, attr.length()));
                }
                for (int i = 0; i < this._next; ++i) {
                    XmlParser.Node n;
                    Object o = this._node.get(i);
                    if (!(o instanceof XmlParser.Node) || !elementName.equals((n = (XmlParser.Node)o).getTag())) continue;
                    if (attr != null) {
                        throw new IllegalStateException("Cannot have attr '" + attrName + "' and element '" + elementName + "'");
                    }
                    values.add(JettyXmlConfiguration.this.value(this._obj, n));
                }
                if (manditory && values.isEmpty()) {
                    throw new IllegalStateException("Must have attr '" + attrName + "' or element '" + elementName + "'");
                }
                return values;
            }

            public List<XmlParser.Node> getNodes(String elementName) {
                return XmlConfiguration.getNodes(this._node, elementName);
            }
        }

        private class Args {
            private final Class<?> _class;
            private final List<Object> _arguments;
            private final List<String> _names;

            private Args(Object obj, Class<?> oClass, List<XmlParser.Node> args) throws Exception {
                this._class = oClass;
                this._arguments = new ArrayList<Object>();
                this._names = new ArrayList<String>();
                for (XmlParser.Node child : args) {
                    this._arguments.add(JettyXmlConfiguration.this.value(obj, child));
                    this._names.add(child.getAttribute("name"));
                }
            }

            private Args(List<Object> arguments, List<String> names) {
                this._class = null;
                this._arguments = arguments;
                this._names = names;
            }

            Object[] applyTo(Executable executable) {
                int count;
                Object[] args = this.matchArgsToParameters(executable);
                if (args == null && this._class != null && (count = executable.getParameterCount()) > 0 && executable.getParameters()[count - 1].isVarArgs()) {
                    args = this.asEmptyVarArgs(executable.getParameterTypes()[count - 1]).matchArgsToParameters(executable);
                }
                return args;
            }

            Args asEmptyVarArgs(Class<?> varArgType) {
                ArrayList<Object> arguments = new ArrayList<Object>(this._arguments);
                arguments.add(Array.newInstance(varArgType.getComponentType(), 0));
                ArrayList<String> names = new ArrayList<String>(this._names);
                names.add(null);
                return new Args(arguments, names);
            }

            Object[] matchArgsToParameters(Executable executable) {
                Object[] args;
                int count = executable.getParameterCount();
                if (count != this._arguments.size()) {
                    return null;
                }
                if (count == 0) {
                    return new Object[0];
                }
                if (this._names.stream().noneMatch(Objects::nonNull)) {
                    args = this._arguments.toArray(new Object[0]);
                } else {
                    Annotation[][] parameterAnnotations = executable.getParameterAnnotations();
                    if (parameterAnnotations == null || parameterAnnotations.length == 0) {
                        return null;
                    }
                    HashMap position = new HashMap();
                    int p = 0;
                    for (Annotation[] paramAnnotation : parameterAnnotations) {
                        Integer pos = p++;
                        Arrays.stream(paramAnnotation).filter(Name.class::isInstance).map(Name.class::cast).findFirst().ifPresent(n -> position.put(n.value(), pos));
                    }
                    ArrayList<Object> arguments = new ArrayList<Object>(this._arguments);
                    ArrayList<String> names = new ArrayList<String>(this._names);
                    for (p = 0; p < count; ++p) {
                        String name = (String)names.get(p);
                        if (name == null) continue;
                        Integer pos = (Integer)position.get(name);
                        if (pos == null) {
                            return null;
                        }
                        if (pos == p) continue;
                        arguments.add(pos, arguments.remove(p));
                        names.add(pos, (String)names.remove(p));
                        p = Math.min(p, pos);
                    }
                    args = arguments.toArray(new Object[0]);
                }
                return args;
            }

            public String toString() {
                return "%s@%x%s%s".formatted(TypeUtil.toShortName(this.getClass()), this.hashCode(), this._names, this._arguments);
            }
        }
    }
}

