/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.riot.rowset.rw.rs_json;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Supplier;
import org.apache.jena.atlas.data.DataBag;
import org.apache.jena.atlas.iterator.IteratorCloseable;
import org.apache.jena.atlas.iterator.IteratorSlotted;
import org.apache.jena.datatypes.RDFDatatype;
import org.apache.jena.datatypes.TypeMapper;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.NodeFactory;
import org.apache.jena.riot.lang.LabelToNode;
import org.apache.jena.riot.rowset.rw.rs_json.ErrorEvent;
import org.apache.jena.riot.rowset.rw.rs_json.ErrorHandlers;
import org.apache.jena.riot.rowset.rw.rs_json.IteratorRsJSON;
import org.apache.jena.riot.rowset.rw.rs_json.RowSetBuffered;
import org.apache.jena.riot.rowset.rw.rs_json.RsJsonEltEncoder;
import org.apache.jena.riot.rowset.rw.rs_json.ValidationSettings;
import org.apache.jena.riot.system.ErrorHandler;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.engine.binding.Binding;
import org.apache.jena.sparql.engine.binding.BindingBuilder;
import org.apache.jena.sparql.engine.binding.BindingFactory;
import org.apache.jena.sparql.exec.RowSet;
import org.apache.jena.sparql.resultset.ResultSetException;
import org.apache.jena.vocabulary.RDF;

public class RowSetJSONStreaming<E>
extends IteratorSlotted<Binding>
implements RowSet {
    protected IteratorCloseable<E> eltIterator;
    protected RsJsonEltDecoder<? super E> eltDecoder;
    protected long rowNumber;
    protected ValidationSettings validationSettings;
    protected ErrorHandler errorHandler;
    protected TentativeValue<List<Var>> resultVars = null;
    protected TentativeValue<Boolean> askResult = null;
    protected int kHeadCount = 0;
    protected int kResultsCount = 0;
    protected int kBooleanCount = 0;
    protected int unknownJsonCount = 0;

    public static RowSetBuffered<RowSetJSONStreaming<?>> createBuffered(InputStream in, LabelToNode labelMap, Supplier<DataBag<Binding>> bufferFactory, ValidationSettings validationSettings, ErrorHandler errorHandler) {
        return new RowSetBuffered(RowSetJSONStreaming.createUnbuffered(in, labelMap, validationSettings, errorHandler), bufferFactory);
    }

    public static RowSetJSONStreaming<?> createUnbuffered(InputStream in, LabelToNode labelMap, ValidationSettings validationSettings, ErrorHandler errorHandler) {
        Gson gson = new Gson();
        JsonReader reader = gson.newJsonReader(new InputStreamReader(in, StandardCharsets.UTF_8));
        UnexpectedJsonEltHandler unexpectedJsonHandler = (_gson, _reader) -> {
            ErrorHandlers.relay(errorHandler, validationSettings.unexpectedJsonElementSeverity, () -> new ErrorEvent("Encountered unexpected json element at path " + reader.getPath()));
            reader.skipValue();
            return null;
        };
        RsJsonEltEncoderDft eltEncoder = new RsJsonEltEncoderDft(labelMap, null, unexpectedJsonHandler);
        RsJsonEltDecoderDft eltDecoder = RsJsonEltDecoderDft.INSTANCE;
        IteratorRsJSON<RsJsonEltDft> eltIt = new IteratorRsJSON<RsJsonEltDft>(gson, reader, eltEncoder);
        RowSetJSONStreaming<RsJsonEltDft> result = new RowSetJSONStreaming<RsJsonEltDft>(eltIt, eltDecoder, 0L, validationSettings, errorHandler);
        return result;
    }

    private RowSetJSONStreaming(IteratorCloseable<E> rsJsonIterator, RsJsonEltDecoder<? super E> eltDecoder, long rowNumber, ValidationSettings validationSettings, ErrorHandler errorHandler) {
        this.eltIterator = rsJsonIterator;
        this.eltDecoder = eltDecoder;
        this.rowNumber = rowNumber;
        this.validationSettings = validationSettings;
        this.errorHandler = errorHandler;
        this.resultVars = new TentativeValue();
        this.askResult = new TentativeValue();
    }

    @Override
    protected Binding moveToNext() {
        try {
            Binding result = this.computeNextActual();
            return result;
        }
        catch (Throwable e2) {
            throw new ResultSetException(e2.getMessage(), e2);
        }
    }

    protected Binding computeNextActual() throws IOException {
        Binding result = null;
        Object elt = null;
        RsJsonEltType type = null;
        block7: while (this.eltIterator.hasNext()) {
            elt = this.eltIterator.next();
            type = this.eltDecoder.getType(elt);
            switch (type.ordinal()) {
                case 1: {
                    ++this.kHeadCount;
                    List<Var> rsv = this.eltDecoder.getAsHead(elt);
                    boolean updateAccepted = this.resultVars.updateValue(rsv);
                    if (!updateAccepted) {
                        ErrorHandlers.relay(this.errorHandler, this.validationSettings.getInvalidatedHeadSeverity(), new ErrorEvent(String.format("Prior value for headVars was %s but got superseded with %s", this.resultVars.getValue(), rsv)));
                    }
                    RowSetJSONStreaming.validate(this, this.errorHandler, this.validationSettings);
                    continue block7;
                }
                case 2: {
                    ++this.kBooleanCount;
                    Boolean b = this.eltDecoder.getAsBoolean(elt);
                    boolean updateAccepted = this.askResult.updateValue(b);
                    if (!updateAccepted) {
                        ErrorHandlers.relay(this.errorHandler, this.validationSettings.getInvalidatedHeadSeverity(), new ErrorEvent(String.format(". Prior value for boolean result was %s but got supersesed %s", this.askResult.getValue(), b)));
                    }
                    RowSetJSONStreaming.validate(this, this.errorHandler, this.validationSettings);
                    continue block7;
                }
                case 3: {
                    ++this.kResultsCount;
                    RowSetJSONStreaming.validate(this, this.errorHandler, this.validationSettings);
                    continue block7;
                }
                case 4: {
                    ++this.rowNumber;
                    result = this.eltDecoder.getAsBinding(elt);
                    break block7;
                }
                case 0: {
                    ++this.unknownJsonCount;
                    continue block7;
                }
                default: {
                    continue block7;
                }
            }
        }
        this.resultVars.makeFinal();
        this.askResult.makeFinal();
        if (result == null && !this.eltIterator.hasNext()) {
            RowSetJSONStreaming.validateCompleted(this, this.errorHandler, this.validationSettings);
        }
        return result;
    }

    @Override
    protected boolean hasMore() {
        return true;
    }

    @Override
    protected void closeIterator() {
        this.eltIterator.close();
    }

    @Override
    public long getRowNumber() {
        return this.rowNumber;
    }

    boolean hasResultVars() {
        return this.resultVars.hasValue();
    }

    @Override
    public List<Var> getResultVars() {
        return this.resultVars.getValue();
    }

    public boolean hasAskResult() {
        return this.askResult.hasValue();
    }

    public Boolean getAskResult() {
        return this.askResult.getValue();
    }

    public int getKHeadCount() {
        return this.kHeadCount;
    }

    public int getKBooleanCount() {
        return this.kBooleanCount;
    }

    public int getKResultsCount() {
        return this.kResultsCount;
    }

    public int getUnknownJsonCount() {
        return this.unknownJsonCount;
    }

    static List<Var> parseHeadVars(Gson gson, JsonReader reader) throws IOException {
        List<Var> result = null;
        Type stringListType = new TypeToken<List<String>>(){}.getType();
        JsonObject headJson = (JsonObject)gson.fromJson(reader, (Type)((Object)JsonObject.class));
        JsonElement varsJson = headJson.get("vars");
        if (varsJson != null) {
            List varNames = (List)gson.fromJson(varsJson, stringListType);
            result = Var.varList(varNames);
        }
        return result;
    }

    static Binding parseBinding(Gson gson, JsonReader reader, LabelToNode labelMap, Function<JsonObject, Node> onUnknownRdfTermType) throws IOException {
        JsonObject obj = (JsonObject)gson.fromJson(reader, (Type)((Object)JsonObject.class));
        BindingBuilder bb = BindingFactory.builder();
        for (Map.Entry<String, JsonElement> e2 : obj.entrySet()) {
            Var v = Var.alloc(e2.getKey());
            JsonElement nodeElt = e2.getValue();
            Node node = RowSetJSONStreaming.parseOneTerm(nodeElt, labelMap, onUnknownRdfTermType);
            bb.add(v, node);
        }
        return bb.build();
    }

    static Node parseOneTerm(JsonElement jsonElt, LabelToNode labelMap, Function<JsonObject, Node> onUnknownRdfTermType) {
        Node result;
        if (jsonElt == null) {
            throw new ResultSetException("Expected a json object for an RDF term but got null");
        }
        JsonObject term = jsonElt.getAsJsonObject();
        String type = RowSetJSONStreaming.expectNonNull(term, "type").getAsString();
        JsonElement valueJson = RowSetJSONStreaming.expectNonNull(term, "value");
        switch (type) {
            case "uri": {
                String valueStr = valueJson.getAsString();
                result = NodeFactory.createURI(valueStr);
                break;
            }
            case "typed-literal": 
            case "literal": {
                String dirStr;
                String valueStr = valueJson.getAsString();
                JsonElement langJson = term.get("xml:lang");
                JsonElement dtJson = term.get("datatype");
                JsonElement dirJson = term.get("its:dir");
                String lang = langJson == null ? null : langJson.getAsString();
                String dtStr = dtJson == null ? null : dtJson.getAsString();
                String string = dirStr = dirJson == null ? null : dirJson.getAsString();
                if (lang != null) {
                    if (dirStr != null) {
                        if (dtStr != null && !dtStr.equals(RDF.dtDirLangString.getURI())) {
                            throw new ResultSetException("Language, base direction and datatype defined, datatype is not rdf:dirLangString: " + String.valueOf(term));
                        }
                    } else if (dtStr != null && !dtStr.equals(RDF.dtLangString.getURI())) {
                        throw new ResultSetException("Language datatype defined, datatype is not rdf:langString: " + String.valueOf(term));
                    }
                } else if (dirStr != null) {
                    throw new ResultSetException("Base direction defined, but no language given: " + String.valueOf(term));
                }
                RDFDatatype dType = dtStr == null ? null : TypeMapper.getInstance().getSafeTypeByName(dtStr);
                result = NodeFactory.createLiteral(valueStr, lang, dirStr, dType);
                break;
            }
            case "bnode": {
                String valueStr = valueJson.getAsString();
                result = (Node)labelMap.get(null, valueStr);
                break;
            }
            case "statement": 
            case "triple": {
                JsonObject tripleJson = valueJson.getAsJsonObject();
                JsonElement js = RowSetJSONStreaming.expectOneKey(tripleJson, "subject", "s");
                JsonElement jp = RowSetJSONStreaming.expectOneKey(tripleJson, "predicate", "property", "p");
                JsonElement jo = RowSetJSONStreaming.expectOneKey(tripleJson, "object", "o");
                Node s = RowSetJSONStreaming.parseOneTerm(js, labelMap, onUnknownRdfTermType);
                Node p = RowSetJSONStreaming.parseOneTerm(jp, labelMap, onUnknownRdfTermType);
                Node o = RowSetJSONStreaming.parseOneTerm(jo, labelMap, onUnknownRdfTermType);
                result = NodeFactory.createTripleTerm(s, p, o);
                break;
            }
            default: {
                if (onUnknownRdfTermType != null) {
                    result = onUnknownRdfTermType.apply(term);
                    if (result != null) break;
                    throw new ResultSetException("Custom handler returned null for unknown rdf term type '" + type + "'");
                }
                throw new ResultSetException("Object key not recognized as valid for an RDF term: " + String.valueOf(term));
            }
        }
        return result;
    }

    static JsonElement expectNonNull(JsonObject json2, String key) {
        JsonElement v = json2.get(key);
        if (v == null) {
            throw new ResultSetException("Unexpected null value for key: " + key);
        }
        return v;
    }

    static JsonElement expectOneKey(JsonObject json2, String ... keys) {
        JsonElement result = null;
        for (String key : keys) {
            JsonElement tmp = json2.get(key);
            if (tmp == null) continue;
            if (result != null) {
                throw new ResultSetException("More than one key out of " + String.valueOf(Arrays.asList(keys)));
            }
            result = tmp;
        }
        if (result == null) {
            throw new ResultSetException("One or more of the required keys " + String.valueOf(Arrays.asList(keys)) + " was not found");
        }
        return result;
    }

    static void validate(RowSetJSONStreaming<?> rs, ErrorHandler errorHandler, ValidationSettings settings) {
        if (rs.hasAskResult() && rs.getKResultsCount() > 0) {
            ErrorHandlers.relay(errorHandler, settings.getMixedResultsSeverity(), () -> new ErrorEvent("Encountered bindings as well as boolean result"));
        }
        if (rs.getKResultsCount() > 1) {
            ErrorHandlers.relay(errorHandler, settings.getInvalidatedResultsSeverity(), () -> new ErrorEvent("Multiple 'results' keys encountered"));
        }
    }

    private static void validateCompleted(RowSetJSONStreaming<?> rs, ErrorHandler errorHandler, ValidationSettings settings) {
        if (rs.getKResultsCount() == 0 && rs.getKBooleanCount() == 0) {
            ErrorHandlers.relay(errorHandler, settings.getEmptyJsonSeverity(), new ErrorEvent(String.format("Either '%s' or '%s' is mandatory; neither seen", "results", "boolean")));
        }
        if (rs.getKHeadCount() == 0) {
            ErrorHandlers.relay(errorHandler, settings.getMissingHeadSeverity(), new ErrorEvent(String.format("Mandatory key '%s' not seen", "head")));
        }
    }

    @FunctionalInterface
    static interface UnexpectedJsonEltHandler {
        public JsonElement apply(Gson var1, JsonReader var2) throws IOException;
    }

    private static class RsJsonEltEncoderDft
    implements RsJsonEltEncoder<RsJsonEltDft> {
        protected LabelToNode labelMap;
        protected Function<JsonObject, Node> unknownRdfTermTypeHandler;
        protected UnexpectedJsonEltHandler unexpectedJsonHandler;

        public RsJsonEltEncoderDft(LabelToNode labelMap, Function<JsonObject, Node> unknownRdfTermTypeHandler, UnexpectedJsonEltHandler unexpectedJsonHandler) {
            this.labelMap = labelMap;
            this.unknownRdfTermTypeHandler = unknownRdfTermTypeHandler;
            this.unexpectedJsonHandler = unexpectedJsonHandler;
        }

        @Override
        public RsJsonEltDft newHeadElt(Gson gson, JsonReader reader) throws IOException {
            List<Var> vars = RowSetJSONStreaming.parseHeadVars(gson, reader);
            return new RsJsonEltDft(vars);
        }

        @Override
        public RsJsonEltDft newBooleanElt(Gson gson, JsonReader reader) throws IOException {
            Boolean b = reader.nextBoolean();
            return new RsJsonEltDft(b);
        }

        @Override
        public RsJsonEltDft newBindingElt(Gson gson, JsonReader reader) throws IOException {
            Binding binding = RowSetJSONStreaming.parseBinding(gson, reader, this.labelMap, this.unknownRdfTermTypeHandler);
            return new RsJsonEltDft(binding);
        }

        @Override
        public RsJsonEltDft newResultsElt(Gson gson, JsonReader reader) throws IOException {
            return new RsJsonEltDft(RsJsonEltType.RESULTS);
        }

        @Override
        public RsJsonEltDft newUnknownElt(Gson gson, JsonReader reader) throws IOException {
            JsonElement jsonElement = this.unexpectedJsonHandler == null ? null : this.unexpectedJsonHandler.apply(gson, reader);
            return new RsJsonEltDft(jsonElement);
        }
    }

    private static class RsJsonEltDecoderDft
    implements RsJsonEltDecoder<RsJsonEltDft> {
        static final RsJsonEltDecoderDft INSTANCE = new RsJsonEltDecoderDft();

        private RsJsonEltDecoderDft() {
        }

        @Override
        public RsJsonEltType getType(RsJsonEltDft elt) {
            return elt.getType();
        }

        @Override
        public Binding getAsBinding(RsJsonEltDft elt) {
            return elt.getBinding();
        }

        @Override
        public List<Var> getAsHead(RsJsonEltDft elt) {
            return elt.getHead();
        }

        @Override
        public Boolean getAsBoolean(RsJsonEltDft elt) {
            return elt.getAskResult();
        }
    }

    private static interface RsJsonEltDecoder<E> {
        public RsJsonEltType getType(E var1);

        public Binding getAsBinding(E var1);

        public List<Var> getAsHead(E var1);

        public Boolean getAsBoolean(E var1);
    }

    private static class TentativeValue<T> {
        T value;
        boolean isValueFinal = false;
        boolean isTentative = false;

        private TentativeValue() {
        }

        boolean updateValue(T arg) {
            boolean result;
            if (!this.isValueFinal) {
                this.value = arg;
                this.isTentative = true;
                result = true;
            } else {
                result = Objects.equals(this.value, arg);
            }
            return result;
        }

        void makeFinal() {
            if (this.isTentative) {
                this.isValueFinal = true;
            }
        }

        T getValue() {
            return this.value;
        }

        boolean hasValue() {
            return this.isTentative;
        }

        boolean isValueFinal() {
            return this.isValueFinal;
        }

        public String toString() {
            return "Holder [value=" + String.valueOf(this.value) + ", isValueSet=" + this.isValueFinal + "]";
        }
    }

    private static enum RsJsonEltType {
        UNKNOWN,
        HEAD,
        BOOLEAN,
        RESULTS,
        BINDING;

    }

    private static class RsJsonEltDft {
        protected RsJsonEltType type;
        protected List<Var> head;
        protected Boolean askResult;
        protected Binding binding;
        protected Object unknownJsonElement;

        public RsJsonEltDft(RsJsonEltType type) {
            this.type = type;
        }

        public RsJsonEltDft(List<Var> head) {
            this.type = RsJsonEltType.HEAD;
            this.head = head;
        }

        public RsJsonEltDft(Boolean askResult) {
            this.type = RsJsonEltType.BOOLEAN;
            this.askResult = askResult;
        }

        public RsJsonEltDft(Binding binding) {
            this.type = RsJsonEltType.BINDING;
            this.binding = binding;
        }

        public RsJsonEltDft(Object jsonElement) {
            this.type = RsJsonEltType.UNKNOWN;
            this.unknownJsonElement = jsonElement;
        }

        public RsJsonEltType getType() {
            return this.type;
        }

        public List<Var> getHead() {
            return this.head;
        }

        public Boolean getAskResult() {
            return this.askResult;
        }

        public Binding getBinding() {
            return this.binding;
        }

        public Object getUnknownJsonElement() {
            return this.unknownJsonElement;
        }

        public String toString() {
            return "RsJsonEltDft [type=" + String.valueOf((Object)this.type) + ", head=" + String.valueOf(this.head) + ", askResult=" + this.askResult + ", binding=" + String.valueOf(this.binding) + ", unknownJsonElement=" + String.valueOf(this.unknownJsonElement) + "]";
        }
    }
}

