/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.riot.lang;

import java.util.Iterator;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.NodeFactory;
import org.apache.jena.graph.Triple;
import org.apache.jena.riot.lang.LangBase;
import org.apache.jena.riot.system.ParserProfile;
import org.apache.jena.riot.system.StreamRDF;
import org.apache.jena.riot.tokens.StringType;
import org.apache.jena.riot.tokens.Token;
import org.apache.jena.riot.tokens.TokenType;
import org.apache.jena.riot.tokens.Tokenizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class LangNTuple<X>
extends LangBase
implements Iterator<X> {
    private static Logger log = LoggerFactory.getLogger(LangNTuple.class);
    protected boolean skipOnBadTerm = false;

    protected LangNTuple(Tokenizer tokens2, ParserProfile profile, StreamRDF dest) {
        super(tokens2, profile, dest);
    }

    @Override
    public final boolean hasNext() {
        return super.moreTokens();
    }

    @Override
    public final X next() {
        return this.parseOne();
    }

    protected abstract X parseOne();

    protected void skipOne(X object, String printForm, long line, long col) {
        this.errorHandler.warning("Skip: " + printForm, line, col);
    }

    protected abstract Node tokenAsNode(Token var1);

    protected final Triple parseTriple() {
        Token token = this.peekToken();
        Node s = this.parseSubject();
        Node p = this.parsePredicate();
        Node o = this.parseObject();
        return this.profile.createTriple(s, p, o, token.getLine(), token.getColumn());
    }

    protected final Node parseSubject() {
        Token sToken = this.nextToken();
        if (sToken.isEOF()) {
            this.exception(sToken, "Premature end of file: %s", sToken);
        }
        this.checkIRIOrBNode(sToken);
        Node s = this.tokenAsNode(sToken);
        return s;
    }

    protected final Node parsePredicate() {
        Token pToken = this.nextToken();
        if (pToken.isEOF()) {
            this.exception(pToken, "Premature end of file: %s", pToken);
        }
        this.checkIRI(pToken);
        Node p = this.tokenAsNode(pToken);
        return p;
    }

    protected final Node parseObject() {
        return this.parseRDFTerm("object");
    }

    protected final Node parseRDFTerm(String posn) {
        Node term;
        Token token = this.nextToken();
        if (token.isEOF()) {
            this.exception(token, "Premature end of file: %s", token);
        }
        if (token.hasType(TokenType.L_TRIPLE)) {
            term = this.parseTripleTerm();
        } else {
            this.checkRDFTerm(posn, token);
            term = this.tokenAsNode(token);
        }
        return term;
    }

    protected final Node parseTripleTerm() {
        Triple t = this.parseTriple();
        Token x = this.nextToken();
        if (x.getType() != TokenType.R_TRIPLE) {
            this.exception(x, "Triple term not terminated by )>>: %s", x);
        }
        return NodeFactory.createTripleTerm(t);
    }

    protected final void checkIRIOrBNode(Token token) {
        if (token.hasType(TokenType.IRI)) {
            return;
        }
        if (token.hasType(TokenType.BNODE)) {
            return;
        }
        this.exception(token, "Expected BNode or IRI: Got: %s", token);
    }

    protected final void checkIRI(Token token) {
        if (token.hasType(TokenType.IRI)) {
            return;
        }
        this.exception(token, "Expected IRI: Got: %s", token);
    }

    protected final void checkRDFTerm(String posn, Token token) {
        switch (token.getType()) {
            case IRI: 
            case BNODE: {
                return;
            }
            case STRING: {
                this.checkString(token);
                return;
            }
            case LITERAL_LANG: 
            case LITERAL_DT: {
                this.checkString(token.getSubToken1());
                return;
            }
        }
        this.exception(token, "Illegal %s: %s", posn, token);
    }

    private void checkString(Token token) {
        if (token.isLongString()) {
            this.exception(token, "Triple quoted string not permitted: %s", token);
        }
        if (this.isStrictMode() && !token.hasStringType(StringType.STRING2)) {
            this.exception(token, "Not a \"\"-quoted string: %s", token);
        }
    }

    public boolean getSkipOnBadTerm() {
        return this.skipOnBadTerm;
    }

    public void setSkipOnBadTerm(boolean skipOnBadTerm) {
        this.skipOnBadTerm = skipOnBadTerm;
    }
}

