/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.fuseki.metrics;

import io.micrometer.core.instrument.MeterRegistry;
import jakarta.servlet.ServletContext;
import java.util.Objects;
import org.apache.jena.atlas.logging.Log;
import org.apache.jena.fuseki.Fuseki;
import org.apache.jena.fuseki.metrics.FusekiRequestsMetrics;
import org.apache.jena.fuseki.server.DataAccessPoint;
import org.apache.jena.fuseki.server.DataAccessPointRegistry;
import org.apache.jena.fuseki.servlets.HttpAction;

public interface MetricsProvider {
    public MeterRegistry getMeterRegistry();

    public void scrape(HttpAction var1);

    default public void dataAccessPointMetrics(MetricsProvider metricsProvider, DataAccessPointRegistry dapRegistry) {
        try {
            dapRegistry.accessPoints().forEach(dap -> this.addDataAccessPointMetrics((DataAccessPoint)dap));
        }
        catch (Throwable th) {
            Fuseki.configLog.error("Failed to bind all data access points to netrics provider", th);
        }
    }

    default public void addDataAccessPointMetrics(DataAccessPoint dataAccessPoint) {
        MeterRegistry meterRegistry = this.getMeterRegistry();
        if (meterRegistry != null) {
            MetricsProvider.addDataAccessPointMetrics(meterRegistry, dataAccessPoint);
        }
    }

    private static void addDataAccessPointMetrics(MeterRegistry meterRegistry, DataAccessPoint dataAccessPoint) {
        if (dataAccessPoint == null) {
            Log.warn(MetricsProvider.class, "addDataAccessPointMetrics: Null DataAccessPoint");
        }
        new FusekiRequestsMetrics(dataAccessPoint).bindTo(meterRegistry);
    }

    public static void setMetricsProvider(ServletContext servletContext, MetricsProvider provider) {
        Objects.requireNonNull(servletContext);
        if (provider == null) {
            servletContext.removeAttribute("org.apache.jena.fuseki:MetricsProvider");
        } else {
            servletContext.setAttribute("org.apache.jena.fuseki:MetricsProvider", provider);
        }
    }

    public static MetricsProvider getMetricsProvider(ServletContext servletContext) {
        Objects.requireNonNull(servletContext);
        return (MetricsProvider)servletContext.getAttribute("org.apache.jena.fuseki:MetricsProvider");
    }
}

