/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.riot.process.normalize;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.util.Locale;
import org.apache.jena.datatypes.RDFDatatype;
import org.apache.jena.graph.NodeFactory;
import org.apache.jena.riot.process.normalize.DatatypeHandler;
import org.apache.jena.sparql.graph.NodeConst;
import org.apache.jena.sparql.util.DateTimeStruct;
import org.apache.jena.sparql.util.XSDNumUtils;

class NormalizeValue {
    private static DatatypeHandler identity = (node, lexicalForm, datatype) -> node;
    static DatatypeHandler dtBoolean = (node, lexicalForm, datatype) -> switch (lexicalForm) {
        case "1" -> NodeConst.nodeTrue;
        case "0" -> NodeConst.nodeFalse;
        default -> node;
    };
    static DatatypeHandler dtAnyDateTime;
    static DatatypeHandler dtDateTime;
    static DatatypeHandler dtInteger;
    static DatatypeHandler dtDecimalTTL;
    static DatatypeHandler dtDoubleTTL;
    static DatatypeHandler dtFloatTTL;
    private static DecimalFormatSymbols decimalNumberSymbols;
    private static NumberFormat fmtFloat;
    private static NumberFormat fmtDouble;
    static DatatypeHandler dtDoubleXSD;
    static DatatypeHandler dtFloatXSD;
    static DatatypeHandler dtDecimalXSD;
    static DatatypeHandler dtDecimalXSD10;

    NormalizeValue() {
    }

    static {
        dtDateTime = dtAnyDateTime = (node, lexicalForm, datatype) -> {
            int i;
            if (lexicalForm.indexOf(46) < 0) {
                return node;
            }
            DateTimeStruct dts = DateTimeStruct.parseDateTime(lexicalForm);
            int idx = dts.second.indexOf(46);
            for (i = dts.second.length() - 1; i > idx && dts.second.charAt(i) == '0'; --i) {
            }
            if (i == dts.second.length()) {
                return node;
            }
            dts.second = i == idx ? dts.second.substring(0, idx) : dts.second.substring(0, i + 1);
            String lex2 = dts.toString();
            return NodeFactory.createLiteralDT((String)lex2, (RDFDatatype)datatype);
        };
        dtInteger = (node, lexicalForm, datatype) -> {
            char[] chars = lexicalForm.toCharArray();
            if (chars.length == 0) {
                return node;
            }
            String lex2 = lexicalForm;
            if (lex2.startsWith("+")) {
                lex2 = lex2.substring(1);
            }
            if (lex2.length() > 8) {
                lex2 = new BigInteger(lexicalForm).toString();
            } else {
                int x = Integer.parseInt(lex2);
                lex2 = Integer.toString(x);
            }
            if (lex2.equals(lexicalForm)) {
                return node;
            }
            return NodeFactory.createLiteralDT((String)lex2, (RDFDatatype)datatype);
        };
        dtDecimalTTL = (node, lexicalForm, datatype) -> {
            BigDecimal bd = new BigDecimal(lexicalForm).stripTrailingZeros();
            Object lex2 = bd.toPlainString();
            if (((String)lex2).indexOf(46) == -1) {
                lex2 = (String)lex2 + ".0";
            }
            if (((String)lex2).equals(lexicalForm)) {
                return node;
            }
            return NodeFactory.createLiteralDT((String)lex2, (RDFDatatype)datatype);
        };
        dtDoubleTTL = (node, lexicalForm, datatype) -> {
            double d = XSDNumUtils.xsdParseDouble(lexicalForm);
            String lex2 = XSDNumUtils.stringForm(d);
            if (lex2.equals(lexicalForm)) {
                return node;
            }
            return NodeFactory.createLiteralDT((String)lex2, (RDFDatatype)datatype);
        };
        dtFloatTTL = (node, lexicalForm, datatype) -> {
            float f = XSDNumUtils.xsdParseFloat(lexicalForm);
            String lex2 = XSDNumUtils.stringForm(f);
            if (lex2.equals(lexicalForm)) {
                return node;
            }
            return NodeFactory.createLiteralDT((String)lex2, (RDFDatatype)datatype);
        };
        decimalNumberSymbols = new DecimalFormatSymbols(Locale.ROOT);
        fmtFloat = new DecimalFormat("0.0#####E0", decimalNumberSymbols);
        fmtDouble = new DecimalFormat("0.0#################E0", decimalNumberSymbols);
        dtDoubleXSD = (node, lexicalForm, datatype) -> {
            double d = XSDNumUtils.xsdParseDouble(lexicalForm);
            String lex2 = Double.isInfinite(d) ? (d < 0.0 ? "-INF" : "INF") : fmtDouble.format(d);
            if (lex2.equals(lexicalForm)) {
                return node;
            }
            return NodeFactory.createLiteralDT((String)lex2, (RDFDatatype)datatype);
        };
        dtFloatXSD = (node, lexicalForm, datatype) -> {
            float f = XSDNumUtils.xsdParseFloat(lexicalForm);
            String lex2 = Float.isInfinite(f) ? (f < 0.0f ? "-INF" : "INF") : fmtFloat.format(f);
            if (lex2.equals(lexicalForm)) {
                return node;
            }
            return NodeFactory.createLiteralDT((String)lex2, (RDFDatatype)datatype);
        };
        dtDecimalXSD = (node, lexicalForm, datatype) -> {
            BigDecimal decimal = XSDNumUtils.xsdParseDecimal(lexicalForm);
            String lex2 = XSDNumUtils.canonicalDecimalStrNoIntegerDot(decimal);
            if (lex2.equals(lexicalForm)) {
                return node;
            }
            return NodeFactory.createLiteralDT((String)lex2, (RDFDatatype)datatype);
        };
        dtDecimalXSD10 = (node, lexicalForm, datatype) -> {
            BigDecimal decimal = XSDNumUtils.xsdParseDecimal(lexicalForm);
            String lex2 = XSDNumUtils.canonicalDecimalStrWithDot(decimal);
            if (lex2.equals(lexicalForm)) {
                return node;
            }
            return NodeFactory.createLiteralDT((String)lex2, (RDFDatatype)datatype);
        };
    }
}

