/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.reasoner.rulesys;

import java.io.PrintWriter;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.apache.jena.graph.Triple;
import org.apache.jena.reasoner.Derivation;
import org.apache.jena.reasoner.InfGraph;
import org.apache.jena.reasoner.rulesys.ClauseEntry;
import org.apache.jena.reasoner.rulesys.Functor;
import org.apache.jena.reasoner.rulesys.Rule;
import org.apache.jena.util.PrintUtil;

public class RuleDerivation
implements Derivation {
    protected Rule rule;
    protected Triple conclusion;
    protected List<Triple> matches;
    protected InfGraph infGraph;

    public RuleDerivation(Rule rule, Triple conclusion, List<Triple> matches, InfGraph infGraph) {
        this.rule = rule;
        this.conclusion = conclusion;
        this.matches = matches;
        this.infGraph = infGraph;
    }

    @Override
    public String toString() {
        if (this.rule == null) {
            return "DUMMY";
        }
        return "Rule " + this.rule.toShortString();
    }

    @Override
    public void printTrace(PrintWriter out, boolean bindings) {
        this.printTrace(out, bindings, 0, new HashSet<RuleDerivation>());
    }

    protected void printTrace(PrintWriter out, boolean bindings, int indent, HashSet<RuleDerivation> seen) {
        PrintUtil.printIndent(out, indent);
        out.print(this.toString());
        if (bindings) {
            out.print(" concluded " + PrintUtil.print(this.conclusion));
        }
        out.println(" <-");
        int margin = indent + 4;
        for (int i = 0; i < this.matches.size(); ++i) {
            Triple match = this.matches.get(i);
            Iterator<Derivation> derivations = this.infGraph.getDerivation(match);
            if (derivations == null || !derivations.hasNext()) {
                PrintUtil.printIndent(out, margin);
                if (match == null) {
                    ClauseEntry term = this.rule.getBodyElement(i);
                    if (term instanceof Functor) {
                        out.println(((Functor)term).getName() + "()");
                        continue;
                    }
                    out.println("call to built in");
                    continue;
                }
                out.println("Fact " + PrintUtil.print(match));
                continue;
            }
            RuleDerivation derivation = (RuleDerivation)derivations.next();
            if (seen.contains(derivation)) {
                PrintUtil.printIndent(out, margin);
                out.println("Known " + PrintUtil.print(match) + " - already shown");
                continue;
            }
            seen.add(derivation);
            derivation.printTrace(out, bindings, margin, seen);
        }
    }

    public Triple getConclusion() {
        return this.conclusion;
    }

    public List<Triple> getMatches() {
        return this.matches;
    }

    public Rule getRule() {
        return this.rule;
    }

    public boolean sameAs(RuleDerivation other) {
        return this.conclusion.equals(other.getConclusion()) && this.matches.equals(other.getMatches()) && this.rule.equals(other.getRule());
    }
}

