/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.shex.expressions;

import org.apache.jena.shex.expressions.NodeConstraintVisitor;
import org.apache.jena.shex.expressions.ShapeExprAND;
import org.apache.jena.shex.expressions.ShapeExprExternal;
import org.apache.jena.shex.expressions.ShapeExprFalse;
import org.apache.jena.shex.expressions.ShapeExprNOT;
import org.apache.jena.shex.expressions.ShapeExprNone;
import org.apache.jena.shex.expressions.ShapeExprOR;
import org.apache.jena.shex.expressions.ShapeExprRef;
import org.apache.jena.shex.expressions.ShapeExprTripleExpr;
import org.apache.jena.shex.expressions.ShapeExprTrue;
import org.apache.jena.shex.expressions.ShapeExprVisitor;
import org.apache.jena.shex.expressions.ShapeExpression;
import org.apache.jena.shex.expressions.ShapeNodeConstraint;
import org.apache.jena.shex.expressions.TripleExprVisitor;
import org.apache.jena.shex.expressions.TripleExprWalker;

public class ShapeExprWalker
implements ShapeExprVisitor {
    private final ShapeExprVisitor beforeVisitor;
    private final ShapeExprVisitor afterVisitor;
    private final TripleExprVisitor tripleExprWalker;
    private NodeConstraintVisitor nodeConstraintVisitor;

    public ShapeExprWalker(ShapeExprVisitor beforeVisitor, ShapeExprVisitor afterVisitor, TripleExprVisitor beforeTripleExprVisitor, TripleExprVisitor afterTripleExprVisitor, NodeConstraintVisitor nodeConstraintVisitor) {
        this.beforeVisitor = beforeVisitor;
        this.afterVisitor = afterVisitor;
        this.tripleExprWalker = new TripleExprWalker(beforeTripleExprVisitor, afterTripleExprVisitor, this);
        this.nodeConstraintVisitor = nodeConstraintVisitor;
    }

    private void before(ShapeExpression shape) {
        if (this.beforeVisitor != null) {
            shape.visit(this.beforeVisitor);
        }
    }

    private void after(ShapeExpression shape) {
        if (this.afterVisitor != null) {
            shape.visit(this.afterVisitor);
        }
    }

    @Override
    public void visit(ShapeExprAND shape) {
        this.before(shape);
        shape.expressions().forEach(sh -> sh.visit(this));
        this.after(shape);
    }

    @Override
    public void visit(ShapeExprOR shape) {
        this.before(shape);
        shape.expressions().forEach(sh -> sh.visit(this));
        this.after(shape);
    }

    @Override
    public void visit(ShapeExprNOT shape) {
        this.before(shape);
        shape.subShape().visit(this);
        this.after(shape);
    }

    @Override
    public void visit(ShapeExprRef shape) {
        this.before(shape);
        this.after(shape);
    }

    @Override
    public void visit(ShapeExprFalse shape) {
        this.before(shape);
        this.after(shape);
    }

    @Override
    public void visit(ShapeExprNone shape) {
        this.before(shape);
        this.after(shape);
    }

    @Override
    public void visit(ShapeExprTrue shape) {
        this.before(shape);
        this.after(shape);
    }

    @Override
    public void visit(ShapeExprExternal shape) {
        this.before(shape);
        this.after(shape);
    }

    @Override
    public void visit(ShapeExprTripleExpr shape) {
        this.before(shape);
        if (this.tripleExprWalker != null && shape.getTripleExpr() != null) {
            shape.getTripleExpr().visit(this.tripleExprWalker);
        }
        this.after(shape);
    }

    @Override
    public void visit(ShapeNodeConstraint shape) {
        this.before(shape);
        if (this.nodeConstraintVisitor != null && shape.getNodeConstraint() != null) {
            shape.getNodeConstraint().components().forEach(ncc -> ncc.visit(this.nodeConstraintVisitor));
        }
        this.after(shape);
    }
}

