/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.riot;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.jena.riot.Lang;
import org.apache.jena.riot.RDFLanguages;
import org.apache.jena.riot.ReaderRIOTFactory;
import org.apache.jena.riot.lang.ReaderRDFNULL;
import org.apache.jena.riot.lang.ReaderTriX;
import org.apache.jena.riot.lang.RiotParsers;
import org.apache.jena.riot.lang.extra.TurtleJCC;
import org.apache.jena.riot.lang.rdfxml.RRX;
import org.apache.jena.riot.lang.rdfxml.rrx.ReaderRDFXML_SAX;

public class RDFParserRegistry {
    private static Map<Lang, ReaderRIOTFactory> langToParserFactory = new HashMap<Lang, ReaderRIOTFactory>();
    private static Set<Lang> langTriples = new HashSet<Lang>();
    private static Set<Lang> langQuads = new HashSet<Lang>();
    private static boolean initialized = false;

    public static void init() {
        if (initialized) {
            return;
        }
        initialized = true;
        RDFParserRegistry.initStandard();
    }

    private static void initStandard() {
        RDFLanguages.init();
        RDFParserRegistry.registerLangTriples(Lang.NTRIPLES, RiotParsers.factoryNT);
        RDFParserRegistry.registerLangTriples(Lang.N3, RiotParsers.factoryTTL);
        RDFParserRegistry.registerLangTriples(Lang.TURTLE, RiotParsers.factoryTTL);
        RDFParserRegistry.registerLangTriples(Lang.RDFJSON, RiotParsers.factoryRDFJSON);
        RDFParserRegistry.registerLangTriples(Lang.RDFXML, ReaderRDFXML_SAX.factory);
        RDFParserRegistry.registerLangTriples(Lang.RDFPROTO, RiotParsers.factoryRDFProtobuf);
        RDFParserRegistry.registerLangTriples(Lang.RDFTHRIFT, RiotParsers.factoryRDFThrift);
        RDFParserRegistry.registerLangTriples(Lang.TRIX, ReaderTriX.factory);
        RDFParserRegistry.registerLangTriples(Lang.RDFNULL, ReaderRDFNULL.factory);
        RDFParserRegistry.registerLangTriples(Lang.JSONLD, RiotParsers.factoryJSONLD);
        RDFParserRegistry.registerLangTriples(Lang.JSONLD11, RiotParsers.factoryJSONLD);
        RDFParserRegistry.registerLangQuads(Lang.NQUADS, RiotParsers.factoryNQ);
        RDFParserRegistry.registerLangQuads(Lang.TRIG, RiotParsers.factoryTRIG);
        RDFParserRegistry.registerLangQuads(Lang.RDFPROTO, RiotParsers.factoryRDFProtobuf);
        RDFParserRegistry.registerLangQuads(Lang.RDFTHRIFT, RiotParsers.factoryRDFThrift);
        RDFParserRegistry.registerLangQuads(Lang.TRIX, ReaderTriX.factory);
        RDFParserRegistry.registerLangQuads(Lang.RDFNULL, ReaderRDFNULL.factory);
        RDFParserRegistry.registerLangQuads(Lang.JSONLD, RiotParsers.factoryJSONLD);
        RDFParserRegistry.registerLangQuads(Lang.JSONLD11, RiotParsers.factoryJSONLD);
        TurtleJCC.register();
        RRX.register();
    }

    private static void registerLang(Lang lang, ReaderRIOTFactory factory) {
        RDFLanguages.register(lang);
        langToParserFactory.put(lang, factory);
    }

    public static void registerLangTriples(Lang lang, ReaderRIOTFactory factory) {
        langTriples.add(lang);
        RDFParserRegistry.registerLang(lang, factory);
    }

    public static void registerLangQuads(Lang lang, ReaderRIOTFactory factory) {
        langQuads.add(lang);
        RDFParserRegistry.registerLang(lang, factory);
    }

    public static void removeRegistration(Lang lang) {
        RDFLanguages.unregister(lang);
        langToParserFactory.remove(lang);
    }

    public static ReaderRIOTFactory getFactory(Lang language) {
        return langToParserFactory.get(language);
    }

    public static boolean isRegistered(Lang lang) {
        return langToParserFactory.containsKey(lang);
    }

    public static boolean isTriples(Lang lang) {
        return langTriples.contains(lang);
    }

    public static boolean isQuads(Lang lang) {
        return langQuads.contains(lang);
    }

    public static Collection<Lang> registeredLangTriples() {
        return Set.copyOf(langTriples);
    }

    public static Collection<Lang> registeredLangQuads() {
        return Set.copyOf(langQuads);
    }

    static {
        RDFParserRegistry.init();
    }
}

