/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.pipe.sink.util.builder;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.commons.io.FileUtils;
import org.apache.iotdb.db.pipe.sink.util.builder.PipeTsFileBuilder;
import org.apache.iotdb.pipe.api.exception.PipeException;
import org.apache.tsfile.enums.ColumnCategory;
import org.apache.tsfile.exception.write.WriteProcessException;
import org.apache.tsfile.file.metadata.IDeviceID;
import org.apache.tsfile.file.metadata.TableSchema;
import org.apache.tsfile.utils.BitMap;
import org.apache.tsfile.utils.Pair;
import org.apache.tsfile.utils.WriteUtils;
import org.apache.tsfile.write.TsFileWriter;
import org.apache.tsfile.write.record.Tablet;
import org.apache.tsfile.write.schema.IMeasurementSchema;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PipeTableModelTsFileBuilder
extends PipeTsFileBuilder {
    private static final Logger LOGGER = LoggerFactory.getLogger(PipeTableModelTsFileBuilder.class);
    private final Map<String, List<Tablet>> dataBase2TabletList = new HashMap<String, List<Tablet>>();

    public PipeTableModelTsFileBuilder(AtomicLong currentBatchId, AtomicLong tsFileIdGenerator) {
        super(currentBatchId, tsFileIdGenerator);
    }

    @Override
    public void bufferTableModelTablet(String dataBase, Tablet tablet) {
        this.dataBase2TabletList.computeIfAbsent(dataBase, db -> new ArrayList()).add(tablet);
    }

    @Override
    public void bufferTreeModelTablet(Tablet tablet, Boolean isAligned) {
        throw new UnsupportedOperationException("PipeTableModeTsFileBuilder does not support tree model tablet to build TSFile");
    }

    @Override
    public List<Pair<String, File>> convertTabletToTsFileWithDBInfo() throws IOException {
        if (this.dataBase2TabletList.isEmpty()) {
            return new ArrayList<Pair<String, File>>(0);
        }
        ArrayList<Pair<String, File>> pairList = new ArrayList<Pair<String, File>>();
        for (Map.Entry<String, List<Tablet>> entry : this.dataBase2TabletList.entrySet()) {
            pairList.addAll(this.writeTableModelTabletsToTsFiles(entry.getValue(), entry.getKey()));
        }
        return pairList;
    }

    @Override
    public boolean isEmpty() {
        return this.dataBase2TabletList.isEmpty();
    }

    @Override
    public synchronized void onSuccess() {
        super.onSuccess();
        this.dataBase2TabletList.clear();
    }

    @Override
    public synchronized void close() {
        super.close();
        this.dataBase2TabletList.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T extends Pair<Tablet, List<Pair<IDeviceID, Integer>>>> List<Pair<String, File>> writeTableModelTabletsToTsFiles(List<Tablet> tabletList, String dataBase) throws IOException {
        HashMap<String, List> tableName2Tablets = new HashMap<String, List>();
        for (Tablet tablet : tabletList) {
            tableName2Tablets.computeIfAbsent(tablet.getTableName(), k -> new ArrayList()).add(new Pair((Object)tablet, (Object)WriteUtils.splitTabletByDevice((Tablet)tablet)));
        }
        for (List tablets : tableName2Tablets.values()) {
            tablets.sort((o1, o2) -> {
                IDeviceID deviceID = (IDeviceID)((Pair)((List)o1.right).get((int)0)).left;
                int result = deviceID.compareTo((Object)((IDeviceID)((Pair)((List)o2.right).get((int)0)).left));
                if (result == 0) {
                    return Long.compare(((Tablet)o1.left).getTimestamp(0), ((Tablet)o2.left).getTimestamp(0));
                }
                return result;
            });
        }
        Set<LinkedList<T>> device2TabletsLinkedList = Collections.newSetFromMap(new IdentityHashMap());
        tableName2Tablets.entrySet().stream().sorted(Map.Entry.comparingByKey(Comparator.naturalOrder())).forEach(entry -> device2TabletsLinkedList.add(new LinkedList((Collection)entry.getValue())));
        tableName2Tablets.clear();
        ArrayList<Pair<String, File>> sealedFiles = new ArrayList<Pair<String, File>>();
        while (!device2TabletsLinkedList.isEmpty()) {
            if (Objects.isNull(this.fileWriter)) {
                this.fileWriter = new TsFileWriter(this.createFile());
            }
            try {
                this.tryBestToWriteTabletsIntoOneFile(device2TabletsLinkedList);
            }
            catch (Exception e) {
                LOGGER.warn("Batch id = {}: Failed to write tablets into tsfile, because {}", new Object[]{this.currentBatchId.get(), e.getMessage(), e});
                try {
                    this.fileWriter.close();
                }
                catch (Exception closeException) {
                    LOGGER.warn("Batch id = {}: Failed to close the tsfile {} after failed to write tablets into, because {}", new Object[]{this.currentBatchId.get(), this.fileWriter.getIOWriter().getFile().getPath(), closeException.getMessage(), closeException});
                }
                finally {
                    sealedFiles.add((Pair<String, File>)new Pair((Object)dataBase, (Object)this.fileWriter.getIOWriter().getFile()));
                }
                for (Pair pair : sealedFiles) {
                    boolean deleteSuccess = FileUtils.deleteQuietly((File)((File)pair.right));
                    LOGGER.warn("Batch id = {}: {} delete the tsfile {} after failed to write tablets into {}. {}", new Object[]{this.currentBatchId.get(), deleteSuccess ? "Successfully" : "Failed to", ((File)pair.right).getPath(), this.fileWriter.getIOWriter().getFile().getPath(), deleteSuccess ? "" : "Maybe the tsfile needs to be deleted manually."});
                }
                sealedFiles.clear();
                this.fileWriter = null;
                throw e;
            }
            this.fileWriter.close();
            File sealedFile = this.fileWriter.getIOWriter().getFile();
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Batch id = {}: Seal tsfile {} successfully.", (Object)this.currentBatchId.get(), (Object)sealedFile.getPath());
            }
            sealedFiles.add((Pair<String, File>)new Pair((Object)dataBase, (Object)sealedFile));
            this.fileWriter = null;
        }
        return sealedFiles;
    }

    private <T extends Pair<Tablet, List<Pair<IDeviceID, Integer>>>> T tryBestToAggregateTablets(LinkedList<T> tablets) {
        if (tablets.isEmpty()) {
            return null;
        }
        Pair firstPair = (Pair)tablets.peekFirst();
        Tablet firstTablet = (Tablet)firstPair.left;
        List aggregationDeviceTimestampIndexList = (List)firstPair.right;
        String aggregationTableName = firstTablet.getTableName();
        long[] aggregationTimestamps = firstTablet.getTimestamps();
        int aggregationRow = firstTablet.getRowSize();
        int aggregationMaxRow = firstTablet.getMaxRowNumber();
        ArrayList aggregatedSchemas = new ArrayList();
        ArrayList aggregatedColumnCategories = new ArrayList();
        ArrayList<Object> aggregatedValues = new ArrayList<Object>();
        ArrayList<BitMap> aggregatedBitMaps = new ArrayList<BitMap>();
        while (!tablets.isEmpty()) {
            Pair pair = (Pair)tablets.peekFirst();
            Tablet tablet = (Tablet)pair.left;
            List deviceTimestampIndexList = (List)pair.right;
            if (!Objects.equals(deviceTimestampIndexList, aggregationDeviceTimestampIndexList) || !Objects.equals(firstTablet.getTableName(), aggregationTableName) || !Arrays.equals(tablet.getTimestamps(), aggregationTimestamps) || tablet.getRowSize() != aggregationRow || tablet.getMaxRowNumber() != aggregationMaxRow) break;
            aggregatedSchemas.addAll(tablet.getSchemas());
            aggregatedColumnCategories.addAll(tablet.getColumnTypes());
            aggregatedValues.addAll(Arrays.asList(tablet.getValues()));
            aggregatedBitMaps.addAll(Arrays.asList(tablet.getBitMaps()));
            tablets.pollFirst();
        }
        HashSet seen = new HashSet();
        List distinctIndices = IntStream.range(0, aggregatedSchemas.size()).filter(i -> Objects.nonNull(aggregatedSchemas.get(i))).filter(i -> seen.add((IMeasurementSchema)aggregatedSchemas.get(i))).boxed().collect(Collectors.toList());
        return (T)new Pair((Object)new Tablet(aggregationTableName, distinctIndices.stream().map(aggregatedSchemas::get).collect(Collectors.toList()), distinctIndices.stream().map(aggregatedColumnCategories::get).collect(Collectors.toList()), aggregationTimestamps, distinctIndices.stream().map(aggregatedValues::get).toArray(), (BitMap[])distinctIndices.stream().map(aggregatedBitMaps::get).toArray(BitMap[]::new), aggregationRow), (Object)aggregationDeviceTimestampIndexList);
    }

    private <T extends Pair<Tablet, List<Pair<IDeviceID, Integer>>>> void tryBestToWriteTabletsIntoOneFile(Set<LinkedList<T>> device2TabletsLinkedList) throws IOException {
        Iterator<LinkedList<T>> iterator = device2TabletsLinkedList.iterator();
        while (iterator.hasNext()) {
            LinkedList<T> tablets = iterator.next();
            ArrayList<T> tabletsToWrite = new ArrayList<T>();
            HashMap<IDeviceID, Long> deviceLastTimestampMap = new HashMap<IDeviceID, Long>();
            String tableName = null;
            ArrayList<IMeasurementSchema> columnSchemas = new ArrayList<IMeasurementSchema>();
            ArrayList<ColumnCategory> columnCategories = new ArrayList<ColumnCategory>();
            HashSet<String> columnNames = new HashSet<String>();
            while (!tablets.isEmpty()) {
                T pair = this.tryBestToAggregateTablets(tablets);
                if (this.timestampsAreNonOverlapping(pair, (Map<IDeviceID, Long>)deviceLastTimestampMap)) {
                    Tablet tablet = (Tablet)((Pair)pair).left;
                    if (tableName == null) {
                        tableName = tablet.getTableName();
                    }
                    int size = tablet.getSchemas().size();
                    for (int i = 0; i < size; ++i) {
                        IMeasurementSchema schema = (IMeasurementSchema)tablet.getSchemas().get(i);
                        if (schema == null || columnNames.contains(schema.getMeasurementName())) continue;
                        columnNames.add(schema.getMeasurementName());
                        columnSchemas.add(schema);
                        columnCategories.add((ColumnCategory)tablet.getColumnTypes().get(i));
                    }
                    tabletsToWrite.add(pair);
                    continue;
                }
                tablets.addFirst(pair);
                break;
            }
            if (tablets.isEmpty()) {
                iterator.remove();
            }
            if (tableName != null) {
                this.fileWriter.registerTableSchema(new TableSchema(tableName, columnSchemas, columnCategories));
            }
            for (Pair pair : tabletsToWrite) {
                Tablet tablet = (Tablet)pair.left;
                try {
                    this.fileWriter.writeTable(tablet, (List)pair.right);
                }
                catch (WriteProcessException e) {
                    LOGGER.warn("Batch id = {}: Failed to build the table model TSFile. Please check whether the written Tablet has time overlap and whether the Table Schema is correct.", (Object)this.currentBatchId.get(), (Object)e);
                    throw new PipeException("The written Tablet time may overlap or the Schema may be incorrect");
                }
            }
        }
    }

    private <T extends Pair<Tablet, List<Pair<IDeviceID, Integer>>>> boolean timestampsAreNonOverlapping(T tabletPair, Map<IDeviceID, Long> deviceLastTimestampMap) {
        int currentTimestampIndex = 0;
        for (Pair deviceTimestampIndexPair : (List)tabletPair.right) {
            Long lastDeviceTimestamp = deviceLastTimestampMap.get(deviceTimestampIndexPair.left);
            if (lastDeviceTimestamp != null && lastDeviceTimestamp >= ((Tablet)tabletPair.left).getTimestamp(currentTimestampIndex)) {
                return false;
            }
            currentTimestampIndex = (Integer)deviceTimestampIndexPair.right;
            deviceLastTimestampMap.put((IDeviceID)deviceTimestampIndexPair.left, ((Tablet)tabletPair.left).getTimestamp(currentTimestampIndex - 1));
        }
        return true;
    }
}

