/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.relational.planner;

import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.AstVisitor;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.BinaryLiteral;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.BooleanLiteral;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.DoubleLiteral;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.GenericLiteral;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Literal;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.LongLiteral;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.NullLiteral;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.StringLiteral;

public class CastToBooleanLiteralVisitor
extends AstVisitor<Boolean, Void> {
    @Override
    protected Boolean visitLiteral(Literal node, Void context) {
        throw new UnsupportedOperationException("Unhandled literal type: " + node);
    }

    @Override
    protected Boolean visitBooleanLiteral(BooleanLiteral node, Void context) {
        return node.getValue();
    }

    @Override
    protected Boolean visitLongLiteral(LongLiteral node, Void context) {
        return node.getParsedValue() != 0L;
    }

    @Override
    protected Boolean visitDoubleLiteral(DoubleLiteral node, Void context) {
        return node.getValue() != 0.0;
    }

    @Override
    protected Boolean visitStringLiteral(StringLiteral node, Void context) {
        try {
            return Boolean.parseBoolean(node.getValue());
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    protected Boolean visitBinaryLiteral(BinaryLiteral node, Void context) {
        return null;
    }

    @Override
    protected Boolean visitGenericLiteral(GenericLiteral node, Void context) {
        try {
            return Boolean.parseBoolean(node.getValue());
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    protected Boolean visitNullLiteral(NullLiteral node, Void context) {
        return null;
    }
}

