/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.analyze.schema;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.iotdb.commons.exception.IllegalPathException;
import org.apache.iotdb.commons.path.MeasurementPath;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.commons.path.PathPatternTree;
import org.apache.iotdb.db.conf.IoTDBConfig;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.exception.metadata.AlignedTimeseriesException;
import org.apache.iotdb.db.exception.sql.SemanticException;
import org.apache.iotdb.db.queryengine.common.MPPQueryContext;
import org.apache.iotdb.db.queryengine.common.schematree.ClusterSchemaTree;
import org.apache.iotdb.db.queryengine.plan.analyze.schema.AutoCreateSchemaExecutor;
import org.apache.iotdb.db.queryengine.plan.analyze.schema.ClusterSchemaFetchExecutor;
import org.apache.iotdb.db.queryengine.plan.analyze.schema.ISchemaAutoCreation;
import org.apache.iotdb.db.queryengine.plan.analyze.schema.ISchemaComputation;
import org.apache.iotdb.db.queryengine.plan.analyze.schema.ISchemaComputationWithAutoCreation;
import org.apache.iotdb.db.queryengine.plan.relational.metadata.fetcher.cache.TreeDeviceSchemaCacheManager;
import org.apache.tsfile.enums.TSDataType;
import org.apache.tsfile.utils.Pair;

class NormalSchemaFetcher {
    private final IoTDBConfig config = IoTDBDescriptor.getInstance().getConfig();
    private final TreeDeviceSchemaCacheManager schemaCache;
    private final AutoCreateSchemaExecutor autoCreateSchemaExecutor;
    private final ClusterSchemaFetchExecutor clusterSchemaFetchExecutor;

    NormalSchemaFetcher(TreeDeviceSchemaCacheManager schemaCache, AutoCreateSchemaExecutor autoCreateSchemaExecutor, ClusterSchemaFetchExecutor clusterSchemaFetchExecutor) {
        this.schemaCache = schemaCache;
        this.autoCreateSchemaExecutor = autoCreateSchemaExecutor;
        this.clusterSchemaFetchExecutor = clusterSchemaFetchExecutor;
    }

    private void computePatternTreeNeededReFetch(PathPatternTree patternTree, List<String> fullPaths) {
        for (String fullPath : fullPaths) {
            try {
                patternTree.appendFullPath((PartialPath)new MeasurementPath(fullPath));
            }
            catch (IllegalPathException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private PathPatternTree computePatternTreeNeededReFetch(PartialPath devicePath, String[] measurementList, List<Integer> indexOfMissingMeasurements, List<String> fullPaths) {
        PathPatternTree patternTree = new PathPatternTree();
        Iterator<Object> iterator = indexOfMissingMeasurements.iterator();
        while (iterator.hasNext()) {
            int index = iterator.next();
            patternTree.appendFullPath(devicePath, measurementList[index]);
        }
        for (String fullPath : fullPaths) {
            try {
                patternTree.appendFullPath((PartialPath)new MeasurementPath(fullPath));
            }
            catch (IllegalPathException e) {
                throw new RuntimeException(e);
            }
        }
        return patternTree;
    }

    private PathPatternTree computePatternTreeNeededReFetch(List<PartialPath> devicePathList, List<String[]> measurementsList, List<Integer> indexOfTargetDevices, List<List<Integer>> indexOfTargetMeasurementsList) {
        PathPatternTree patternTree = new PathPatternTree();
        int size = indexOfTargetDevices.size();
        for (int i = 0; i < size; ++i) {
            int deviceIndex = indexOfTargetDevices.get(i);
            for (int measurementIndex : indexOfTargetMeasurementsList.get(i)) {
                patternTree.appendFullPath(devicePathList.get(deviceIndex), measurementsList.get(deviceIndex)[measurementIndex]);
            }
        }
        return patternTree;
    }

    List<Integer> processNormalTimeSeries(ISchemaComputationWithAutoCreation schemaComputationWithAutoCreation, MPPQueryContext context) {
        ClusterSchemaTree remoteSchemaTree;
        boolean isAlignedPutIn = schemaComputationWithAutoCreation.isAligned();
        List<Integer> indexOfMissingMeasurements = this.schemaCache.computeWithoutTemplate(schemaComputationWithAutoCreation);
        Pair<List<Integer>, List<String>> missedIndexAndPathString = this.schemaCache.computeSourceOfLogicalView(schemaComputationWithAutoCreation);
        List indexOfMissingLogicalView = (List)missedIndexAndPathString.left;
        List missedPathStringOfLogicalView = (List)missedIndexAndPathString.right;
        if (indexOfMissingMeasurements.isEmpty() && indexOfMissingLogicalView.isEmpty()) {
            return indexOfMissingMeasurements;
        }
        if (missedPathStringOfLogicalView.isEmpty()) {
            remoteSchemaTree = this.clusterSchemaFetchExecutor.fetchSchemaOfOneDevice(schemaComputationWithAutoCreation.getDevicePath(), schemaComputationWithAutoCreation.getMeasurements(), indexOfMissingMeasurements, context);
        } else {
            PathPatternTree patternTree = this.computePatternTreeNeededReFetch(schemaComputationWithAutoCreation.getDevicePath(), schemaComputationWithAutoCreation.getMeasurements(), indexOfMissingMeasurements, missedPathStringOfLogicalView);
            remoteSchemaTree = this.clusterSchemaFetchExecutor.fetchSchemaWithPatternTreeAndCache(patternTree, context);
        }
        remoteSchemaTree.computeSourceOfLogicalView(schemaComputationWithAutoCreation, indexOfMissingLogicalView);
        indexOfMissingMeasurements = remoteSchemaTree.compute(schemaComputationWithAutoCreation, indexOfMissingMeasurements);
        schemaComputationWithAutoCreation.recordRangeOfLogicalViewSchemaListNow();
        missedIndexAndPathString = this.schemaCache.computeSourceOfLogicalView(schemaComputationWithAutoCreation);
        indexOfMissingLogicalView = (List)missedIndexAndPathString.left;
        missedPathStringOfLogicalView = (List)missedIndexAndPathString.right;
        if (!missedPathStringOfLogicalView.isEmpty()) {
            ClusterSchemaTree viewSchemaTree = this.clusterSchemaFetchExecutor.fetchSchemaWithFullPaths(missedPathStringOfLogicalView, context);
            viewSchemaTree.computeSourceOfLogicalView(schemaComputationWithAutoCreation, indexOfMissingLogicalView);
        }
        if (indexOfMissingMeasurements.isEmpty()) {
            return indexOfMissingMeasurements;
        }
        if (this.config.isAutoCreateSchemaEnabled() || schemaComputationWithAutoCreation.getDevicePath().startsWith("root.__system")) {
            PartialPath devicePath = schemaComputationWithAutoCreation.getDevicePath();
            this.validateIsAlignedValueIfAutoCreate(schemaComputationWithAutoCreation.isAligned(), isAlignedPutIn, devicePath);
            ClusterSchemaTree schemaTree = new ClusterSchemaTree();
            this.autoCreateSchemaExecutor.autoCreateTimeSeries(schemaTree, devicePath, indexOfMissingMeasurements, schemaComputationWithAutoCreation.getMeasurements(), schemaComputationWithAutoCreation::getDataType, isAlignedPutIn, context);
            indexOfMissingMeasurements = schemaTree.compute(schemaComputationWithAutoCreation, indexOfMissingMeasurements);
        }
        return indexOfMissingMeasurements;
    }

    /*
     * WARNING - void declaration
     */
    void processNormalTimeSeries(List<? extends ISchemaComputationWithAutoCreation> schemaComputationWithAutoCreationList, MPPQueryContext context) {
        void var14_29;
        void var10_14;
        ISchemaComputationWithAutoCreation schemaComputationWithAutoCreation;
        List<Integer> indexOfMissingMeasurements;
        List<Boolean> isAlignedPutInList = schemaComputationWithAutoCreationList.stream().map(ISchemaAutoCreation::isAligned).collect(Collectors.toList());
        ArrayList<Integer> indexOfDevicesWithMissingMeasurements = new ArrayList<Integer>();
        ArrayList<List<Integer>> indexOfMissingMeasurementsList = new ArrayList<List<Integer>>(schemaComputationWithAutoCreationList.size());
        int size = schemaComputationWithAutoCreationList.size();
        for (int i3 = 0; i3 < size; ++i3) {
            indexOfMissingMeasurements = this.schemaCache.computeWithoutTemplate(schemaComputationWithAutoCreationList.get(i3));
            if (indexOfMissingMeasurements.isEmpty()) continue;
            indexOfDevicesWithMissingMeasurements.add(i3);
            indexOfMissingMeasurementsList.add(indexOfMissingMeasurements);
        }
        boolean hasUnFetchedLogicalView = false;
        ArrayList<Pair<List<Integer>, List<String>>> missedIndexAndPathStringOfViewList = new ArrayList<Pair<List<Integer>, List<String>>>(schemaComputationWithAutoCreationList.size());
        for (ISchemaComputationWithAutoCreation iSchemaComputationWithAutoCreation : schemaComputationWithAutoCreationList) {
            Pair<List<Integer>, List<String>> missedIndexAndPathString = this.schemaCache.computeSourceOfLogicalView(iSchemaComputationWithAutoCreation);
            if (!((List)missedIndexAndPathString.left).isEmpty()) {
                hasUnFetchedLogicalView = true;
            }
            missedIndexAndPathStringOfViewList.add(missedIndexAndPathString);
        }
        if (indexOfDevicesWithMissingMeasurements.isEmpty() && !hasUnFetchedLogicalView) {
            return;
        }
        if (!hasUnFetchedLogicalView) {
            ClusterSchemaTree clusterSchemaTree = this.clusterSchemaFetchExecutor.fetchSchemaOfMultiDevices(schemaComputationWithAutoCreationList.stream().map(ISchemaComputation::getDevicePath).collect(Collectors.toList()), schemaComputationWithAutoCreationList.stream().map(ISchemaComputation::getMeasurements).collect(Collectors.toList()), indexOfDevicesWithMissingMeasurements, indexOfMissingMeasurementsList, context);
        } else {
            PathPatternTree patternTree = this.computePatternTreeNeededReFetch(schemaComputationWithAutoCreationList.stream().map(ISchemaComputation::getDevicePath).collect(Collectors.toList()), schemaComputationWithAutoCreationList.stream().map(ISchemaComputation::getMeasurements).collect(Collectors.toList()), indexOfDevicesWithMissingMeasurements, indexOfMissingMeasurementsList);
            ArrayList<String> fullPathsNeedReFetch = new ArrayList<String>();
            for (Pair pair : missedIndexAndPathStringOfViewList) {
                fullPathsNeedReFetch.addAll((Collection)pair.right);
            }
            this.computePatternTreeNeededReFetch(patternTree, fullPathsNeedReFetch);
            ClusterSchemaTree clusterSchemaTree = this.clusterSchemaFetchExecutor.fetchSchemaWithPatternTreeAndCache(patternTree, context);
        }
        for (int i4 = 0; i4 < schemaComputationWithAutoCreationList.size(); ++i4) {
            schemaComputationWithAutoCreation = schemaComputationWithAutoCreationList.get(i4);
            var10_14.computeSourceOfLogicalView(schemaComputationWithAutoCreation, (List)((Pair)missedIndexAndPathStringOfViewList.get((int)i4)).left);
        }
        ArrayList<Integer> indexOfDevicesNeedAutoCreateSchema = new ArrayList<Integer>();
        ArrayList<List<Integer>> indexOfMeasurementsNeedAutoCreate = new ArrayList<List<Integer>>();
        for (int i2 = 0; i2 < indexOfDevicesWithMissingMeasurements.size(); ++i2) {
            schemaComputationWithAutoCreation = schemaComputationWithAutoCreationList.get((Integer)indexOfDevicesWithMissingMeasurements.get(i2));
            indexOfMissingMeasurements = var10_14.compute(schemaComputationWithAutoCreation, (List)indexOfMissingMeasurementsList.get(i2));
            schemaComputationWithAutoCreation.recordRangeOfLogicalViewSchemaListNow();
            if (indexOfMissingMeasurements.isEmpty()) continue;
            indexOfDevicesNeedAutoCreateSchema.add((Integer)indexOfDevicesWithMissingMeasurements.get(i2));
            indexOfMeasurementsNeedAutoCreate.add(indexOfMissingMeasurements);
        }
        hasUnFetchedLogicalView = false;
        int n = schemaComputationWithAutoCreationList.size();
        for (int i2 = 0; i2 < n; ++i2) {
            Pair<List<Integer>, List<String>> pair = this.schemaCache.computeSourceOfLogicalView(schemaComputationWithAutoCreationList.get(i2));
            if (!((List)pair.left).isEmpty()) {
                hasUnFetchedLogicalView = true;
            }
            ((Pair)missedIndexAndPathStringOfViewList.get((int)i2)).left = pair.left;
            ((Pair)missedIndexAndPathStringOfViewList.get((int)i2)).right = pair.right;
        }
        if (hasUnFetchedLogicalView) {
            void var15_34;
            ArrayList<String> fullPathsNeedRefetch = new ArrayList<String>();
            for (Pair pair : missedIndexAndPathStringOfViewList) {
                fullPathsNeedRefetch.addAll((Collection)pair.right);
            }
            ClusterSchemaTree clusterSchemaTree = this.clusterSchemaFetchExecutor.fetchSchemaWithFullPaths(fullPathsNeedRefetch, context);
            boolean bl = false;
            int size3 = schemaComputationWithAutoCreationList.size();
            while (var15_34 < size3) {
                schemaComputationWithAutoCreation = schemaComputationWithAutoCreationList.get((int)var15_34);
                clusterSchemaTree.computeSourceOfLogicalView(schemaComputationWithAutoCreation, (List)((Pair)missedIndexAndPathStringOfViewList.get((int)var15_34)).left);
                ++var15_34;
            }
        }
        if (indexOfDevicesNeedAutoCreateSchema.isEmpty()) {
            return;
        }
        ArrayList copyOfIndexOfDevicesNeedAutoCreateSchema = new ArrayList(indexOfDevicesNeedAutoCreateSchema);
        if (!this.config.isAutoCreateSchemaEnabled()) {
            indexOfDevicesNeedAutoCreateSchema.removeIf(i -> !((ISchemaComputationWithAutoCreation)schemaComputationWithAutoCreationList.get((int)i)).getDevicePath().startsWith("root.__system"));
        }
        if (!indexOfMeasurementsNeedAutoCreate.isEmpty()) {
            List<PartialPath> list = schemaComputationWithAutoCreationList.stream().map(ISchemaComputation::getDevicePath).collect(Collectors.toList());
            List<Boolean> list2 = schemaComputationWithAutoCreationList.stream().map(ISchemaAutoCreation::isAligned).collect(Collectors.toList());
            this.validateIsAlignedValueIfAutoCreate(list2, isAlignedPutInList, list);
            ClusterSchemaTree schemaTree = new ClusterSchemaTree();
            this.autoCreateSchemaExecutor.autoCreateTimeSeries(schemaTree, list, indexOfDevicesNeedAutoCreateSchema, indexOfMeasurementsNeedAutoCreate, schemaComputationWithAutoCreationList.stream().map(ISchemaComputation::getMeasurements).collect(Collectors.toList()), schemaComputationWithAutoCreationList.stream().map(o -> {
                TSDataType[] dataTypes = new TSDataType[o.getMeasurements().length];
                int length = dataTypes.length;
                for (int i = 0; i < length; ++i) {
                    dataTypes[i] = o.getDataType(i);
                }
                return dataTypes;
            }).collect(Collectors.toList()), isAlignedPutInList, context);
            indexOfDevicesWithMissingMeasurements = new ArrayList();
            indexOfMissingMeasurementsList = new ArrayList();
            for (int i6 = 0; i6 < copyOfIndexOfDevicesNeedAutoCreateSchema.size(); ++i6) {
                schemaComputationWithAutoCreation = schemaComputationWithAutoCreationList.get((Integer)copyOfIndexOfDevicesNeedAutoCreateSchema.get(i6));
                indexOfMissingMeasurements = schemaTree.compute(schemaComputationWithAutoCreation, (List)indexOfMeasurementsNeedAutoCreate.get(i6));
                if (indexOfMissingMeasurements.isEmpty()) continue;
                indexOfDevicesWithMissingMeasurements.add((Integer)copyOfIndexOfDevicesNeedAutoCreateSchema.get(i6));
                indexOfMissingMeasurementsList.add(indexOfMissingMeasurements);
            }
            if (indexOfDevicesWithMissingMeasurements.isEmpty()) {
                return;
            }
        } else {
            indexOfDevicesWithMissingMeasurements = indexOfDevicesNeedAutoCreateSchema;
            indexOfMissingMeasurementsList = indexOfMeasurementsNeedAutoCreate;
        }
        boolean bl = false;
        while (var14_29 < indexOfDevicesWithMissingMeasurements.size()) {
            schemaComputationWithAutoCreation = schemaComputationWithAutoCreationList.get((Integer)indexOfDevicesWithMissingMeasurements.get((int)var14_29));
            Iterator iterator = ((List)indexOfMissingMeasurementsList.get((int)var14_29)).iterator();
            while (iterator.hasNext()) {
                int index = (Integer)iterator.next();
                schemaComputationWithAutoCreation.computeMeasurement(index, null);
            }
            ++var14_29;
        }
    }

    private void validateIsAlignedValueIfAutoCreate(List<Boolean> realValueList, List<Boolean> putInValueList, List<PartialPath> devicePathList) {
        int checkLen = Math.min(Math.min(realValueList.size(), putInValueList.size()), devicePathList.size());
        for (int i = 0; i < checkLen; ++i) {
            this.validateIsAlignedValueIfAutoCreate(realValueList.get(i), putInValueList.get(i), devicePathList.get(i));
        }
    }

    private void validateIsAlignedValueIfAutoCreate(boolean realValue, boolean putInValue, PartialPath devicePath) {
        if (realValue != putInValue) {
            String msg = realValue ? "Timeseries under this device is aligned, please use createTimeseries or change device." : "Timeseries under this device is not aligned, please use createTimeseries or change device.";
            throw new SemanticException((Throwable)((Object)new AlignedTimeseriesException(msg, devicePath.getFullPath())));
        }
    }
}

