/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.core.types.structured;

import org.eclipse.milo.opcua.stack.core.serialization.SerializationContext;
import org.eclipse.milo.opcua.stack.core.serialization.UaDecoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaEncoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaStructure;
import org.eclipse.milo.opcua.stack.core.serialization.codecs.GenericDataTypeCodec;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExpandedNodeId;
import org.eclipse.milo.opcua.stack.core.types.structured.Structure;

public class DoubleComplexNumberType
extends Structure
implements UaStructure {
    public static final ExpandedNodeId TYPE_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=12172");
    public static final ExpandedNodeId XML_ENCODING_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=12174");
    public static final ExpandedNodeId BINARY_ENCODING_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=12182");
    private final Double real;
    private final Double imaginary;

    public DoubleComplexNumberType(Double real, Double imaginary) {
        this.real = real;
        this.imaginary = imaginary;
    }

    @Override
    public ExpandedNodeId getTypeId() {
        return TYPE_ID;
    }

    @Override
    public ExpandedNodeId getXmlEncodingId() {
        return XML_ENCODING_ID;
    }

    @Override
    public ExpandedNodeId getBinaryEncodingId() {
        return BINARY_ENCODING_ID;
    }

    public Double getReal() {
        return this.real;
    }

    public Double getImaginary() {
        return this.imaginary;
    }

    protected DoubleComplexNumberType(DoubleComplexNumberTypeBuilder<?, ?> b) {
        super(b);
        this.real = ((DoubleComplexNumberTypeBuilder)b).real;
        this.imaginary = ((DoubleComplexNumberTypeBuilder)b).imaginary;
    }

    public static DoubleComplexNumberTypeBuilder<?, ?> builder() {
        return new DoubleComplexNumberTypeBuilderImpl();
    }

    public DoubleComplexNumberTypeBuilder<?, ?> toBuilder() {
        return new DoubleComplexNumberTypeBuilderImpl().$fillValuesFrom(this);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DoubleComplexNumberType)) {
            return false;
        }
        DoubleComplexNumberType other = (DoubleComplexNumberType)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Double this$real = this.getReal();
        Double other$real = other.getReal();
        if (this$real == null ? other$real != null : !((Object)this$real).equals(other$real)) {
            return false;
        }
        Double this$imaginary = this.getImaginary();
        Double other$imaginary = other.getImaginary();
        return !(this$imaginary == null ? other$imaginary != null : !((Object)this$imaginary).equals(other$imaginary));
    }

    protected boolean canEqual(Object other) {
        return other instanceof DoubleComplexNumberType;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Double $real = this.getReal();
        result = result * 59 + ($real == null ? 43 : ((Object)$real).hashCode());
        Double $imaginary = this.getImaginary();
        result = result * 59 + ($imaginary == null ? 43 : ((Object)$imaginary).hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "DoubleComplexNumberType(real=" + this.getReal() + ", imaginary=" + this.getImaginary() + ")";
    }

    private static final class DoubleComplexNumberTypeBuilderImpl
    extends DoubleComplexNumberTypeBuilder<DoubleComplexNumberType, DoubleComplexNumberTypeBuilderImpl> {
        private DoubleComplexNumberTypeBuilderImpl() {
        }

        @Override
        protected DoubleComplexNumberTypeBuilderImpl self() {
            return this;
        }

        @Override
        public DoubleComplexNumberType build() {
            return new DoubleComplexNumberType(this);
        }
    }

    public static abstract class DoubleComplexNumberTypeBuilder<C extends DoubleComplexNumberType, B extends DoubleComplexNumberTypeBuilder<C, B>>
    extends Structure.StructureBuilder<C, B> {
        private Double real;
        private Double imaginary;

        @Override
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            DoubleComplexNumberTypeBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        private static void $fillValuesFromInstanceIntoBuilder(DoubleComplexNumberType instance, DoubleComplexNumberTypeBuilder<?, ?> b) {
            b.real(instance.real);
            b.imaginary(instance.imaginary);
        }

        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        public B real(Double real) {
            this.real = real;
            return (B)this.self();
        }

        public B imaginary(Double imaginary) {
            this.imaginary = imaginary;
            return (B)this.self();
        }

        @Override
        public String toString() {
            return "DoubleComplexNumberType.DoubleComplexNumberTypeBuilder(super=" + super.toString() + ", real=" + this.real + ", imaginary=" + this.imaginary + ")";
        }
    }

    public static final class Codec
    extends GenericDataTypeCodec<DoubleComplexNumberType> {
        @Override
        public Class<DoubleComplexNumberType> getType() {
            return DoubleComplexNumberType.class;
        }

        @Override
        public DoubleComplexNumberType decode(SerializationContext context, UaDecoder decoder) {
            Double real = decoder.readDouble("Real");
            Double imaginary = decoder.readDouble("Imaginary");
            return new DoubleComplexNumberType(real, imaginary);
        }

        @Override
        public void encode(SerializationContext context, UaEncoder encoder, DoubleComplexNumberType value) {
            encoder.writeDouble("Real", value.getReal());
            encoder.writeDouble("Imaginary", value.getImaginary());
        }
    }
}

