/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tsfile.read.common.type;

import org.apache.tsfile.enums.TSDataType;
import org.apache.tsfile.read.common.type.BinaryType;
import org.apache.tsfile.read.common.type.BooleanType;
import org.apache.tsfile.read.common.type.DoubleType;
import org.apache.tsfile.read.common.type.FloatType;
import org.apache.tsfile.read.common.type.IntType;
import org.apache.tsfile.read.common.type.LongType;
import org.apache.tsfile.read.common.type.Type;

public class TypeFactory {
    private TypeFactory() {
    }

    public static Type getType(TSDataType tsDataType) {
        switch (tsDataType) {
            case INT32: 
            case DATE: {
                return IntType.getInstance();
            }
            case INT64: 
            case TIMESTAMP: {
                return LongType.getInstance();
            }
            case FLOAT: {
                return FloatType.getInstance();
            }
            case DOUBLE: {
                return DoubleType.getInstance();
            }
            case BOOLEAN: {
                return BooleanType.getInstance();
            }
            case TEXT: 
            case BLOB: 
            case STRING: {
                return BinaryType.getInstance();
            }
        }
        throw new UnsupportedOperationException(String.format("Invalid TSDataType for TypeFactory: %s", tsDataType));
    }
}

