/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.tools.validate;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.iotdb.db.tools.utils.TsFileValidationScan;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TsFileValidationTool {
    private static boolean printDetails = false;
    private static boolean printToFile = false;
    private static boolean ignoreFileOverlap = false;
    private static String outFilePath = "TsFile_validation_view.txt";
    private static PrintWriter pw = null;
    private static final Logger logger = LoggerFactory.getLogger(TsFileValidationTool.class);
    private static final List<File> seqDataDirList = new ArrayList<File>();
    private static final List<File> fileList = new ArrayList<File>();
    private static TsFileValidationScan validationScan = new TsFileValidationScan();

    public static void main(String[] args) throws IOException {
        if (!TsFileValidationTool.checkArgs(args)) {
            System.exit(1);
        }
        if (printToFile) {
            pw = new PrintWriter(new FileWriter(outFilePath));
            validationScan.setPrintWriter(pw);
        }
        if (printDetails) {
            TsFileValidationTool.printBoth("Start checking seq files ...");
            validationScan.setPrintDetails(printDetails);
        }
        validationScan.setIgnoreFileOverlap(ignoreFileOverlap);
        for (File f : fileList) {
            TsFileValidationTool.findIncorrectFiles(Collections.singletonList(f));
        }
        for (File seqDataDir : seqDataDirList) {
            if (!TsFileValidationTool.checkIsDirectory(seqDataDir)) continue;
            List<File> rootTsFiles = Arrays.asList(Objects.requireNonNull(seqDataDir.listFiles(file -> file.getName().endsWith(".tsfile"))));
            TsFileValidationTool.findIncorrectFiles(rootTsFiles);
            List<File> sgDirs = Arrays.asList(Objects.requireNonNull(seqDataDir.listFiles(File::isDirectory)));
            for (File sgDir : Objects.requireNonNull(sgDirs)) {
                if (!TsFileValidationTool.checkIsDirectory(sgDir)) continue;
                if (printDetails) {
                    TsFileValidationTool.printBoth("- Check files in database: " + sgDir.getAbsolutePath());
                }
                File[] dataRegionDirs = sgDir.listFiles();
                for (File dataRegionDir : Objects.requireNonNull(dataRegionDirs)) {
                    if (!TsFileValidationTool.checkIsDirectory(dataRegionDir)) continue;
                    List timePartitionDirs = Arrays.asList(Objects.requireNonNull(dataRegionDir.listFiles())).stream().filter(file -> Pattern.compile("[0-9]*").matcher(file.getName()).matches()).collect(Collectors.toList());
                    timePartitionDirs.sort((f1, f2) -> Long.compareUnsigned(Long.parseLong(f1.getName()), Long.parseLong(f2.getName())));
                    for (File timePartitionDir : Objects.requireNonNull(timePartitionDirs)) {
                        if (!TsFileValidationTool.checkIsDirectory(timePartitionDir)) continue;
                        List<File> tsFiles = Arrays.asList(Objects.requireNonNull(timePartitionDir.listFiles(file -> file.getName().endsWith(".tsfile"))));
                        tsFiles.sort((f1, f2) -> {
                            int timeDiff = Long.compareUnsigned(Long.parseLong(f1.getName().split("-")[0]), Long.parseLong(f2.getName().split("-")[0]));
                            return timeDiff == 0 ? Long.compareUnsigned(Long.parseLong(f1.getName().split("-")[1]), Long.parseLong(f2.getName().split("-")[1])) : timeDiff;
                        });
                        TsFileValidationTool.findIncorrectFiles(tsFiles);
                    }
                    TsFileValidationTool.clearMap(false);
                }
            }
        }
        if (printDetails) {
            TsFileValidationTool.printBoth("Finish checking successfully, totally find " + TsFileValidationTool.getBadFileNum() + " bad files.");
        }
        if (printToFile) {
            pw.close();
        }
    }

    public static void findIncorrectFiles(List<File> tsFiles) {
        for (File tsFile : tsFiles) {
            validationScan.getPreviousBadFileMsgs().clear();
            validationScan.scanTsFile(tsFile);
            for (String msg : validationScan.getPreviousBadFileMsgs()) {
                TsFileValidationTool.printBoth(msg);
            }
        }
    }

    private static boolean checkArgs(String[] args) {
        if (args.length < 1) {
            System.out.println("Please input correct param, which is [path of data dir] [-pd = print details or not] [-f = path of outFile]. Eg: xxx/iotdb/data/data -pd=true -f=xxx/TsFile_validation_view.txt");
            return false;
        }
        for (String arg : args) {
            if (arg.startsWith("-pd")) {
                printDetails = Boolean.parseBoolean(arg.split("=")[1]);
                continue;
            }
            if (arg.startsWith("-if")) {
                ignoreFileOverlap = Boolean.parseBoolean(arg.split("=")[1]);
                continue;
            }
            if (arg.startsWith("-f")) {
                printToFile = true;
                outFilePath = arg.split("=")[1];
                continue;
            }
            File f = new File(arg);
            if (f.isDirectory() && Objects.requireNonNull(f.list((dir, name) -> name.equals("sequence") || name.equals("unsequence"))).length == 2) {
                File seqDataDir = new File(f, "sequence");
                seqDataDirList.add(seqDataDir);
                continue;
            }
            if (arg.endsWith(".tsfile") && f.isFile()) {
                fileList.add(f);
                continue;
            }
            System.out.println(arg + " is not a correct data directory or tsfile of IOTDB.");
            return false;
        }
        if (seqDataDirList.isEmpty() && fileList.isEmpty()) {
            System.out.println("Please input correct param, which is [path of data dir] [-pd = print details or not] [-f = path of outFile]. Eg: xxx/iotdb/data/data -pd=true -f=xxx/TsFile_validation_view.txt");
            return false;
        }
        return true;
    }

    public static void clearMap(boolean resetBadFileNum) {
        validationScan.reset(resetBadFileNum);
    }

    private static boolean checkIsDirectory(File dir) {
        boolean res = true;
        if (!dir.isDirectory()) {
            logger.error("{} is not a directory or does not exist, skip it.", (Object)dir.getAbsolutePath());
            res = false;
        }
        return res;
    }

    private static void printBoth(String msg) {
        System.out.println(msg);
        if (printToFile) {
            pw.println(msg);
        }
    }

    public static int getBadFileNum() {
        return validationScan.getBadFileNum();
    }

    public static void setBadFileNum(int badFileNum) {
        validationScan.setBadFileNum(badFileNum);
    }
}

