/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.session.subscription;

import java.time.ZoneId;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.iotdb.common.rpc.thrift.TEndPoint;
import org.apache.iotdb.isession.SessionDataSet;
import org.apache.iotdb.rpc.IoTDBConnectionException;
import org.apache.iotdb.rpc.StatementExecutionException;
import org.apache.iotdb.rpc.subscription.exception.SubscriptionException;
import org.apache.iotdb.rpc.subscription.exception.SubscriptionParameterNotValidException;
import org.apache.iotdb.session.Session;
import org.apache.iotdb.session.SessionConnection;
import org.apache.iotdb.session.subscription.SubscriptionSessionConnection;
import org.apache.iotdb.session.subscription.model.Subscription;
import org.apache.iotdb.session.subscription.model.Topic;
import org.apache.iotdb.session.subscription.util.IdentifierUtils;
import org.apache.tsfile.read.common.Field;
import org.apache.tsfile.read.common.RowRecord;

public class SubscriptionSession
extends Session {
    public SubscriptionSession(String host, int port) {
        this(host, port, "root", "root", 0x4000000);
    }

    public SubscriptionSession(String host, int port, String username, String password, int thriftMaxFrameSize) {
        super(new Session.Builder().host(host).port(port).username(username).password(password).thriftMaxFrameSize(thriftMaxFrameSize).enableAutoFetch(false).enableRedirection(false));
    }

    @Override
    public SessionConnection constructSessionConnection(Session session, TEndPoint endpoint, ZoneId zoneId) throws IoTDBConnectionException {
        if (Objects.isNull(endpoint)) {
            throw new SubscriptionParameterNotValidException("Subscription session must be configured with an endpoint.");
        }
        return new SubscriptionSessionConnection(session, endpoint, zoneId, (Supplier<List<TEndPoint>>)this.availableNodes, this.maxRetryCount, this.retryIntervalInMs);
    }

    public void createTopic(String topicName) throws IoTDBConnectionException, StatementExecutionException {
        IdentifierUtils.checkAndParseIdentifier(topicName);
        String sql = String.format("CREATE TOPIC %s", topicName);
        this.executeNonQueryStatement(sql);
    }

    public void createTopicIfNotExists(String topicName) throws IoTDBConnectionException, StatementExecutionException {
        IdentifierUtils.checkAndParseIdentifier(topicName);
        String sql = String.format("CREATE TOPIC IF NOT EXISTS %s", topicName);
        this.executeNonQueryStatement(sql);
    }

    public void createTopic(String topicName, Properties properties) throws IoTDBConnectionException, StatementExecutionException {
        IdentifierUtils.checkAndParseIdentifier(topicName);
        this.createTopic(topicName, properties, false);
    }

    public void createTopicIfNotExists(String topicName, Properties properties) throws IoTDBConnectionException, StatementExecutionException {
        IdentifierUtils.checkAndParseIdentifier(topicName);
        this.createTopic(topicName, properties, true);
    }

    private void createTopic(String topicName, Properties properties, boolean isSetIfNotExistsCondition) throws IoTDBConnectionException, StatementExecutionException {
        if (Objects.isNull(properties) || properties.isEmpty()) {
            if (isSetIfNotExistsCondition) {
                this.createTopicIfNotExists(topicName);
            } else {
                this.createTopic(topicName);
            }
            return;
        }
        StringBuilder sb = new StringBuilder();
        sb.append('(');
        properties.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(k, v) -> sb.append('\'').append(k).append('\'').append('=').append('\'').append(v).append('\'').append(',')));
        sb.deleteCharAt(sb.length() - 1);
        sb.append(')');
        String sql = isSetIfNotExistsCondition ? String.format("CREATE TOPIC IF NOT EXISTS %s WITH %s", topicName, sb) : String.format("CREATE TOPIC %s WITH %s", topicName, sb);
        this.executeNonQueryStatement(sql);
    }

    public void dropTopic(String topicName) throws IoTDBConnectionException, StatementExecutionException {
        IdentifierUtils.checkAndParseIdentifier(topicName);
        String sql = String.format("DROP TOPIC %s", topicName);
        this.executeNonQueryStatement(sql);
    }

    public void dropTopicIfExists(String topicName) throws IoTDBConnectionException, StatementExecutionException {
        IdentifierUtils.checkAndParseIdentifier(topicName);
        String sql = String.format("DROP TOPIC IF EXISTS %s", topicName);
        this.executeNonQueryStatement(sql);
    }

    public Set<Topic> getTopics() throws IoTDBConnectionException, StatementExecutionException {
        String sql = "SHOW TOPICS";
        try (SessionDataSet dataSet = this.executeQueryStatement("SHOW TOPICS");){
            Set<Topic> set = this.convertDataSetToTopics(dataSet);
            return set;
        }
    }

    public Optional<Topic> getTopic(String topicName) throws IoTDBConnectionException, StatementExecutionException {
        IdentifierUtils.checkAndParseIdentifier(topicName);
        String sql = String.format("SHOW TOPIC %s", topicName);
        try (SessionDataSet dataSet = this.executeQueryStatement(sql);){
            Set<Topic> topics = this.convertDataSetToTopics(dataSet);
            if (topics.isEmpty()) {
                Optional<Topic> optional = Optional.empty();
                return optional;
            }
            Optional<Topic> optional = Optional.of(topics.iterator().next());
            return optional;
        }
    }

    public Set<Subscription> getSubscriptions() throws IoTDBConnectionException, StatementExecutionException {
        String sql = "SHOW SUBSCRIPTIONS";
        try (SessionDataSet dataSet = this.executeQueryStatement("SHOW SUBSCRIPTIONS");){
            Set<Subscription> set = this.convertDataSetToSubscriptions(dataSet);
            return set;
        }
    }

    public Set<Subscription> getSubscriptions(String topicName) throws IoTDBConnectionException, StatementExecutionException {
        IdentifierUtils.checkAndParseIdentifier(topicName);
        String sql = String.format("SHOW SUBSCRIPTIONS ON %s", topicName);
        try (SessionDataSet dataSet = this.executeQueryStatement(sql);){
            Set<Subscription> set = this.convertDataSetToSubscriptions(dataSet);
            return set;
        }
    }

    public Set<Topic> convertDataSetToTopics(SessionDataSet dataSet) throws IoTDBConnectionException, StatementExecutionException {
        HashSet<Topic> topics = new HashSet<Topic>();
        while (dataSet.hasNext()) {
            RowRecord record = dataSet.next();
            List fields = record.getFields();
            if (fields.size() != 2) {
                throw new SubscriptionException(String.format("Unexpected fields %s was obtained during SHOW TOPIC...", fields.stream().map(Object::toString).collect(Collectors.joining(", "))));
            }
            topics.add(new Topic(((Field)fields.get(0)).getStringValue(), ((Field)fields.get(1)).getStringValue()));
        }
        return topics;
    }

    public Set<Subscription> convertDataSetToSubscriptions(SessionDataSet dataSet) throws IoTDBConnectionException, StatementExecutionException {
        HashSet<Subscription> subscriptions = new HashSet<Subscription>();
        while (dataSet.hasNext()) {
            RowRecord record = dataSet.next();
            List fields = record.getFields();
            if (fields.size() != 3) {
                throw new SubscriptionException(String.format("Unexpected fields %s was obtained during SHOW SUBSCRIPTION...", fields.stream().map(Object::toString).collect(Collectors.joining(", "))));
            }
            subscriptions.add(new Subscription(((Field)fields.get(0)).getStringValue(), ((Field)fields.get(1)).getStringValue(), ((Field)fields.get(2)).getStringValue()));
        }
        return subscriptions;
    }
}

