/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.query.reader.chunk;

import java.io.IOException;
import java.util.ArrayList;
import org.apache.iotdb.db.engine.cache.ChunkCache;
import org.apache.iotdb.tsfile.file.metadata.AlignedChunkMetadata;
import org.apache.iotdb.tsfile.file.metadata.ChunkMetadata;
import org.apache.iotdb.tsfile.file.metadata.IChunkMetadata;
import org.apache.iotdb.tsfile.read.common.Chunk;
import org.apache.iotdb.tsfile.read.controller.IChunkLoader;
import org.apache.iotdb.tsfile.read.filter.basic.Filter;
import org.apache.iotdb.tsfile.read.reader.IChunkReader;
import org.apache.iotdb.tsfile.read.reader.chunk.AlignedChunkReader;

public class DiskAlignedChunkLoader
implements IChunkLoader {
    private final boolean debug;

    public DiskAlignedChunkLoader(boolean debug) {
        this.debug = debug;
    }

    public Chunk loadChunk(ChunkMetadata chunkMetaData) {
        throw new UnsupportedOperationException();
    }

    public void close() throws IOException {
    }

    public IChunkReader getChunkReader(IChunkMetadata chunkMetaData, Filter timeFilter) throws IOException {
        AlignedChunkMetadata alignedChunkMetadata = (AlignedChunkMetadata)chunkMetaData;
        Chunk timeChunk = ChunkCache.getInstance().get((ChunkMetadata)alignedChunkMetadata.getTimeChunkMetadata(), this.debug);
        ArrayList<Chunk> valueChunkList = new ArrayList<Chunk>();
        for (IChunkMetadata valueChunkMetadata : alignedChunkMetadata.getValueChunkMetadataList()) {
            valueChunkList.add(valueChunkMetadata == null ? null : ChunkCache.getInstance().get((ChunkMetadata)valueChunkMetadata, this.debug));
        }
        return new AlignedChunkReader(timeChunk, valueChunkList, timeFilter);
    }
}

