/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.schedule.airflow.api;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.Maps;
import java.util.List;
import java.util.Map;
import okhttp3.MediaType;
import okhttp3.Request;
import okhttp3.RequestBody;
import org.apache.inlong.manager.schedule.airflow.api.AirflowApi;
import org.apache.inlong.manager.schedule.exception.AirflowScheduleException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpMethod;

public abstract class BaseAirflowApi<T>
implements AirflowApi<T> {
    private static final Logger log = LoggerFactory.getLogger(BaseAirflowApi.class);
    protected static final ObjectMapper objectMapper = new ObjectMapper();
    protected Map<String, String> pathParams = Maps.newHashMap();
    protected Map<String, Object> queryParams = Maps.newHashMap();
    protected Map<String, Object> requestBodyParams = Maps.newHashMap();

    @Override
    public abstract HttpMethod getMethod();

    @Override
    public abstract String getPath();

    @Override
    public abstract Class<T> getResponseType();

    @Override
    public Map<String, String> getPathParams() {
        return this.pathParams;
    }

    @Override
    public Map<String, Object> getQueryParams() {
        return this.queryParams;
    }

    @Override
    public RequestBody getRequestBody() {
        try {
            return RequestBody.create((MediaType)MediaType.parse((String)"application/json; charset=utf-8"), (String)objectMapper.writeValueAsString(this.requestBodyParams));
        }
        catch (Exception e) {
            log.error("Airflow request body construction failed: {}", (Object)e.getMessage(), (Object)e);
            throw new AirflowScheduleException(AirflowScheduleException.AirflowErrorCode.BUILD_REQUEST_BODY_FAILED, String.format("Airflow request body construction failed: %s", e.getMessage()));
        }
    }

    @Override
    public Request buildRequest(String baseUrl) {
        String path = this.buildPathParams(this.getPath(), this.getPathParams());
        String url = baseUrl + path;
        if (!this.getQueryParams().isEmpty()) {
            String queryString = this.buildQueryString(this.getQueryParams());
            url = url + "?" + queryString;
        }
        Request.Builder builder = new Request.Builder().url(url);
        switch (this.getMethod()) {
            case GET: {
                builder.get();
                break;
            }
            case POST: {
                builder.post(this.getRequestBody());
                break;
            }
            case PATCH: {
                builder.patch(this.getRequestBody());
                break;
            }
            case PUT: {
                builder.put(this.getRequestBody());
                break;
            }
            case DELETE: {
                if (!this.requestBodyParams.isEmpty()) {
                    builder.delete(this.getRequestBody());
                    break;
                }
                builder.delete();
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported HTTP method: " + this.getMethod());
            }
        }
        return builder.build();
    }

    private String buildPathParams(String path, Map<String, String> pathParams) {
        for (Map.Entry<String, String> entry : pathParams.entrySet()) {
            path = path.replace("{" + entry.getKey() + "}", entry.getValue());
        }
        return path;
    }

    private String buildQueryString(Map<String, Object> queryParams) {
        StringBuilder sb = new StringBuilder();
        queryParams.forEach((key, value) -> {
            if (value instanceof List) {
                ((List)value).forEach(item -> sb.append((String)key).append("=").append(item).append("&"));
            } else {
                sb.append((String)key).append("=").append(value).append("&");
            }
        });
        if (sb.length() > 0) {
            sb.setLength(sb.length() - 1);
        }
        return sb.toString();
    }
}

