/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.tubemq.corerpc;

import java.util.concurrent.TimeUnit;
import org.apache.inlong.tubemq.corebase.cluster.NodeAddrInfo;
import org.apache.inlong.tubemq.corerpc.AbstractServiceInvoker;
import org.apache.inlong.tubemq.corerpc.RequestWrapper;
import org.apache.inlong.tubemq.corerpc.ResponseWrapper;
import org.apache.inlong.tubemq.corerpc.RpcConfig;
import org.apache.inlong.tubemq.corerpc.client.Callback;
import org.apache.inlong.tubemq.corerpc.client.Client;
import org.apache.inlong.tubemq.corerpc.client.ClientFactory;
import org.apache.inlong.tubemq.corerpc.codec.PbEnDecoder;
import org.apache.inlong.tubemq.corerpc.exception.NetworkException;
import org.apache.inlong.tubemq.corerpc.exception.OverflowException;
import org.apache.inlong.tubemq.corerpc.utils.MixUtils;

public class RpcServiceInvoker
extends AbstractServiceInvoker {
    private NodeAddrInfo targetAddress;

    public RpcServiceInvoker(ClientFactory clientFactory, Class serviceClass, RpcConfig conf, NodeAddrInfo targetAddress) {
        super(clientFactory, serviceClass, conf);
        this.targetAddress = targetAddress;
    }

    public Client getClientOnce() throws Exception {
        return this.clientFactory.getClient(this.targetAddress, this.conf);
    }

    @Override
    public Object callMethod(String targetInterface, String method, Object arg, Callback callback) throws Throwable {
        Client client = this.clientFactory.getClient(this.targetAddress, this.conf);
        if (client == null) {
            throw new NetworkException("Client is null, Channel is not connected!");
        }
        if (!client.isReady()) {
            throw new NetworkException("Channel is not connected!");
        }
        if (!client.isWritable()) {
            throw new OverflowException("Channel is not writable, please try later!");
        }
        int requestTimeout = this.conf.getInt("rpc.request.timeout", 10000);
        RequestWrapper requestWrapper = new RequestWrapper(PbEnDecoder.getServiceIdByServiceName(targetInterface), 3, 0, requestTimeout);
        requestWrapper.setMethodId(PbEnDecoder.getMethIdByName(method));
        requestWrapper.setRequestData(arg);
        ResponseWrapper responseWrapper = client.call(requestWrapper, callback, requestTimeout, TimeUnit.MILLISECONDS);
        if (responseWrapper != null) {
            if (responseWrapper.isSuccess()) {
                return responseWrapper.getResponseData();
            }
            throw MixUtils.unwrapException(new StringBuilder(512).append(responseWrapper.getErrMsg()).append("#").append(responseWrapper.getStackTrace()).toString());
        }
        return null;
    }
}

