/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.mysql.legacy;

import io.debezium.config.Configuration;
import io.debezium.connector.mysql.HaltingPredicate;
import io.debezium.connector.mysql.legacy.BinlogReader;
import io.debezium.connector.mysql.legacy.ChainedReader;
import io.debezium.connector.mysql.legacy.Filters;
import io.debezium.connector.mysql.legacy.MySqlConnectorTask;
import io.debezium.connector.mysql.legacy.MySqlTaskContext;
import io.debezium.connector.mysql.legacy.Reader;
import io.debezium.connector.mysql.legacy.ReconcilingBinlogReader;
import io.debezium.connector.mysql.legacy.SnapshotReader;
import java.time.Duration;
import java.time.Instant;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.kafka.connect.source.SourceRecord;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ParallelSnapshotReader
implements Reader {
    private static final Logger LOGGER = LoggerFactory.getLogger(ParallelSnapshotReader.class);
    private final BinlogReader oldTablesReader;
    private final BinlogReader newTablesBinlogReader;
    private final ChainedReader newTablesReader;
    private final AtomicBoolean running = new AtomicBoolean(false);
    private final AtomicBoolean completed = new AtomicBoolean(false);
    private final AtomicReference<Runnable> uponCompletion = new AtomicReference();
    private final MySqlConnectorTask.ServerIdGenerator serverIdGenerator;

    public ParallelSnapshotReader(Configuration config, MySqlTaskContext noSnapshotContext, Filters snapshotFilters, MySqlConnectorTask.ServerIdGenerator serverIdGenerator) {
        this.serverIdGenerator = serverIdGenerator;
        AtomicBoolean oldTablesReaderNearEnd = new AtomicBoolean(false);
        AtomicBoolean newTablesReaderNearEnd = new AtomicBoolean(false);
        ParallelHaltingPredicate oldTablesReaderHaltingPredicate = new ParallelHaltingPredicate(oldTablesReaderNearEnd, newTablesReaderNearEnd);
        ParallelHaltingPredicate newTablesReaderHaltingPredicate = new ParallelHaltingPredicate(newTablesReaderNearEnd, oldTablesReaderNearEnd);
        this.oldTablesReader = new BinlogReader("oldBinlog", noSnapshotContext, oldTablesReaderHaltingPredicate, serverIdGenerator.getNextServerId());
        MySqlTaskContext newTablesContext = new MySqlTaskContext(config, snapshotFilters, noSnapshotContext.source().offset());
        newTablesContext.start();
        SnapshotReader newTablesSnapshotReader = new SnapshotReader("newSnapshot", newTablesContext);
        this.newTablesBinlogReader = new BinlogReader("newBinlog", newTablesContext, newTablesReaderHaltingPredicate, serverIdGenerator.getNextServerId());
        this.newTablesReader = new ChainedReader.Builder().addReader(newTablesSnapshotReader).addReader(this.newTablesBinlogReader).build();
    }

    ParallelSnapshotReader(BinlogReader oldTablesBinlogReader, SnapshotReader newTablesSnapshotReader, BinlogReader newTablesBinlogReader) {
        this.oldTablesReader = oldTablesBinlogReader;
        this.newTablesBinlogReader = newTablesBinlogReader;
        this.newTablesReader = new ChainedReader.Builder().addReader(newTablesSnapshotReader).addReader(newTablesBinlogReader).build();
        this.serverIdGenerator = null;
    }

    public ReconcilingBinlogReader createReconcilingBinlogReader(BinlogReader unifiedReader) {
        return new ReconcilingBinlogReader(this.oldTablesReader, this.newTablesBinlogReader, unifiedReader, this.serverIdGenerator.getNextServerId());
    }

    @Override
    public void uponCompletion(Runnable handler) {
        this.uponCompletion.set(handler);
    }

    @Override
    public void initialize() {
        this.oldTablesReader.initialize();
        this.newTablesReader.initialize();
    }

    @Override
    public void start() {
        if (this.running.compareAndSet(false, true)) {
            this.oldTablesReader.start();
            this.newTablesReader.start();
        }
    }

    @Override
    public void stop() {
        if (this.running.compareAndSet(true, false)) {
            try {
                LOGGER.info("Stopping the {} reader", (Object)this.oldTablesReader.name());
                this.oldTablesReader.stop();
                this.oldTablesReader.context.shutdown();
            }
            catch (Throwable t) {
                LOGGER.error("Unexpected error stopping the {} reader", (Object)this.oldTablesReader.name());
            }
            try {
                LOGGER.info("Stopping the {} reader", (Object)this.newTablesReader.name());
                this.newTablesReader.stop();
                this.oldTablesReader.context.shutdown();
            }
            catch (Throwable t) {
                LOGGER.error("Unexpected error stopping the {} reader", (Object)this.newTablesReader.name());
            }
        }
    }

    @Override
    public Reader.State state() {
        if (this.running.get()) {
            return Reader.State.RUNNING;
        }
        return Reader.State.STOPPED;
    }

    @Override
    public List<SourceRecord> poll() throws InterruptedException {
        List<SourceRecord> allRecords = this.oldTablesReader.isRunning() ? this.oldTablesReader.poll() : null;
        List<SourceRecord> newTablesRecords = this.newTablesReader.poll();
        if (newTablesRecords != null) {
            if (allRecords == null) {
                allRecords = newTablesRecords;
            } else {
                allRecords.addAll(newTablesRecords);
            }
        } else if (allRecords == null) {
            this.completeSuccessfully();
        }
        return allRecords;
    }

    private void completeSuccessfully() {
        if (this.completed.compareAndSet(false, true)) {
            this.stop();
            Runnable completionHandler = this.uponCompletion.getAndSet(null);
            if (completionHandler != null) {
                completionHandler.run();
            }
        }
    }

    @Override
    public String name() {
        return "parallelSnapshotReader";
    }

    static class ParallelHaltingPredicate
    implements HaltingPredicate {
        private static final Logger LOGGER = LoggerFactory.getLogger(ParallelHaltingPredicate.class);
        private static final Duration DEFAULT_MIN_HALTING_DURATION = Duration.ofMinutes(5L);
        private volatile AtomicBoolean thisReaderNearEnd;
        private volatile AtomicBoolean otherReaderNearEnd;
        private final Duration minHaltingDuration;

        ParallelHaltingPredicate(AtomicBoolean thisReaderNearEndRef, AtomicBoolean otherReaderNearEndRef) {
            this(thisReaderNearEndRef, otherReaderNearEndRef, DEFAULT_MIN_HALTING_DURATION);
        }

        ParallelHaltingPredicate(AtomicBoolean thisReaderNearEndRef, AtomicBoolean otherReaderNearEndRef, Duration minHaltingDuration) {
            this.otherReaderNearEnd = otherReaderNearEndRef;
            this.thisReaderNearEnd = thisReaderNearEndRef;
            this.minHaltingDuration = minHaltingDuration;
        }

        @Override
        public boolean accepts(SourceRecord ourSourceRecord) {
            Instant now;
            Instant recordTimestamp;
            Duration durationToEnd;
            Long sourceRecordTimestamp;
            if (!this.thisReaderNearEnd.get() && (sourceRecordTimestamp = (Long)ourSourceRecord.sourceOffset().get("ts_sec")) != null && (durationToEnd = Duration.between(recordTimestamp = Instant.ofEpochSecond(sourceRecordTimestamp), now = Instant.now())).compareTo(this.minHaltingDuration) <= 0) {
                LOGGER.debug("Parallel halting predicate: this reader near end");
                this.thisReaderNearEnd.set(true);
            }
            return !this.thisReaderNearEnd.get() || !this.otherReaderNearEnd.get();
        }
    }
}

