/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.tubemq.manager.service;

import com.google.gson.Gson;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.UnknownHostException;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;
import org.apache.inlong.tubemq.manager.controller.TubeMQResult;
import org.apache.inlong.tubemq.manager.controller.node.request.BaseReq;
import org.apache.inlong.tubemq.manager.entry.MasterEntry;
import org.apache.inlong.tubemq.manager.repository.MasterRepository;
import org.apache.inlong.tubemq.manager.service.TubeConst;
import org.apache.inlong.tubemq.manager.service.interfaces.MasterService;
import org.apache.inlong.tubemq.manager.service.tube.TubeHttpResponse;
import org.apache.inlong.tubemq.manager.utils.ConvertUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class MasterServiceImpl
implements MasterService {
    private static final Logger log = LoggerFactory.getLogger(MasterServiceImpl.class);
    private static CloseableHttpClient httpclient = HttpClients.createDefault();
    private static Gson gson = new Gson();
    @Autowired
    MasterRepository masterRepository;

    @Override
    public TubeMQResult requestMaster(String url) {
        log.info("start to request {}", (Object)url);
        long startTime = System.currentTimeMillis();
        if (!this.isValidURL(url)) {
            log.error("Invalid URL: {}", (Object)url);
            this.logRequestDetails(url, startTime, "Invalid URL");
            return TubeMQResult.errorResult("Invalid URL.");
        }
        String hostname = this.getHostnameFromURL(url);
        if (!this.isValidHostname(hostname)) {
            log.error("Invalid hostname: {}", (Object)hostname);
            this.logRequestDetails(url, startTime, "Invalid hostname");
            return TubeMQResult.errorResult("Invalid hostname.");
        }
        HttpGet httpGet = new HttpGet(url);
        return this.executeHttpRequest(httpGet, url, startTime);
    }

    private void logRequestDetails(String url, long startTime, String status) {
        long endTime = System.currentTimeMillis();
        long duration = endTime - startTime;
        log.info("Request Details - URL: {}, Status: {}, Duration: {} ms", new Object[]{url, status, duration});
    }

    private String getHostnameFromURL(String url) {
        try {
            URL u = new URL(url);
            return u.getHost();
        }
        catch (MalformedURLException e) {
            log.warn("Failed to extract hostname from URL: {}", (Object)e.getMessage());
            return null;
        }
    }

    private boolean isValidHostname(String hostname) {
        if (hostname == null) {
            return false;
        }
        try {
            InetAddress.getByName(hostname);
            return true;
        }
        catch (UnknownHostException e) {
            log.error("DNS resolution failed for hostname: {}", (Object)hostname, (Object)e);
            return false;
        }
    }

    private boolean isValidURL(String url) {
        try {
            URL u = new URL(url);
            String protocol = u.getProtocol().toLowerCase();
            if ("http".equals(protocol) || "https".equals(protocol)) {
                return true;
            }
        }
        catch (MalformedURLException e) {
            log.warn("URL validation failed with exception: {}", (Object)e.getMessage());
            return false;
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private TubeMQResult executeHttpRequest(HttpGet httpGet, String url, long startTime) {
        TubeMQResult defaultResult = new TubeMQResult();
        try (CloseableHttpResponse response = httpclient.execute((HttpUriRequest)httpGet);){
            TubeHttpResponse tubeResponse = (TubeHttpResponse)gson.fromJson((Reader)new InputStreamReader(response.getEntity().getContent(), StandardCharsets.UTF_8), TubeHttpResponse.class);
            if (tubeResponse.getCode() == TubeConst.SUCCESS_CODE.intValue() && tubeResponse.getErrCode() == TubeConst.SUCCESS_CODE.intValue()) {
                this.logRequestDetails(url, startTime, "Success");
                TubeMQResult tubeMQResult = defaultResult;
                return tubeMQResult;
            }
            defaultResult = TubeMQResult.errorResult(tubeResponse.getErrMsg());
            this.logRequestDetails(url, startTime, "Failed: " + tubeResponse.getErrMsg());
            return defaultResult;
        }
        catch (Exception ex) {
            log.error("exception caught while requesting broker status", (Throwable)ex);
            defaultResult = TubeMQResult.errorResult(ex.getMessage());
            this.logRequestDetails(url, startTime, "Exception: " + ex.getMessage());
        }
        return defaultResult;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public String queryMaster(String url) {
        log.info("start to request {}", (Object)url);
        if (!this.isValidURL(url)) {
            log.error("Invalid URL: {}", (Object)url);
            return gson.toJson((Object)TubeMQResult.errorResult("Invalid URL."));
        }
        HttpGet httpGet = new HttpGet(url);
        TubeMQResult defaultResult = new TubeMQResult();
        try (CloseableHttpResponse response = httpclient.execute((HttpUriRequest)httpGet);){
            String redirectedUrl = response.getHeaders("Location")[0].getValue();
            if (!url.equals(redirectedUrl) && !this.isValidURL(redirectedUrl)) {
                log.error("Invalid redirected URL: {}", (Object)redirectedUrl);
                String string2 = gson.toJson((Object)TubeMQResult.errorResult("Invalid redirected URL."));
                return string2;
            }
            String string = EntityUtils.toString((HttpEntity)response.getEntity());
            return string;
        }
        catch (Exception ex) {
            log.error("exception caught while requesting broker status", (Throwable)ex);
            defaultResult.setErrCode(-1);
            defaultResult.setResult(false);
            defaultResult.setErrMsg(ex.getMessage());
            return gson.toJson((Object)defaultResult);
        }
    }

    @Override
    public TubeMQResult baseRequestMaster(BaseReq req) {
        if (req.getClusterId() == null) {
            return TubeMQResult.errorResult("please input clusterId");
        }
        MasterEntry masterEntry = this.getMasterNode((long)req.getClusterId());
        if (masterEntry == null) {
            return TubeMQResult.errorResult("no such cluster");
        }
        String url = "http://" + masterEntry.getIp() + ":" + masterEntry.getWebPort() + "/" + "webapi.htm" + "?" + "&confModAuthToken=" + masterEntry.getToken() + "&" + ConvertUtils.convertReqToQueryStr(req);
        return this.requestMaster(url);
    }

    @Override
    public MasterEntry getMasterNode(BaseReq req) {
        if (req.getClusterId() == null) {
            return null;
        }
        return this.masterRepository.findMasterEntryByClusterIdEquals(req.getClusterId().intValue());
    }

    @Override
    public MasterEntry getMasterNode(Long clusterId) {
        if (clusterId == null) {
            return null;
        }
        List<MasterEntry> masters = this.getMasterNodes(clusterId);
        for (MasterEntry masterEntry : masters) {
            if (this.checkMasterNodeStatus(masterEntry.getIp(), masterEntry.getWebPort()).isError()) continue;
            return masterEntry;
        }
        throw new RuntimeException("cluster id " + clusterId + "no master node, please check");
    }

    @Override
    public List<MasterEntry> getMasterNodes(Long clusterId) {
        if (clusterId == null) {
            return null;
        }
        List<MasterEntry> masters = this.masterRepository.findMasterEntriesByClusterIdEquals(clusterId);
        if (CollectionUtils.isEmpty(masters)) {
            throw new RuntimeException("cluster id " + clusterId + "no master node, please check");
        }
        return masters;
    }

    @Override
    public List<MasterEntry> getMasterNodes(String masterIp) {
        if (masterIp == null) {
            return null;
        }
        List<MasterEntry> masters = this.masterRepository.findMasterEntryByIpEquals(masterIp);
        if (CollectionUtils.isEmpty(masters)) {
            throw new RuntimeException("master ip " + masterIp + "no master node, please check");
        }
        return masters;
    }

    @Override
    public String getQueryUrl(Map<String, String> queryBody) throws Exception {
        int clusterId = Integer.parseInt(queryBody.get("clusterId"));
        queryBody.remove("clusterId");
        MasterEntry masterEntry = this.getMasterNode(Long.valueOf(clusterId));
        return "http://" + masterEntry.getIp() + ":" + masterEntry.getWebPort() + "/" + "webapi.htm" + "?" + ConvertUtils.covertMapToQueryString(queryBody);
    }

    @Override
    public TubeMQResult checkMasterNodeStatus(String masterIp, Integer masterWebPort) {
        String url = "http://" + masterIp + ":" + masterWebPort + "/webapi.htm?type=op_query&method=admin_query_broker_run_status";
        return this.requestMaster(url);
    }

    @Override
    public String getQueryCountUrl(Integer clusterId, String method) {
        MasterEntry masterEntry = this.getMasterNode((long)clusterId);
        return "http://" + masterEntry.getIp() + ":" + masterEntry.getWebPort() + method + "&clusterId=" + clusterId;
    }

    @Override
    public void deleteMaster(Long clusterId) {
        Integer successCode = this.masterRepository.deleteByClusterId(clusterId);
        if (successCode.equals(TubeConst.DELETE_FAIL)) {
            throw new RuntimeException("no such master with clusterId = " + clusterId);
        }
    }
}

