/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.web.auth.tenant;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.apache.inlong.manager.common.util.Preconditions;
import org.apache.inlong.manager.pojo.tenant.InlongTenantInfo;
import org.apache.inlong.manager.pojo.user.InlongRoleInfo;
import org.apache.inlong.manager.pojo.user.LoginUserUtils;
import org.apache.inlong.manager.pojo.user.TenantRoleInfo;
import org.apache.inlong.manager.pojo.user.UserInfo;
import org.apache.inlong.manager.service.tenant.InlongTenantService;
import org.apache.inlong.manager.service.user.InlongRoleService;
import org.apache.inlong.manager.service.user.TenantRoleService;
import org.apache.inlong.manager.service.user.UserService;
import org.apache.inlong.manager.web.auth.tenant.TenantToken;
import org.apache.shiro.authc.AuthenticationException;
import org.apache.shiro.authc.AuthenticationInfo;
import org.apache.shiro.authc.AuthenticationToken;
import org.apache.shiro.authc.SimpleAuthenticationInfo;
import org.apache.shiro.realm.AuthenticatingRealm;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TenantAuthenticatingRealm
extends AuthenticatingRealm {
    private static final Logger log = LoggerFactory.getLogger(TenantAuthenticatingRealm.class);
    private TenantRoleService tenantRoleService;
    private InlongRoleService inlongRoleService;
    private UserService userService;
    private InlongTenantService tenantService;

    public TenantAuthenticatingRealm(TenantRoleService tenantRoleService, InlongRoleService inlongRoleService, UserService userService, InlongTenantService tenantService) {
        this.tenantRoleService = tenantRoleService;
        this.inlongRoleService = inlongRoleService;
        this.userService = userService;
        this.tenantService = tenantService;
    }

    public AuthenticationInfo doGetAuthenticationInfo(AuthenticationToken token) throws AuthenticationException {
        try {
            TenantToken tenantToken = (TenantToken)token;
            String username = tenantToken.getUsername();
            String tenant = tenantToken.getTenant();
            InlongTenantInfo tenantInfo = this.tenantService.getByName(tenant);
            if (tenantInfo == null) {
                String errMsg = String.format("tenant=[%s] not found", tenant);
                log.error(errMsg);
                throw new AuthenticationException(errMsg);
            }
            InlongRoleInfo inlongRoleInfo = this.inlongRoleService.getByUsername(username);
            TenantRoleInfo tenantRoleInfo = this.tenantRoleService.getByUsernameAndTenant(username, tenant);
            if (inlongRoleInfo == null && tenantRoleInfo == null) {
                String errMsg = String.format("user=[%s] has no privilege for tenant=[%s]", username, tenant);
                log.error(errMsg);
                throw new AuthenticationException(errMsg);
            }
            UserInfo userInfo = this.getUserInfo(username);
            if (inlongRoleInfo != null) {
                this.addRole(userInfo, inlongRoleInfo.getRoleCode());
            }
            if (tenantRoleInfo != null) {
                this.addRole(userInfo, tenantRoleInfo.getRoleCode());
            }
            userInfo.setTenant(tenant);
            return new SimpleAuthenticationInfo((Object)userInfo, (Object)tenant, this.getName());
        }
        catch (Throwable t) {
            log.error("failed to do tenant authentication", t);
            throw t;
        }
    }

    public boolean supports(AuthenticationToken token) {
        return token instanceof TenantToken;
    }

    private UserInfo getUserInfo(String userName) {
        UserInfo userInfo = LoginUserUtils.getLoginUser();
        if (userInfo == null) {
            userInfo = this.userService.getByName(userName);
        }
        Preconditions.expectNotNull((Object)userInfo, (String)"User doesn't exist");
        return userInfo;
    }

    private void addRole(UserInfo userInfo, final String role) {
        HashSet<String> roleSet = new HashSet<String>(){
            {
                this.add(role);
            }
        };
        if (CollectionUtils.isEmpty((Collection)userInfo.getRoles())) {
            roleSet.addAll(userInfo.getRoles());
        }
        userInfo.setRoles((Set)roleSet);
    }
}

