/*
 * Decompiled with CFR 0.152.
 */
package kafka.tools;

import com.typesafe.scalalogging.Logger;
import java.io.OutputStream;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Objects;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.MBeanInfo;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;
import javax.rmi.ssl.SslRMIClientSocketFactory;
import joptsimple.ArgumentAcceptingOptionSpec;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;
import joptsimple.OptionSpecBuilder;
import kafka.utils.CommandLineUtils$;
import kafka.utils.Exit$;
import kafka.utils.Logging;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.generic.CanBuildFrom;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.Set;
import scala.jdk.CollectionConverters$;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Null$;
import scala.runtime.ObjectRef;

public final class JmxTool$
implements Logging {
    public static JmxTool$ MODULE$;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    static {
        new JmxTool$();
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public void main(String[] args) {
        Map numExpectedAttributes;
        OptionParser parser = new OptionParser(false);
        ArgumentAcceptingOptionSpec objectNameOpt = parser.accepts("object-name", "A JMX object name to use as a query. This can contain wild cards, and this option can be given multiple times to specify more than one query. If no objects are specified all objects will be queried.").withRequiredArg().describedAs("name").ofType(String.class);
        ArgumentAcceptingOptionSpec attributesOpt = parser.accepts("attributes", "The list of attributes to include in the query. This is a comma-separated list. If no attributes are specified all objects will be queried.").withRequiredArg().describedAs("name").ofType(String.class);
        ArgumentAcceptingOptionSpec reportingIntervalOpt = parser.accepts("reporting-interval", "Interval in MS with which to poll jmx stats; default value is 2 seconds. Value of -1 equivalent to setting one-time to true").withRequiredArg().describedAs("ms").ofType(Integer.class).defaultsTo((Object)Predef$.MODULE$.int2Integer(2000), (Object[])new Integer[0]);
        ArgumentAcceptingOptionSpec oneTimeOpt = parser.accepts("one-time", "Flag to indicate run once only.").withRequiredArg().describedAs("one-time").ofType(Boolean.class).defaultsTo((Object)Predef$.MODULE$.boolean2Boolean(false), (Object[])new Boolean[0]);
        ArgumentAcceptingOptionSpec dateFormatOpt = parser.accepts("date-format", "The date format to use for formatting the time field. See java.text.SimpleDateFormat for options.").withRequiredArg().describedAs("format").ofType(String.class);
        ArgumentAcceptingOptionSpec jmxServiceUrlOpt = parser.accepts("jmx-url", "The url to connect to poll JMX data. See Oracle javadoc for JMXServiceURL for details.").withRequiredArg().describedAs("service-url").ofType(String.class).defaultsTo((Object)"service:jmx:rmi:///jndi/rmi://:9999/jmxrmi", (Object[])new String[0]);
        ArgumentAcceptingOptionSpec reportFormatOpt = parser.accepts("report-format", "output format name: either 'original', 'properties', 'csv', 'tsv' ").withRequiredArg().describedAs("report-format").ofType(String.class).defaultsTo((Object)"original", (Object[])new String[0]);
        ArgumentAcceptingOptionSpec jmxAuthPropOpt = parser.accepts("jmx-auth-prop", "A mechanism to pass property in the form 'username=password' when enabling remote JMX with password authentication.").withRequiredArg().describedAs("jmx-auth-prop").ofType(String.class);
        ArgumentAcceptingOptionSpec jmxSslEnableOpt = parser.accepts("jmx-ssl-enable", "Flag to enable remote JMX with SSL.").withRequiredArg().describedAs("ssl-enable").ofType(Boolean.class).defaultsTo((Object)Predef$.MODULE$.boolean2Boolean(false), (Object[])new Boolean[0]);
        OptionSpecBuilder waitOpt = parser.accepts("wait", "Wait for requested JMX objects to become available before starting output. Only supported when the list of objects is non-empty and contains no object name patterns.");
        OptionSpecBuilder helpOpt = parser.accepts("help", "Print usage information.");
        if (args.length == 0) {
            throw CommandLineUtils$.MODULE$.printUsageAndDie(parser, "Dump JMX values to standard output.");
        }
        OptionSet options = parser.parse(args);
        if (options.has((OptionSpec)helpOpt)) {
            parser.printHelpOn((OutputStream)System.out);
            throw Exit$.MODULE$.exit(0, Exit$.MODULE$.exit$default$2());
        }
        JMXServiceURL url = new JMXServiceURL((String)options.valueOf((OptionSpec)jmxServiceUrlOpt));
        int interval = (Integer)options.valueOf((OptionSpec)reportingIntervalOpt);
        boolean oneTime = interval < 0 || options.has((OptionSpec)oneTimeOpt);
        boolean attributesIncludeExists = options.has((OptionSpec)attributesOpt);
        None$ attributesInclude = attributesIncludeExists ? new Some(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])((String)options.valueOf((OptionSpec)attributesOpt)).split(","))).filterImpl((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)x$1.equals("")), true)) : None$.MODULE$;
        None$ dateFormat = options.has((OptionSpec)dateFormatOpt) ? new Some((Object)new SimpleDateFormat((String)options.valueOf((OptionSpec)dateFormatOpt))) : None$.MODULE$;
        boolean wait = options.has((OptionSpec)waitOpt);
        String reportFormat = this.parseFormat(((String)options.valueOf((OptionSpec)reportFormatOpt)).toLowerCase());
        boolean reportFormatOriginal = reportFormat.equals("original");
        boolean enablePasswordAuth = options.has((OptionSpec)jmxAuthPropOpt);
        boolean enableSsl = options.has((OptionSpec)jmxSslEnableOpt);
        ObjectRef mbsc = ObjectRef.create(null);
        boolean connected = false;
        int connectTimeoutMs = 10000;
        long connectTestStarted = System.currentTimeMillis();
        do {
            try {
                System.err.println(new StringBuilder(31).append("Trying to connect to JMX url: ").append(url).append(".").toString());
                HashMap<String, Object> env = new HashMap<String, Object>();
                if (enableSsl) {
                    SslRMIClientSocketFactory csf = new SslRMIClientSocketFactory();
                    env.put("com.sun.jndi.rmi.factory.socket", csf);
                }
                if (enablePasswordAuth) {
                    String[] credentials = ((String)options.valueOf((OptionSpec)jmxAuthPropOpt)).split("=", 2);
                    env.put("jmx.remote.credentials", credentials);
                }
                JMXConnector jmxc = JMXConnectorFactory.connect(url, env);
                mbsc.elem = jmxc.getMBeanServerConnection();
                connected = true;
            }
            catch (Exception e) {
                System.err.println(new StringBuilder(43).append("Could not connect to JMX url: ").append(url).append(". Exception ").append(e.getMessage()).append(".").toString());
                e.printStackTrace();
                Thread.sleep(100L);
            }
        } while (System.currentTimeMillis() - connectTestStarted < (long)connectTimeoutMs && !connected);
        if (!connected) {
            System.err.println(new StringBuilder(40).append("Could not connect to JMX url ").append(url).append(" after ").append(connectTimeoutMs).append(" ms.").toString());
            System.err.println("Exiting.");
            throw scala.sys.package$.MODULE$.exit(1);
        }
        List queries = options.has((OptionSpec)objectNameOpt) ? (Iterable)((TraversableLike)CollectionConverters$.MODULE$.asScalaBufferConverter(options.valuesOf((OptionSpec)objectNameOpt)).asScala()).map((Function1 & Serializable & scala.Serializable)x$2 -> new ObjectName((String)x$2), Buffer$.MODULE$.canBuildFrom()) : List$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Null$[]{null}));
        boolean hasPatternQueries = ((IterableLike)queries.filterNot((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)JmxTool$.$anonfun$main$3(x$1)))).exists((Function1 & Serializable & scala.Serializable)name -> BoxesRunTime.boxToBoolean((boolean)name.isPattern()));
        ObjectRef names = ObjectRef.create(null);
        int waitTimeoutMs = 10000;
        if (!hasPatternQueries) {
            long start = System.currentTimeMillis();
            do {
                if ((Iterable)names.elem != null) {
                    System.err.println("Could not find all object names, retrying");
                    Thread.sleep(100L);
                }
                names.elem = (Iterable)queries.flatMap((Function1 & Serializable & scala.Serializable)name -> (Set)CollectionConverters$.MODULE$.asScalaSetConverter(((MBeanServerConnection)mbsc$1.elem).queryNames((ObjectName)name, null)).asScala(), Iterable$.MODULE$.canBuildFrom());
            } while (wait && System.currentTimeMillis() - start < (long)waitTimeoutMs && !JmxTool$.foundAllObjects$1((Iterable)queries, names));
        }
        if (wait && !JmxTool$.foundAllObjects$1((Iterable)queries, names)) {
            String missing = queries.toSet().$minus((Object)JmxTool$.namesSet$1(names)).mkString(", ");
            System.err.println(new StringBuilder(61).append("Could not find all requested object names after ").append(waitTimeoutMs).append(" ms. Missing ").append(missing).toString());
            System.err.println("Exiting.");
            throw scala.sys.package$.MODULE$.exit(1);
        }
        Map map = !attributesIncludeExists ? ((TraversableOnce)((Iterable)names.elem).map((Function1 & Serializable & scala.Serializable)name -> {
            MBeanInfo mbean = ((MBeanServerConnection)mbsc$1.elem).getMBeanInfo((ObjectName)name);
            return new Tuple2(name, (Object)BoxesRunTime.boxToInteger((int)((MBeanServerConnection)mbsc$1.elem).getAttributes((ObjectName)name, (String[])TraversableLike.map$((TraversableLike)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])mbean.getAttributes())), (Function1 & Serializable & scala.Serializable)x$3 -> x$3.getName(), (CanBuildFrom)Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)))).size()));
        }, Iterable$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms()) : (numExpectedAttributes = !hasPatternQueries ? (Map)((TraversableOnce)((Iterable)names.elem).map(arg_0 -> JmxTool$.$anonfun$main$8(mbsc, (Option)attributesInclude, arg_0), Iterable$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms()).filter((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)JmxTool$.$anonfun$main$11(x$5))) : ((TraversableOnce)queries.map(arg_0 -> JmxTool$.$anonfun$main$12((Option)attributesInclude, arg_0), Iterable$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms()));
        if (numExpectedAttributes.isEmpty()) {
            throw CommandLineUtils$.MODULE$.printUsageAndDie(parser, new StringBuilder(47).append("No matched attributes for the queried objects ").append(queries).append(".").toString());
        }
        List keys = (List)new .colon.colon((Object)"time", (List)Nil$.MODULE$).$plus$plus((GenTraversableOnce)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.queryAttributes((MBeanServerConnection)mbsc.elem, (Iterable<ObjectName>)((Iterable)names.elem), (Option<String[]>)attributesInclude).keys().toArray(ClassTag$.MODULE$.apply(String.class)))).sorted((Ordering)Ordering.String$.MODULE$))), List$.MODULE$.canBuildFrom());
        if (reportFormatOriginal && keys.size() == BoxesRunTime.unboxToInt((Object)numExpectedAttributes.values().sum((Numeric)Numeric.IntIsIntegral$.MODULE$)) + 1) {
            Predef$.MODULE$.println((Object)((TraversableOnce)keys.map((Function1 & Serializable & scala.Serializable)x$7 -> new StringBuilder(2).append("\"").append((String)x$7).append("\"").toString(), List$.MODULE$.canBuildFrom())).mkString(","));
        }
        boolean keepGoing = true;
        while (keepGoing) {
            String string;
            long start = System.currentTimeMillis();
            scala.collection.mutable.Map<String, Object> attributes = this.queryAttributes((MBeanServerConnection)mbsc.elem, (Iterable<ObjectName>)((Iterable)names.elem), (Option<String[]>)attributesInclude);
            if (dateFormat instanceof Some) {
                string = ((SimpleDateFormat)((Some)dateFormat).value()).format(new Date());
            } else if (None$.MODULE$.equals(dateFormat)) {
                string = ((Object)BoxesRunTime.boxToLong((long)System.currentTimeMillis())).toString();
            } else {
                throw new MatchError((Object)dateFormat);
            }
            attributes.update((Object)"time", (Object)string);
            if (attributes.keySet().size() == BoxesRunTime.unboxToInt((Object)numExpectedAttributes.values().sum((Numeric)Numeric.IntIsIntegral$.MODULE$)) + 1) {
                if (reportFormatOriginal) {
                    Predef$.MODULE$.println((Object)((TraversableOnce)keys.map((Function1 & Serializable & scala.Serializable)x$8 -> attributes.apply(x$8), List$.MODULE$.canBuildFrom())).mkString(","));
                } else if (reportFormat.equals("properties")) {
                    if (keys == null) {
                        throw null;
                    }
                    List foreach_these = keys;
                    while (!foreach_these.isEmpty()) {
                        String string2 = (String)foreach_these.head();
                        Predef$.MODULE$.println((Object)new StringBuilder(1).append(string2).append("=").append(attributes.apply((Object)string2)).toString());
                        foreach_these = (List)foreach_these.tail();
                    }
                } else if (reportFormat.equals("csv")) {
                    if (keys == null) {
                        throw null;
                    }
                    List foreach_these = keys;
                    while (!foreach_these.isEmpty()) {
                        String string3 = (String)foreach_these.head();
                        Predef$.MODULE$.println((Object)new StringBuilder(3).append(string3).append(",\"").append(attributes.apply((Object)string3)).append("\"").toString());
                        foreach_these = (List)foreach_these.tail();
                    }
                } else {
                    if (keys == null) {
                        throw null;
                    }
                    List foreach_these = keys;
                    while (!foreach_these.isEmpty()) {
                        String string4 = (String)foreach_these.head();
                        Predef$.MODULE$.println((Object)new StringBuilder(1).append(string4).append("\t").append(attributes.apply((Object)string4)).toString());
                        foreach_these = (List)foreach_these.tail();
                    }
                }
            }
            if (oneTime) {
                keepGoing = false;
                continue;
            }
            Thread.sleep(package$.MODULE$.max(0L, (long)interval - (System.currentTimeMillis() - start)));
        }
    }

    public scala.collection.mutable.Map<String, Object> queryAttributes(MBeanServerConnection mbsc, Iterable<ObjectName> names, Option<String[]> attributesInclude) {
        scala.collection.mutable.HashMap attributes = new scala.collection.mutable.HashMap();
        names.foreach((Function1 & Serializable & scala.Serializable)name -> {
            JmxTool$.$anonfun$queryAttributes$1(mbsc, attributesInclude, attributes, name);
            return BoxedUnit.UNIT;
        });
        return attributes;
    }

    public String parseFormat(String reportFormatOpt) {
        String string = "properties".equals(reportFormatOpt) ? "properties" : ("csv".equals(reportFormatOpt) ? "csv" : ("tsv".equals(reportFormatOpt) ? "tsv" : "original"));
        return string;
    }

    public static final /* synthetic */ boolean $anonfun$main$3(Object x$1) {
        return Objects.isNull(x$1);
    }

    private static final scala.collection.immutable.Set namesSet$1(ObjectRef names$1) {
        return (scala.collection.immutable.Set)Option$.MODULE$.option2Iterable(Option$.MODULE$.apply((Object)((Iterable)names$1.elem))).toSet().flatten((Function1)Predef$.MODULE$.$conforms());
    }

    private static final boolean foundAllObjects$1(Iterable queries$1, ObjectRef names$1) {
        scala.collection.immutable.Set set = queries$1.toSet();
        scala.collection.immutable.Set set2 = JmxTool$.namesSet$1(names$1);
        return !(set != null ? !set.equals(set2) : set2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$main$10(Option attributesInclude$1, Attribute attr) {
        return new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])attributesInclude$1.get())).contains((Object)attr.getName());
    }

    public static final /* synthetic */ Tuple2 $anonfun$main$8(ObjectRef mbsc$1, Option attributesInclude$1, ObjectName name) {
        MBeanInfo mbean = ((MBeanServerConnection)mbsc$1.elem).getMBeanInfo(name);
        AttributeList attributes = ((MBeanServerConnection)mbsc$1.elem).getAttributes(name, (String[])TraversableLike.map$((TraversableLike)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])mbean.getAttributes())), (Function1 & Serializable & scala.Serializable)x$4 -> x$4.getName(), (CanBuildFrom)Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))));
        Buffer expectedAttributes = (Buffer)((Buffer)CollectionConverters$.MODULE$.asScalaBufferConverter((java.util.List)attributes).asScala()).filter((Function1 & Serializable & scala.Serializable)attr -> BoxesRunTime.boxToBoolean((boolean)JmxTool$.$anonfun$main$10(attributesInclude$1, attr)));
        return new Tuple2((Object)name, (Object)BoxesRunTime.boxToInteger((int)expectedAttributes.size()));
    }

    public static final /* synthetic */ boolean $anonfun$main$11(Tuple2 x$5) {
        return x$5._2$mcI$sp() > 0;
    }

    public static final /* synthetic */ Tuple2 $anonfun$main$12(Option attributesInclude$1, ObjectName x$6) {
        return new Tuple2((Object)x$6, (Object)BoxesRunTime.boxToInteger((int)((String[])attributesInclude$1.get()).length));
    }

    public static final /* synthetic */ void $anonfun$queryAttributes$3(Option attributesInclude$2, scala.collection.mutable.HashMap attributes$2, ObjectName name$1, Object attrObj) {
        Attribute attr = (Attribute)attrObj;
        if (attributesInclude$2 instanceof Some) {
            String[] allowedAttributes = (String[])((Some)attributesInclude$2).value();
            if (new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])allowedAttributes)).contains((Object)attr.getName())) {
                attributes$2.update((Object)new StringBuilder(1).append(name$1.toString()).append(":").append(attr.getName()).toString(), attr.getValue());
                return;
            }
        } else {
            if (None$.MODULE$.equals(attributesInclude$2)) {
                attributes$2.update((Object)new StringBuilder(1).append(name$1.toString()).append(":").append(attr.getName()).toString(), attr.getValue());
                return;
            }
            throw new MatchError((Object)attributesInclude$2);
        }
    }

    public static final /* synthetic */ void $anonfun$queryAttributes$1(MBeanServerConnection mbsc$2, Option attributesInclude$2, scala.collection.mutable.HashMap attributes$2, ObjectName name) {
        MBeanInfo mbean = mbsc$2.getMBeanInfo(name);
        ((IterableLike)CollectionConverters$.MODULE$.asScalaBufferConverter((java.util.List)mbsc$2.getAttributes(name, (String[])TraversableLike.map$((TraversableLike)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])mbean.getAttributes())), (Function1 & Serializable & scala.Serializable)x$9 -> x$9.getName(), (CanBuildFrom)Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))).asScala()).foreach((Function1 & Serializable & scala.Serializable)attrObj -> {
            JmxTool$.$anonfun$queryAttributes$3(attributesInclude$2, attributes$2, name, attrObj);
            return BoxedUnit.UNIT;
        });
    }

    private JmxTool$() {
        MODULE$ = this;
        Logging.$init$(this);
    }

    public static final /* synthetic */ Object $anonfun$main$15$adapted(scala.collection.mutable.Map attributes$1, String k) {
        Predef$.MODULE$.println((Object)new StringBuilder(1).append(k).append("=").append(attributes$1.apply((Object)k)).toString());
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$main$16$adapted(scala.collection.mutable.Map attributes$1, String k) {
        Predef$.MODULE$.println((Object)new StringBuilder(3).append(k).append(",\"").append(attributes$1.apply((Object)k)).append("\"").toString());
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$main$17$adapted(scala.collection.mutable.Map attributes$1, String k) {
        Predef$.MODULE$.println((Object)new StringBuilder(1).append(k).append("\t").append(attributes$1.apply((Object)k)).toString());
        return BoxedUnit.UNIT;
    }
}

