/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.tubemq.server.master.nodemanage.nodebroker;

import java.util.ArrayList;
import java.util.Date;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.inlong.tubemq.corebase.rv.ProcessResult;
import org.apache.inlong.tubemq.corebase.utils.Tuple2;
import org.apache.inlong.tubemq.server.common.statusdef.ManageStatus;
import org.apache.inlong.tubemq.server.master.metamanage.MetaDataService;
import org.apache.inlong.tubemq.server.master.metamanage.metastore.dao.entity.BaseEntity;
import org.apache.inlong.tubemq.server.master.metamanage.metastore.dao.entity.BrokerConfEntity;
import org.apache.inlong.tubemq.server.master.stats.MasterSrvStatsHolder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BrokerAbnHolder {
    private static final Logger logger = LoggerFactory.getLogger(BrokerAbnHolder.class);
    private final ConcurrentHashMap<Integer, BrokerAbnInfo> brokerAbnormalMap = new ConcurrentHashMap();
    private final ConcurrentHashMap<Integer, BrokerFbdInfo> brokerForbiddenMap = new ConcurrentHashMap();
    private final int maxAutoForbiddenCnt;
    private final MetaDataService metaDataService;
    private final AtomicInteger brokerForbiddenCount = new AtomicInteger(0);

    public BrokerAbnHolder(int maxAutoForbiddenCnt, MetaDataService metaDataService) {
        this.maxAutoForbiddenCnt = maxAutoForbiddenCnt;
        this.metaDataService = metaDataService;
    }

    public void updateBrokerReportStatus(int brokerId, int reportReadStatus, int reportWriteStatus) {
        BrokerFbdInfo brokerFbdInfo;
        ManageStatus curStatus;
        StringBuilder sBuffer = new StringBuilder(512);
        ManageStatus reqMngStatus = this.getManageStatus(reportWriteStatus, reportReadStatus);
        if (reqMngStatus == ManageStatus.STATUS_MANAGE_ONLINE) {
            BrokerAbnInfo brokerAbnInfo = this.brokerAbnormalMap.get(brokerId);
            if (brokerAbnInfo != null && this.brokerForbiddenMap.get(brokerId) == null && (brokerAbnInfo = this.brokerAbnormalMap.remove(brokerId)) != null) {
                MasterSrvStatsHolder.decBrokerAbnormalCnt();
                logger.warn(sBuffer.append("[Broker AutoForbidden] broker ").append(brokerId).append(" return to normal!").toString());
                sBuffer.delete(0, sBuffer.length());
            }
            return;
        }
        BrokerConfEntity curEntry = this.metaDataService.getBrokerConfByBrokerId(brokerId);
        if (curEntry == null) {
            return;
        }
        BrokerAbnInfo brokerAbnInfo = this.brokerAbnormalMap.get(brokerId);
        if (brokerAbnInfo == null) {
            if (this.brokerAbnormalMap.putIfAbsent(brokerId, new BrokerAbnInfo(brokerId, reportReadStatus, reportWriteStatus)) == null) {
                MasterSrvStatsHolder.incBrokerAbnormalCnt();
                logger.warn(sBuffer.append("[Broker AutoForbidden] broker report abnormal, ").append(brokerId).append("'s reportReadStatus=").append(reportReadStatus).append(", reportWriteStatus=").append(reportWriteStatus).toString());
                sBuffer.delete(0, sBuffer.length());
            }
        } else {
            brokerAbnInfo.updateLastRepStatus(reportReadStatus, reportWriteStatus);
        }
        if ((curStatus = curEntry.getManageStatus()) == reqMngStatus || curStatus.getCode() < ManageStatus.STATUS_MANAGE_ONLINE.getCode() || curStatus.getCode() >= ManageStatus.STATUS_MANAGE_OFFLINE.getCode()) {
            return;
        }
        ManageStatus newStatus = reqMngStatus;
        if (reqMngStatus == ManageStatus.STATUS_MANAGE_ONLINE_NOT_WRITE && curStatus == ManageStatus.STATUS_MANAGE_ONLINE_NOT_READ) {
            newStatus = ManageStatus.STATUS_MANAGE_OFFLINE;
        }
        if ((brokerFbdInfo = this.brokerForbiddenMap.get(brokerId)) == null) {
            BrokerFbdInfo tmpFbdInfo = new BrokerFbdInfo(brokerId, curStatus, newStatus, System.currentTimeMillis());
            if (reportReadStatus > 0 || reportWriteStatus > 0) {
                if (this.updateCurManageStatus(brokerId, newStatus, sBuffer) && this.brokerForbiddenMap.putIfAbsent(brokerId, tmpFbdInfo) == null) {
                    this.brokerForbiddenCount.incrementAndGet();
                    MasterSrvStatsHolder.incBrokerForbiddenCnt();
                    logger.warn(sBuffer.append("[Broker AutoForbidden] master add missing forbidden broker, ").append(brokerId).append("'s manage status to ").append(newStatus.getDescription()).toString());
                    sBuffer.delete(0, sBuffer.length());
                }
            } else {
                if (this.brokerForbiddenCount.incrementAndGet() > this.maxAutoForbiddenCnt) {
                    this.brokerForbiddenCount.decrementAndGet();
                    return;
                }
                if (this.updateCurManageStatus(brokerId, newStatus, sBuffer)) {
                    if (this.brokerForbiddenMap.putIfAbsent(brokerId, tmpFbdInfo) != null) {
                        this.brokerForbiddenCount.decrementAndGet();
                        return;
                    }
                    MasterSrvStatsHolder.incBrokerForbiddenCnt();
                    logger.warn(sBuffer.append("[Broker AutoForbidden] master auto forbidden broker, ").append(brokerId).append("'s manage status to ").append(newStatus.getDescription()).toString());
                    sBuffer.delete(0, sBuffer.length());
                } else {
                    this.brokerForbiddenCount.decrementAndGet();
                }
            }
        } else if (this.updateCurManageStatus(brokerId, newStatus, sBuffer)) {
            brokerFbdInfo.updateInfo(curStatus, newStatus);
        }
    }

    public Tuple2<Boolean, Boolean> getBrokerAutoFbdStatus(int brokerId) {
        Tuple2 retTuple = new Tuple2((Object)false, (Object)false);
        BrokerFbdInfo brokerFbdInfo = this.brokerForbiddenMap.get(brokerId);
        if (brokerFbdInfo == null) {
            return retTuple;
        }
        retTuple.setF0AndF1((Object)(!brokerFbdInfo.newStatus.isAcceptPublish() ? 1 : 0), (Object)(!brokerFbdInfo.newStatus.isAcceptSubscribe() ? 1 : 0));
        return retTuple;
    }

    public void removeBroker(Integer brokerId) {
        BrokerFbdInfo brokerFbdInfo;
        BrokerAbnInfo abnInfo = this.brokerAbnormalMap.remove(brokerId);
        if (abnInfo != null) {
            MasterSrvStatsHolder.decBrokerAbnormalCnt();
        }
        if ((brokerFbdInfo = this.brokerForbiddenMap.remove(brokerId)) != null) {
            this.brokerForbiddenCount.decrementAndGet();
            MasterSrvStatsHolder.decBrokerForbiddenCnt();
        }
    }

    public void clear() {
        this.brokerForbiddenCount.set(0);
        this.brokerAbnormalMap.clear();
        this.brokerForbiddenMap.clear();
    }

    public int getCurrentBrokerCount() {
        return this.brokerForbiddenCount.get();
    }

    private ManageStatus getManageStatus(int repWriteStatus, int repReadStatus) {
        ManageStatus manageStatus = repWriteStatus == 0 && repReadStatus == 0 ? ManageStatus.STATUS_MANAGE_ONLINE : (repReadStatus != 0 ? ManageStatus.STATUS_MANAGE_OFFLINE : ManageStatus.STATUS_MANAGE_ONLINE_NOT_WRITE);
        return manageStatus;
    }

    private boolean updateCurManageStatus(int brokerId, ManageStatus newMngStatus, StringBuilder sBuffer) {
        ProcessResult result = new ProcessResult();
        BaseEntity opEntity = new BaseEntity(-2L, "Broker AutoReport", new Date());
        this.metaDataService.changeBrokerConfStatus(opEntity, brokerId, newMngStatus, sBuffer, result);
        return result.isSuccess();
    }

    public Map<Integer, BrokerAbnInfo> getBrokerAbnormalMap() {
        return this.brokerAbnormalMap;
    }

    public BrokerFbdInfo getAutoForbiddenBrokerInfo(int brokerId) {
        return this.brokerForbiddenMap.get(brokerId);
    }

    public Map<Integer, BrokerFbdInfo> getAutoForbiddenBrokerMapInfo() {
        return this.brokerForbiddenMap;
    }

    public void relAutoForbiddenBrokerInfo(Set<Integer> brokerIdSet, String reason) {
        if (brokerIdSet == null || brokerIdSet.isEmpty()) {
            return;
        }
        ArrayList<BrokerFbdInfo> brokerFbdInfos = new ArrayList<BrokerFbdInfo>();
        for (Integer brokerId : brokerIdSet) {
            BrokerFbdInfo fbdInfo = this.brokerForbiddenMap.remove(brokerId);
            if (fbdInfo == null) continue;
            brokerFbdInfos.add(fbdInfo);
            BrokerAbnInfo abnInfo = this.brokerAbnormalMap.remove(brokerId);
            if (abnInfo != null) {
                MasterSrvStatsHolder.decBrokerAbnormalCnt();
            }
            this.brokerForbiddenCount.decrementAndGet();
            MasterSrvStatsHolder.decBrokerForbiddenCnt();
        }
        if (!brokerFbdInfos.isEmpty()) {
            logger.info(new StringBuilder(512).append("[Broker AutoForbidden] remove forbidden brokers by reason ").append(reason).append(", release list is ").append(((Object)brokerFbdInfos).toString()).toString());
        }
    }

    public static class BrokerFbdInfo {
        private int brokerId;
        private ManageStatus befStatus;
        private ManageStatus newStatus;
        private long forbiddenTime;
        private long lastUpdateTime;

        public BrokerFbdInfo(int brokerId, ManageStatus befStatus, ManageStatus newStatus, long forbiddenTime) {
            this.brokerId = brokerId;
            this.befStatus = befStatus;
            this.newStatus = newStatus;
            this.forbiddenTime = forbiddenTime;
            this.lastUpdateTime = forbiddenTime;
        }

        public void updateInfo(ManageStatus befStatus, ManageStatus newStatus) {
            this.befStatus = befStatus;
            this.newStatus = newStatus;
            this.lastUpdateTime = System.currentTimeMillis();
        }

        public String toString() {
            return new ToStringBuilder((Object)this).append("brokerId", this.brokerId).append("befStatus", (Object)this.befStatus).append("newStatus", (Object)this.newStatus).append("forbiddenTime", this.forbiddenTime).append("lastUpdateTime", this.lastUpdateTime).toString();
        }
    }

    public static class BrokerAbnInfo {
        private int brokerId;
        private int abnStatus;
        private long firstRepTime;
        private long lastRepTime;

        public BrokerAbnInfo(int brokerId, int reportReadStatus, int reportWriteStatus) {
            this.brokerId = brokerId;
            this.abnStatus = reportReadStatus * 100 + reportWriteStatus;
            this.lastRepTime = this.firstRepTime = System.currentTimeMillis();
        }

        public void updateLastRepStatus(int reportReadStatus, int reportWriteStatus) {
            this.abnStatus = reportReadStatus * 100 + reportWriteStatus;
            this.lastRepTime = System.currentTimeMillis();
        }

        public int getAbnStatus() {
            return this.abnStatus;
        }

        public long getFirstRepTime() {
            return this.firstRepTime;
        }

        public long getLastRepTime() {
            return this.lastRepTime;
        }

        public String toString() {
            return new ToStringBuilder((Object)this).append("brokerId", this.brokerId).append("abnStatus", this.abnStatus).append("firstRepTime", this.firstRepTime).append("lastRepTime", this.lastRepTime).toString();
        }
    }
}

