/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sdk.dataproxy.network.tcp;

import java.net.InetSocketAddress;
import java.security.SecureRandom;
import java.util.HashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.inlong.common.msg.MsgType;
import org.apache.inlong.dataproxy.shaded.io.netty.bootstrap.Bootstrap;
import org.apache.inlong.dataproxy.shaded.io.netty.channel.Channel;
import org.apache.inlong.dataproxy.shaded.io.netty.channel.ChannelFuture;
import org.apache.inlong.dataproxy.shaded.io.netty.channel.ChannelFutureListener;
import org.apache.inlong.dataproxy.shaded.org.apache.commons.lang3.StringUtils;
import org.apache.inlong.sdk.dataproxy.common.ErrorCode;
import org.apache.inlong.sdk.dataproxy.common.ProcessResult;
import org.apache.inlong.sdk.dataproxy.common.ProxyClientConfig;
import org.apache.inlong.sdk.dataproxy.config.HostInfo;
import org.apache.inlong.sdk.dataproxy.network.tcp.codec.EncodeObject;
import org.apache.inlong.sdk.dataproxy.sender.tcp.TcpMsgSenderConfig;
import org.apache.inlong.sdk.dataproxy.utils.AuthzUtils;
import org.apache.inlong.sdk.dataproxy.utils.LogCounter;
import org.apache.inlong.sdk.dataproxy.utils.ProxyUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TcpNettyClient {
    private static final int CLIENT_FAIL_CONNECT_WAIT_CNT = 3;
    private static final Logger logger = LoggerFactory.getLogger(TcpNettyClient.class);
    private static final LogCounter conExptCnt = new LogCounter(10L, 100000L, 60000L);
    private static final LogCounter hbExptCnt = new LogCounter(10L, 100000L, 60000L);
    private static final int CLIENT_STATUS_INIT = -1;
    private static final int CLIENT_STATUS_READY = 0;
    private static final int CLIENT_STATUS_FROZEN = 1;
    private static final int CLIENT_STATUS_DEAD = 2;
    private static final int CLIENT_STATUS_BUSY = 3;
    private final String senderId;
    private final TcpMsgSenderConfig tcpConfig;
    private final Bootstrap bootstrap;
    private final HostInfo hostInfo;
    private final AtomicInteger conStatus = new AtomicInteger(-1);
    private final AtomicLong channelTermId = new AtomicLong(0L);
    private final AtomicInteger clientUsingCnt = new AtomicInteger(0);
    private final AtomicInteger msgSentCnt = new AtomicInteger(0);
    private final AtomicInteger msgInflightCnt = new AtomicInteger(0);
    private final AtomicLong chanInvalidTime = new AtomicLong(0L);
    private final AtomicInteger conFailCnt = new AtomicInteger(0);
    private final AtomicLong lstConFailTime = new AtomicLong(0L);
    private final AtomicInteger chanSyncTimeoutCnt = new AtomicInteger(0);
    private final AtomicLong chanFstBusyTime = new AtomicLong(0L);
    private final ReentrantReadWriteLock rw = new ReentrantReadWriteLock();
    private Channel channel = null;
    private String channelStr = "";
    private int lstRoundSentCnt = -1;
    private int clientIdleRounds = 0;
    private long fstIdleTime = 0L;

    public TcpNettyClient(String senderId, Bootstrap bootstrap, HostInfo hostInfo, TcpMsgSenderConfig tcpConfig) {
        this.conStatus.set(-1);
        this.hostInfo = hostInfo;
        this.tcpConfig = tcpConfig;
        this.senderId = senderId;
        this.bootstrap = bootstrap;
    }

    public boolean connect(boolean needPrint, long termId) {
        this.conStatus.set(-1);
        long curTime = System.currentTimeMillis();
        final CountDownLatch awaitLatch = new CountDownLatch(1);
        ChannelFuture future = this.bootstrap.connect(new InetSocketAddress(this.hostInfo.getHostName(), this.hostInfo.getPortNumber()));
        future.addListener(new ChannelFutureListener(){

            @Override
            public void operationComplete(ChannelFuture arg0) throws Exception {
                awaitLatch.countDown();
            }
        });
        try {
            awaitLatch.await(this.tcpConfig.getConnectTimeoutMs(), TimeUnit.MILLISECONDS);
        }
        catch (Throwable ex) {
            if (conExptCnt.shouldPrint()) {
                logger.warn("NettyClient({}) connect to {} exception", new Object[]{this.senderId, this.hostInfo.getReferenceName(), ex});
            }
            return false;
        }
        if (!future.isSuccess()) {
            this.conFailCnt.getAndIncrement();
            this.lstConFailTime.set(System.currentTimeMillis());
            if (conExptCnt.shouldPrint()) {
                logger.warn("NettyClient({}) connect to {} failure, wast {}ms", new Object[]{this.senderId, this.hostInfo.getReferenceName(), System.currentTimeMillis() - curTime});
            }
            return false;
        }
        this.channelTermId.set(termId);
        this.channel = future.channel();
        this.channelStr = this.channel.toString();
        this.conFailCnt.set(0);
        this.msgSentCnt.set(0);
        this.chanSyncTimeoutCnt.set(0);
        this.msgInflightCnt.set(0);
        this.conStatus.set(0);
        if (needPrint) {
            logger.info("NettyClient({}) connect to {} success, wast {}ms", new Object[]{this.senderId, this.channel.toString(), System.currentTimeMillis() - curTime});
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean close(boolean needPrint) {
        this.conStatus.set(2);
        long curTime = System.currentTimeMillis();
        this.chanInvalidTime.set(curTime);
        final CountDownLatch awaitLatch = new CountDownLatch(1);
        boolean ret = true;
        String channelStr = "";
        try {
            if (this.channel == null) {
                channelStr = this.hostInfo.getReferenceName();
            } else {
                channelStr = this.channel.toString();
                ChannelFuture future = this.channel.close();
                future.addListener(new ChannelFutureListener(){

                    @Override
                    public void operationComplete(ChannelFuture arg0) throws Exception {
                        awaitLatch.countDown();
                    }
                });
                awaitLatch.await(this.tcpConfig.getConCloseWaitPeriodMs(), TimeUnit.MILLISECONDS);
                if (!future.isSuccess()) {
                    ret = false;
                }
            }
        }
        catch (Throwable ex) {
            if (conExptCnt.shouldPrint()) {
                logger.warn("NettyClient({}) close {} exception", new Object[]{this.senderId, channelStr, ex});
            }
            ret = false;
        }
        finally {
            this.channel = null;
            this.channelStr = "";
            this.msgInflightCnt.set(0);
        }
        if (needPrint) {
            if (ret) {
                logger.info("NettyClient({}) close {} success, wast {}ms", new Object[]{this.senderId, channelStr, System.currentTimeMillis() - curTime});
            } else {
                logger.info("NettyClient({}) close {} failure, wast {}ms", new Object[]{this.senderId, channelStr, System.currentTimeMillis() - curTime});
            }
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean reconnect(boolean needPrint, long termId) {
        long curTime = System.currentTimeMillis();
        if (this.conFailCnt.get() >= 3 && curTime - this.lstConFailTime.get() < this.tcpConfig.getReconFailWaitMs()) {
            return false;
        }
        int curStatus = this.conStatus.get();
        if (curStatus == 0) {
            return true;
        }
        if (curStatus == 3 ? curTime - this.chanInvalidTime.get() < this.tcpConfig.getBusyReconnectWaitMs() : curStatus == 1 && curTime - this.chanInvalidTime.get() < this.tcpConfig.getFrozenReconnectWaitMs()) {
            return false;
        }
        this.rw.writeLock().lock();
        try {
            if (this.conStatus.get() == 0) {
                boolean bl = true;
                return bl;
            }
            curTime = System.currentTimeMillis();
            this.close(false);
            if (this.connect(false, termId)) {
                if (needPrint) {
                    logger.info("NettyClient({}) re-connect to {} success, wast {}ms", new Object[]{this.senderId, this.channel.toString(), System.currentTimeMillis() - curTime});
                }
                boolean bl = true;
                return bl;
            }
            if (needPrint) {
                logger.info("NettyClient({}) re-connect to {} failure", (Object)this.senderId, (Object)this.hostInfo.getReferenceName());
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.rw.writeLock().unlock();
        }
    }

    public int incClientUsingCnt() {
        return this.clientUsingCnt.incrementAndGet();
    }

    public int getClientUsingCnt() {
        return this.clientUsingCnt.get();
    }

    public int decClientUsingCnt() {
        return this.clientUsingCnt.decrementAndGet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean write(long termId, EncodeObject encodeObject, ProcessResult procResult) {
        if (this.conStatus.get() != 0) {
            return procResult.setFailResult(ErrorCode.CONNECTION_UNAVAILABLE);
        }
        this.rw.readLock().lock();
        if (this.conStatus.get() != 0) {
            return procResult.setFailResult(ErrorCode.CONNECTION_UNAVAILABLE);
        }
        if (this.channelTermId.get() != termId) {
            return procResult.setFailResult(ErrorCode.CONNECTION_BREAK);
        }
        if (!(this.channel.isOpen() && this.channel.isActive() && this.channel.isWritable())) {
            return procResult.setFailResult(ErrorCode.CONNECTION_UNWRITABLE);
        }
        try {
            this.msgSentCnt.incrementAndGet();
            this.channel.writeAndFlush(encodeObject);
            this.msgInflightCnt.incrementAndGet();
            boolean bl = procResult.setSuccess();
            return bl;
        }
        catch (Throwable ex) {
            if (conExptCnt.shouldPrint()) {
                logger.warn("NettyClient({}) write {} exception", new Object[]{this.senderId, this.channel.toString(), ex});
            }
            boolean bl = procResult.setFailResult(ErrorCode.CONNECTION_WRITE_EXCEPTION, ex.getMessage());
            return bl;
        }
        finally {
            this.rw.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setFrozen(long termId) {
        if (this.channelTermId.get() != termId || this.conStatus.get() != 0) {
            return;
        }
        boolean changed = false;
        this.rw.readLock().lock();
        try {
            if (this.channelTermId.get() != termId) {
                return;
            }
            int curStatus = this.conStatus.get();
            if (curStatus == 0) {
                this.conStatus.compareAndSet(curStatus, 1);
                this.chanInvalidTime.set(System.currentTimeMillis());
                changed = true;
            }
        }
        finally {
            this.rw.readLock().unlock();
        }
        if (changed) {
            logger.warn("NettyClient({}) set {} frozen!", (Object)this.senderId, (Object)this.hostInfo.getReferenceName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setBusy(long termId) {
        if (this.channelTermId.get() != termId || this.conStatus.get() != 0) {
            return;
        }
        boolean changed = false;
        long curTime = System.currentTimeMillis();
        this.rw.readLock().lock();
        try {
            if (this.channelTermId.get() != termId) {
                return;
            }
            long befTime = this.chanFstBusyTime.get();
            if (curTime - befTime >= this.tcpConfig.getSyncMsgTimeoutChkDurMs() && this.chanFstBusyTime.compareAndSet(befTime, curTime)) {
                this.chanSyncTimeoutCnt.set(0);
            }
            int curTimeoutCnt = this.chanSyncTimeoutCnt.incrementAndGet();
            if (this.tcpConfig.getMaxAllowedSyncMsgTimeoutCnt() >= 0 && curTimeoutCnt < this.tcpConfig.getMaxAllowedSyncMsgTimeoutCnt()) {
                return;
            }
            int curStatus = this.conStatus.get();
            if (curStatus == 0) {
                this.conStatus.compareAndSet(curStatus, 3);
                this.chanInvalidTime.set(System.currentTimeMillis());
                changed = true;
            }
        }
        finally {
            this.rw.readLock().unlock();
        }
        if (changed) {
            logger.warn("NettyClient({}) set {} busy!", (Object)this.senderId, (Object)this.hostInfo.getReferenceName());
        }
    }

    public boolean isActive() {
        if (this.conStatus.get() != 0) {
            return false;
        }
        this.rw.readLock().lock();
        try {
            boolean bl = this.conStatus.get() == 0 && this.channel != null && this.channel.isOpen() && this.channel.isActive();
            return bl;
        }
        finally {
            this.rw.readLock().unlock();
        }
    }

    public void sendHeartBeatMsg(ProcessResult procResult) {
        block6: {
            if (!this.isActive()) {
                logger.warn("NettyClient({}) to {} hb inActive", (Object)this.senderId, (Object)this.hostInfo.getReferenceName());
                return;
            }
            if (!this.channel.isWritable()) {
                if (hbExptCnt.shouldPrint()) {
                    logger.warn("NettyClient({}) to {} hb write_over_water", (Object)this.senderId, (Object)this.channelStr);
                }
                return;
            }
            EncodeObject encodeObject = this.buildHeartBeatMsg(this.senderId, this.tcpConfig);
            if (encodeObject == null && hbExptCnt.shouldPrint()) {
                logger.warn("NettyClient({}) to {} hb failure:{}!", new Object[]{this.senderId, this.channelStr, procResult.getErrMsg()});
            }
            try {
                this.write(this.channelTermId.get(), encodeObject, procResult);
            }
            catch (Throwable ex) {
                if (!hbExptCnt.shouldPrint()) break block6;
                logger.warn("NettyClient({}) send to {} hb exception ", new Object[]{this.senderId, this.channelStr, ex});
            }
        }
        procResult.setSuccess();
    }

    public boolean isIdleClient(long curTime) {
        int curSentCnt = this.msgSentCnt.get();
        if (curSentCnt != this.lstRoundSentCnt) {
            this.lstRoundSentCnt = curSentCnt;
            this.clientIdleRounds = 0;
            return false;
        }
        if (this.clientIdleRounds++ == 0) {
            this.fstIdleTime = curTime;
            return false;
        }
        return curTime - this.fstIdleTime >= 30000L;
    }

    public String getClientAddr() {
        return this.hostInfo.getReferenceName();
    }

    public Channel getChannel() {
        return this.channel;
    }

    public String getChanStr() {
        return this.channelStr;
    }

    public void decInFlightMsgCnt(long termId) {
        if (this.channelTermId.get() != termId) {
            return;
        }
        this.msgInflightCnt.decrementAndGet();
    }

    public int getMsgInflightCnt() {
        return this.msgInflightCnt.get();
    }

    public boolean isConFailNodes() {
        return this.conFailCnt.get() >= 3;
    }

    public long getChanTermId() {
        return this.channelTermId.get();
    }

    public long getChanInvalidTime() {
        return this.chanInvalidTime.get();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TcpNettyClient other = (TcpNettyClient)obj;
        if (this.channel == null) {
            return other.channel == null;
        }
        return this.channel.equals(other.channel);
    }

    private EncodeObject buildHeartBeatMsg(String senderId, ProxyClientConfig configure) {
        EncodeObject encObject = new EncodeObject(null, null, MsgType.MSG_BIN_HEARTBEAT, System.currentTimeMillis(), 30);
        encObject.setMessageIdInfo(0);
        int intMsgType = encObject.getMsgType().getValue();
        HashMap<String, String> newAttrs = new HashMap<String, String>();
        if (configure.isEnableReportAuthz()) {
            intMsgType |= 0x80;
            long timestamp = System.currentTimeMillis();
            int nonce = new SecureRandom(String.valueOf(timestamp).getBytes()).nextInt(Integer.MAX_VALUE);
            String signature = AuthzUtils.generateSignature(configure.getRptUserName(), timestamp, nonce, configure.getRptSecretKey());
            if (StringUtils.isBlank(signature)) {
                return null;
            }
            newAttrs.put("_userName", configure.getRptUserName());
            newAttrs.put("_clientIP", ProxyUtils.getLocalIp());
            newAttrs.put("_signature", signature);
            newAttrs.put("_timeStamp", String.valueOf(timestamp));
            newAttrs.put("_nonce", String.valueOf(nonce));
        }
        encObject.setAttrInfo(intMsgType, false, null, newAttrs);
        return encObject;
    }
}

