/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.resourcemanager.slotmanager;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.flink.api.common.JobID;
import org.apache.flink.runtime.clusterframework.types.ResourceProfile;
import org.apache.flink.runtime.instance.InstanceID;
import org.apache.flink.runtime.resourcemanager.slotmanager.PendingTaskManager;
import org.apache.flink.runtime.resourcemanager.slotmanager.PendingTaskManagerId;
import org.apache.flink.runtime.util.ResourceCounter;

public class ResourceAllocationResult {
    private final Set<JobID> unfulfillableJobs;
    private final Map<JobID, Map<InstanceID, ResourceCounter>> allocationsOnRegisteredResources;
    private final List<PendingTaskManager> pendingTaskManagersToAllocate;
    private final Map<PendingTaskManagerId, Map<JobID, ResourceCounter>> allocationsOnPendingResources;

    private ResourceAllocationResult(Set<JobID> unfulfillableJobs, Map<JobID, Map<InstanceID, ResourceCounter>> allocationsOnRegisteredResources, List<PendingTaskManager> pendingTaskManagersToAllocate, Map<PendingTaskManagerId, Map<JobID, ResourceCounter>> allocationsOnPendingResources) {
        this.unfulfillableJobs = unfulfillableJobs;
        this.allocationsOnRegisteredResources = allocationsOnRegisteredResources;
        this.pendingTaskManagersToAllocate = pendingTaskManagersToAllocate;
        this.allocationsOnPendingResources = allocationsOnPendingResources;
    }

    public List<PendingTaskManager> getPendingTaskManagersToAllocate() {
        return Collections.unmodifiableList(this.pendingTaskManagersToAllocate);
    }

    public Set<JobID> getUnfulfillableJobs() {
        return Collections.unmodifiableSet(this.unfulfillableJobs);
    }

    public Map<JobID, Map<InstanceID, ResourceCounter>> getAllocationsOnRegisteredResources() {
        return Collections.unmodifiableMap(this.allocationsOnRegisteredResources);
    }

    public Map<PendingTaskManagerId, Map<JobID, ResourceCounter>> getAllocationsOnPendingResources() {
        return Collections.unmodifiableMap(this.allocationsOnPendingResources);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private final Set<JobID> unfulfillableJobs = new HashSet<JobID>();
        private final Map<JobID, Map<InstanceID, ResourceCounter>> allocationsOnRegisteredResources = new HashMap<JobID, Map<InstanceID, ResourceCounter>>();
        private final List<PendingTaskManager> pendingTaskManagersToAllocate = new ArrayList<PendingTaskManager>();
        private final Map<PendingTaskManagerId, Map<JobID, ResourceCounter>> allocationsOnPendingResources = new HashMap<PendingTaskManagerId, Map<JobID, ResourceCounter>>();

        public Builder addUnfulfillableJob(JobID jobId) {
            this.unfulfillableJobs.add(jobId);
            return this;
        }

        public Builder addPendingTaskManagerAllocate(PendingTaskManager pendingTaskManager) {
            this.pendingTaskManagersToAllocate.add(pendingTaskManager);
            return this;
        }

        public Builder addAllocationOnPendingResource(JobID jobId, PendingTaskManagerId pendingTaskManagerId, ResourceProfile resourceProfile) {
            this.allocationsOnPendingResources.computeIfAbsent(pendingTaskManagerId, ignored -> new HashMap()).compute(jobId, (id, counter) -> {
                if (counter == null) {
                    return ResourceCounter.withResource(resourceProfile, 1);
                }
                return counter.add(resourceProfile, 1);
            });
            return this;
        }

        public Builder addAllocationOnRegisteredResource(JobID jobId, InstanceID instanceId, ResourceProfile resourceProfile) {
            this.allocationsOnRegisteredResources.computeIfAbsent(jobId, jobID -> new HashMap()).compute(instanceId, (id, counter) -> {
                if (counter == null) {
                    return ResourceCounter.withResource(resourceProfile, 1);
                }
                return counter.add(resourceProfile, 1);
            });
            return this;
        }

        public ResourceAllocationResult build() {
            return new ResourceAllocationResult(this.unfulfillableJobs, this.allocationsOnRegisteredResources, this.pendingTaskManagersToAllocate, this.allocationsOnPendingResources);
        }
    }
}

