/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sdk.transform.process.function.string;

import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.expression.Function;
import org.apache.inlong.sdk.transform.decode.SourceData;
import org.apache.inlong.sdk.transform.process.Context;
import org.apache.inlong.sdk.transform.process.function.TransformFunction;
import org.apache.inlong.sdk.transform.process.operator.OperatorTools;
import org.apache.inlong.sdk.transform.process.parser.ValueParser;

@TransformFunction(type="string", names={"regexp_extract"}, parameter="(String str, String regexp, [Integer extractIndex])", descriptions={"- Return \"\" if any of the arguments are NULL or invalid;", "- Return a string from 'str' which extracted with a specified regexp expression 'regexp' and a regexp match group index 'extractIndex'.", "Note: 'regexp' must be a Java regular expression. 'extractIndex' indicates which regexp group to extract and starts from 1, also the default value if not specified. 0 means matching the entire 'regexp' expression. In addition, the regexp match group index should not exceed the number of the defined groups."}, examples={"REGEXP_EXTRACT(\"abc123def\", \"(\\\\d+)\", 1) = 123", "REGEXP_EXTRACT(\"Name: John, Age: 25, Location: NY\", \"Name: (\\\\w+), Age: (\\\\d+), Location: (\\\\w+)\", 2) = 25", "REGEXP_EXTRACT(\"abc123def\", \"(\\\\d+)\", 2) = null", "REGEXP_EXTRACT(\"abc123def\", \"abcdef\", 1) = null"})
public class RegexpExtractFunction
implements ValueParser {
    private ValueParser inputStringParser;
    private ValueParser patternStringParser;
    private ValueParser indexIntegerParser;

    public RegexpExtractFunction(Function expr) {
        List expressions;
        if (expr.getParameters() != null && (expressions = expr.getParameters().getExpressions()) != null && expressions.size() >= 3) {
            this.inputStringParser = OperatorTools.buildParser((Expression)expressions.get(0));
            this.patternStringParser = OperatorTools.buildParser((Expression)expressions.get(1));
            this.indexIntegerParser = OperatorTools.buildParser((Expression)expressions.get(2));
        }
    }

    @Override
    public Object parse(SourceData sourceData, int rowIndex, Context context) {
        if (this.inputStringParser == null || this.patternStringParser == null || this.indexIntegerParser == null) {
            return null;
        }
        String inputString = OperatorTools.parseString(this.inputStringParser.parse(sourceData, rowIndex, context));
        String patternString = OperatorTools.parseString(this.patternStringParser.parse(sourceData, rowIndex, context));
        int indexInteger = OperatorTools.parseBigDecimal(this.indexIntegerParser.parse(sourceData, rowIndex, context)).intValue();
        if (indexInteger < 0) {
            return null;
        }
        Pattern pattern = Pattern.compile(patternString);
        Matcher matcher = pattern.matcher(inputString);
        if (matcher.find() && indexInteger <= matcher.groupCount()) {
            return matcher.group(indexInteger);
        }
        return null;
    }
}

