/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.agent.plugin.utils.regex;

import hirondelle.date4j.DateTime;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.apache.inlong.agent.plugin.utils.regex.MatchPoint;
import org.apache.inlong.agent.plugin.utils.regex.NonRegexPatternPosition;
import org.apache.inlong.agent.plugin.utils.regex.PathDateExpression;
import org.apache.inlong.agent.utils.DateTransUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DateUtils {
    private static final String YEAR = "YYYY";
    private static final String YEAR_LOWERCASE = "yyyy";
    private static final String MONTH = "MM";
    private static final String DAY = "DD";
    private static final String DAY_LOWERCASE = "dd";
    private static final String HOUR = "HH";
    private static final String HOUR_LOWERCASE = "hh";
    private static final String MINUTE = "mm";
    public static final String DEFAULT_FORMAT = "yyyyMMddHHmm";
    public static final String DEFAULT_TIME_ZONE = "Asia/Shanghai";
    private static final Logger logger = LoggerFactory.getLogger(DateUtils.class);
    private static final String TIME_REGEX = "YYYY(?:.MM|MM)?(?:.DD|DD)?(?:.hh|hh)?(?:.mm|mm)?(?:.ss|ss)?";
    private static final Pattern pattern = Pattern.compile("YYYY(?:.MM|MM)?(?:.DD|DD)?(?:.hh|hh)?(?:.mm|mm)?(?:.ss|ss)?", 42);
    private static final Pattern bracePatt = Pattern.compile("\\{(.*?)\\}");
    private static final int DEFAULT_LENGTH = "yyyyMMddHHmm".length();
    public static long DAY_TIMEOUT_INTERVAL = 172800000L;
    public static long HOUR_TIMEOUT_INTERVAL = 0x6DDD00L;

    public static String getShouldStartTime(String dataTime, String cycleUnit, String offset) {
        if (dataTime == null || dataTime.length() > 12) {
            return null;
        }
        SimpleDateFormat dateFormat = new SimpleDateFormat(DEFAULT_FORMAT);
        TimeZone timeZone = TimeZone.getTimeZone(DEFAULT_TIME_ZONE);
        dateFormat.setTimeZone(timeZone);
        if (dataTime.length() < DEFAULT_LENGTH) {
            StringBuffer sb = new StringBuffer();
            for (int i = 0; i < DEFAULT_LENGTH - dataTime.length(); ++i) {
                sb.append("0");
            }
            dataTime = dataTime + sb.toString();
        }
        Calendar calendar = Calendar.getInstance();
        try {
            calendar.setTimeInMillis(dateFormat.parse(dataTime).getTime());
        }
        catch (ParseException e) {
            return null;
        }
        offset = offset.startsWith("-") ? offset.substring(1, offset.length()) : "-" + offset;
        return dateFormat.format(new Date(DateUtils.getDateTime(calendar, cycleUnit, offset).getTimeInMillis()));
    }

    private static Calendar getDateTime(Calendar calendar, String cycleUnit, String offset) {
        int cycleNumber = cycleUnit.length() <= 1 ? 1 : Integer.parseInt(cycleUnit.substring(0, cycleUnit.length() - 1));
        String offsetUnit = offset.substring(offset.length() - 1, offset.length());
        int offsetNumber = Integer.parseInt(offset.substring(0, offset.length() - 1));
        if (cycleUnit.length() > 1 && StringUtils.endsWithIgnoreCase((String)cycleUnit, (String)"M")) {
            calendar.set(13, 0);
            int minTime = calendar.get(12);
            int leftMin = minTime % cycleNumber;
            calendar.set(12, minTime -= leftMin);
            if ("d".equalsIgnoreCase(offsetUnit)) {
                calendar.add(6, offsetNumber);
            }
            if ("H".equalsIgnoreCase(offsetUnit)) {
                calendar.add(11, offsetNumber);
            }
        } else if (cycleUnit.length() == 1) {
            if ("d".equalsIgnoreCase(cycleUnit)) {
                calendar.set(11, 0);
                calendar.set(12, 0);
                calendar.set(13, 0);
            } else if ("H".equalsIgnoreCase(cycleUnit)) {
                calendar.set(12, 0);
                calendar.set(13, 0);
            }
        }
        if ("d".equalsIgnoreCase(offsetUnit)) {
            calendar.add(6, offsetNumber);
        }
        if ("H".equalsIgnoreCase(offsetUnit)) {
            calendar.add(11, offsetNumber);
        }
        if ("m".equals(offsetUnit)) {
            calendar.add(12, offsetNumber);
        }
        return calendar;
    }

    public static boolean isValidCreationTime(String dataTime, String cycleUnit, String timeOffset) {
        long timeInterval = 0L;
        if ("d".equalsIgnoreCase(cycleUnit)) {
            timeInterval = DAY_TIMEOUT_INTERVAL;
        } else if ("H".equalsIgnoreCase(cycleUnit)) {
            timeInterval = HOUR_TIMEOUT_INTERVAL;
        } else if (cycleUnit.endsWith("m")) {
            timeInterval = HOUR_TIMEOUT_INTERVAL;
        } else {
            logger.error("cycleUnit {} can't parse!", (Object)cycleUnit);
            timeInterval = DAY_TIMEOUT_INTERVAL;
        }
        timeInterval = timeOffset.startsWith("-") ? (timeInterval -= DateTransUtils.calcOffset((String)timeOffset)) : (timeInterval += DateTransUtils.calcOffset((String)timeOffset));
        return DateUtils.isValidCreationTime(dataTime, timeInterval);
    }

    public static boolean isValidCreationTime(String dataTime, long timeInterval) {
        long currentTime = System.currentTimeMillis();
        long minTime = currentTime - timeInterval;
        long maxTime = currentTime + timeInterval;
        SimpleDateFormat dateFormat = new SimpleDateFormat(DEFAULT_FORMAT);
        if (dataTime.length() < DEFAULT_LENGTH) {
            StringBuffer sb = new StringBuffer();
            for (int i = 0; i < DEFAULT_LENGTH - dataTime.length(); ++i) {
                sb.append("0");
            }
            dataTime = dataTime + sb.toString();
        }
        Calendar calendar = Calendar.getInstance();
        try {
            calendar.setTimeInMillis(dateFormat.parse(dataTime).getTime());
        }
        catch (ParseException e) {
            return false;
        }
        return calendar.getTimeInMillis() >= minTime && calendar.getTimeInMillis() <= maxTime;
    }

    public static String getDateTime(String fileName, PathDateExpression dateExpression) {
        if (fileName == null || dateExpression == null || dateExpression.getLongestDatePattern() == null) {
            return null;
        }
        String longestDatePattern = DateUtils.replaceDateExpressionWithRegex(dateExpression.getLongestDatePattern());
        NonRegexPatternPosition patternPosition = dateExpression.getPatternPosition();
        Matcher mat = Pattern.compile(longestDatePattern).matcher(fileName);
        boolean find = mat.find();
        if (!find) {
            logger.error("Can't find the pattern {} for file name {}", (Object)longestDatePattern, (Object)fileName);
            return null;
        }
        String dateTime = fileName.substring(mat.start(), mat.end());
        if (patternPosition == NonRegexPatternPosition.PREFIX) {
            dateTime = dateTime.substring(1, dateTime.length());
        } else if (patternPosition == NonRegexPatternPosition.SUFFIX) {
            dateTime = dateTime.substring(0, dateTime.length() - 1);
        } else if (patternPosition == NonRegexPatternPosition.BOTH) {
            dateTime = dateTime.substring(1, dateTime.length() - 1);
        } else if (patternPosition == NonRegexPatternPosition.END) {
            dateTime = dateTime.substring(0, dateTime.length());
        } else if (patternPosition == NonRegexPatternPosition.ENDSUFFIX) {
            dateTime = dateTime.substring(1, dateTime.length());
        } else if (patternPosition == NonRegexPatternPosition.NONE) {
            logger.error("The data path configuration is invalid");
            dateTime = null;
        }
        return dateTime;
    }

    public static ArrayList<MatchPoint> extractAllTimeRegex(String src) {
        Matcher m = pattern.matcher(src);
        ArrayList<MatchPoint> arr = new ArrayList<MatchPoint>();
        while (m.find()) {
            String oneMatch = m.group(0);
            arr.add(new MatchPoint(oneMatch, m.start(), m.end()));
        }
        return arr;
    }

    public static String replaceDateExpressionWithRegex(String dataPath) {
        if (dataPath == null) {
            return null;
        }
        StringBuffer sb = new StringBuffer();
        ArrayList<MatchPoint> mp = DateUtils.extractAllTimeRegex(dataPath);
        if (mp == null || mp.size() == 0) {
            return dataPath;
        }
        int lastIndex = 0;
        for (MatchPoint m : mp) {
            lastIndex = DateUtils.replacePattern(dataPath, sb, m, "\\d{4}", "\\d{2}", "\\d{2}", "\\d{2}", "\\d{2}", lastIndex);
        }
        sb.append(dataPath.substring(lastIndex));
        return sb.toString();
    }

    private static int replacePattern(String dataPath, StringBuffer sb, MatchPoint m, String year, String month, String day, String hour, String minute, int lastIndex) {
        sb.append(dataPath, lastIndex, m.getStart());
        String longestPattern = m.getStr();
        int hhIndex = longestPattern.indexOf(HOUR);
        if (hhIndex == -1) {
            hhIndex = longestPattern.indexOf(HOUR_LOWERCASE);
        }
        int mmIndex = longestPattern.indexOf(MINUTE);
        longestPattern = longestPattern.replace(YEAR, year);
        longestPattern = longestPattern.replace(YEAR_LOWERCASE, year);
        longestPattern = longestPattern.replace(MONTH, month);
        longestPattern = longestPattern.replace(DAY, day);
        longestPattern = longestPattern.replace(DAY_LOWERCASE, day);
        longestPattern = longestPattern.replace(HOUR, hour);
        longestPattern = longestPattern.replace(HOUR_LOWERCASE, hour);
        if (hhIndex != -1 && mmIndex != -1 && mmIndex >= hhIndex + 2 && mmIndex < hhIndex + 4) {
            longestPattern = longestPattern.replace(MINUTE, minute);
        }
        sb.append(longestPattern);
        return m.getEnd();
    }

    public static String replaceDateExpression(Calendar dateTime, String dataPath) {
        if (dataPath == null) {
            return null;
        }
        String year = String.valueOf(dateTime.get(1));
        String month = String.valueOf(dateTime.get(2) + 1);
        String day = String.valueOf(dateTime.get(5));
        String hour = String.valueOf(dateTime.get(11));
        String minute = String.valueOf(dateTime.get(12));
        StringBuffer sb = new StringBuffer();
        ArrayList<MatchPoint> mp = DateUtils.extractAllTimeRegex(dataPath);
        if (mp == null || mp.size() == 0) {
            return dataPath;
        }
        int lastIndex = 0;
        for (MatchPoint m : mp) {
            lastIndex = DateUtils.replacePattern(dataPath, sb, m, year, DateUtils.externDate(month), DateUtils.externDate(day), DateUtils.externDate(hour), DateUtils.externDate(minute), lastIndex);
        }
        sb.append(dataPath.substring(lastIndex));
        return sb.toString();
    }

    public static String externDate(String time) {
        if (time.length() == 1) {
            return "0" + time;
        }
        return time;
    }

    public static List<Long> getDateRegion(long startTime, long endTime, String cycleUnit) {
        ArrayList<Long> ret = new ArrayList<Long>();
        DateTime dtStart = DateTime.forInstant((long)startTime, (TimeZone)TimeZone.getDefault());
        DateTime dtEnd = DateTime.forInstant((long)endTime, (TimeZone)TimeZone.getDefault());
        if (cycleUnit.equals("d")) {
            dtEnd = dtEnd.getEndOfDay();
        }
        int year = 0;
        int month = 0;
        int day = 0;
        int hour = 0;
        int minute = 0;
        int second = 0;
        if (cycleUnit.equalsIgnoreCase("d")) {
            day = 1;
        } else if (cycleUnit.equalsIgnoreCase("H")) {
            hour = 1;
        } else if (cycleUnit.equals("m")) {
            minute = 1;
        } else {
            logger.error("cycleUnit {} is error: ", (Object)cycleUnit);
            return ret;
        }
        while (dtStart.lteq(dtEnd)) {
            ret.add(dtStart.getMilliseconds(TimeZone.getDefault()));
            dtStart = dtStart.plus(Integer.valueOf(year), Integer.valueOf(month), Integer.valueOf(day), Integer.valueOf(hour), Integer.valueOf(minute), Integer.valueOf(second), Integer.valueOf(0), DateTime.DayOverflow.LastDay);
        }
        return ret;
    }

    public static String extractLongestTimeRegex(String src) throws IllegalArgumentException {
        Matcher m = pattern.matcher(src);
        String ret = "";
        while (m.find()) {
            String oneMatch = m.group(0);
            if (oneMatch.length() <= ret.length()) continue;
            ret = oneMatch;
        }
        return ret;
    }

    public static PathDateExpression extractLongestTimeRegexWithPrefixOrSuffix(String src) throws IllegalArgumentException {
        char c;
        if (src == null) {
            return null;
        }
        String longestPattern = DateUtils.extractLongestTimeRegex(src);
        if (longestPattern.isEmpty()) {
            return new PathDateExpression(longestPattern, NonRegexPatternPosition.NONE);
        }
        String regexSign = "\\^$*+?{(|[)]";
        String range = "+?*{";
        int beginIndex = src.indexOf(longestPattern);
        int endIndex = beginIndex + longestPattern.length();
        String prefix = src.substring(beginIndex - 1, beginIndex);
        NonRegexPatternPosition position = NonRegexPatternPosition.NONE;
        if (!regexSign.contains(prefix)) {
            longestPattern = prefix + longestPattern;
            position = NonRegexPatternPosition.PREFIX;
        }
        String suffix = "";
        if (src.length() > endIndex) {
            suffix = src.substring(endIndex, endIndex + 1);
        }
        boolean bFlag = false;
        if (Objects.equals(suffix, ".") && src.length() > endIndex + 1 && StringUtils.indexOf((String)range, (char)(c = src.charAt(endIndex + 1))) != -1) {
            bFlag = true;
        }
        if (!(Objects.equals(suffix, "") || regexSign.contains(suffix) || bFlag)) {
            longestPattern = longestPattern + suffix;
            position = position == NonRegexPatternPosition.PREFIX ? NonRegexPatternPosition.BOTH : NonRegexPatternPosition.SUFFIX;
        }
        if (Objects.equals(suffix, "")) {
            position = position == NonRegexPatternPosition.PREFIX ? NonRegexPatternPosition.ENDSUFFIX : NonRegexPatternPosition.END;
        }
        return position == NonRegexPatternPosition.NONE ? null : new PathDateExpression(longestPattern, position);
    }
}

