/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commands.remote;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.CompletionStage;
import org.infinispan.commands.remote.BaseRpcCommand;
import org.infinispan.commands.write.BackupAckCommand;
import org.infinispan.commons.marshall.MarshallUtil;
import org.infinispan.factories.ComponentRegistry;
import org.infinispan.remoting.inboundhandler.DeliverOrder;
import org.infinispan.remoting.rpc.RpcManager;
import org.infinispan.remoting.transport.Address;
import org.infinispan.scattered.BiasManager;
import org.infinispan.util.ByteString;
import org.infinispan.util.concurrent.CompletableFutures;

public class RevokeBiasCommand
extends BaseRpcCommand {
    public static final byte COMMAND_ID = 74;
    private Address ackTarget;
    private long id;
    private int topologyId;
    private Collection<Object> keys;

    public RevokeBiasCommand() {
        super(null);
    }

    public RevokeBiasCommand(ByteString cacheName) {
        super(cacheName);
    }

    public RevokeBiasCommand(ByteString cacheName, Address ackTarget, long id, int topologyId, Collection<Object> keys) {
        super(cacheName);
        this.ackTarget = ackTarget;
        this.id = id;
        this.topologyId = topologyId;
        this.keys = keys;
    }

    @Override
    public CompletionStage<?> invokeAsync(ComponentRegistry componentRegistry) throws Throwable {
        BiasManager biasManager = componentRegistry.getBiasManager().running();
        for (Object key : this.keys) {
            biasManager.revokeLocalBias(key);
        }
        if (this.ackTarget != null) {
            RpcManager rpcManager = componentRegistry.getRpcManager().running();
            rpcManager.sendTo(this.ackTarget, new BackupAckCommand(this.cacheName, this.id, this.topologyId), DeliverOrder.NONE);
        }
        return CompletableFutures.completedNull();
    }

    @Override
    public byte getCommandId() {
        return 74;
    }

    @Override
    public boolean isReturnValueExpected() {
        return false;
    }

    @Override
    public void writeTo(ObjectOutput output) throws IOException {
        output.writeObject(this.ackTarget);
        if (this.ackTarget != null) {
            output.writeLong(this.id);
        }
        output.writeInt(this.topologyId);
        MarshallUtil.marshallCollection(this.keys, (ObjectOutput)output);
    }

    @Override
    public void readFrom(ObjectInput input) throws IOException, ClassNotFoundException {
        this.ackTarget = (Address)input.readObject();
        if (this.ackTarget != null) {
            this.id = input.readLong();
        }
        this.topologyId = input.readInt();
        this.keys = MarshallUtil.unmarshallCollection((ObjectInput)input, ArrayList::new);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("RevokeBiasCommand{");
        sb.append("ackTarget=").append(this.ackTarget);
        sb.append(", id=").append(this.id);
        sb.append(", topologyId=").append(this.topologyId);
        sb.append(", keys=").append(this.keys);
        sb.append('}');
        return sb.toString();
    }
}

