/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.tubemq.client.common;

import java.util.Objects;
import org.apache.inlong.tubemq.client.common.StatsLevel;
import org.apache.inlong.tubemq.corebase.utils.MixedUtils;

public class StatsConfig {
    private static final long STATS_SELF_PRINT_DEFAULT_PERIOD_MS = 360000L;
    private static final long STATS_SELF_PRINT_MIN_PERIOD_MS = 60000L;
    private static final long STATS_SELF_PRINT_MAX_PERIOD_MS = 3600000L;
    private static final long STATS_AUTO_RESET_DEFAULT_PERIOD_MS = 1800000L;
    private static final long STATS_AUTO_RESET_MIN_PERIOD_MS = 30000L;
    private static final long STATS_AUTO_RESET_MAX_PERIOD_MS = 86400000L;
    private StatsLevel statsLevel = StatsLevel.MEDIUM;
    private boolean enableSelfPrint = true;
    private long selfPrintPeriodMs = 360000L;
    private long forcedResetPeriodMs = 1800000L;

    public void updateStatsConfig(StatsConfig that) {
        if (that == null) {
            return;
        }
        this.updateStatsConfig(that.statsLevel, that.enableSelfPrint, that.selfPrintPeriodMs, that.forcedResetPeriodMs);
    }

    public void updateStatsConfig(StatsLevel statsLevel, boolean enableSelfPrint, long selfPrintPeriodMs, long forcedResetPeriodMs) {
        this.updateStatsControl(statsLevel, enableSelfPrint);
        this.setStatsPeriodInfo(selfPrintPeriodMs, forcedResetPeriodMs);
    }

    public void updateStatsControl(StatsLevel statsLevel, boolean enableSelfPrint) {
        this.statsLevel = statsLevel;
        this.enableSelfPrint = enableSelfPrint;
    }

    public void setStatsPeriodInfo(long selfPrintPeriodMs, long forcedResetPeriodMs) {
        this.selfPrintPeriodMs = MixedUtils.mid((long)selfPrintPeriodMs, (long)60000L, (long)3600000L);
        this.forcedResetPeriodMs = MixedUtils.mid((long)forcedResetPeriodMs, (long)30000L, (long)86400000L);
    }

    public void setStatsLevel(StatsLevel statsLevel) {
        this.statsLevel = statsLevel;
    }

    public StatsLevel getStatsLevel() {
        return this.statsLevel;
    }

    public boolean isEnableSelfPrint() {
        return this.enableSelfPrint;
    }

    public long getSelfPrintPeriodMs() {
        return this.selfPrintPeriodMs;
    }

    public long getForcedResetPeriodMs() {
        return this.forcedResetPeriodMs;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof StatsConfig)) {
            return false;
        }
        StatsConfig that = (StatsConfig)o;
        return this.enableSelfPrint == that.enableSelfPrint && this.selfPrintPeriodMs == that.selfPrintPeriodMs && this.forcedResetPeriodMs == that.forcedResetPeriodMs && this.statsLevel == that.statsLevel;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.statsLevel, this.enableSelfPrint, this.selfPrintPeriodMs, this.forcedResetPeriodMs});
    }

    public String toString() {
        return new StringBuilder(512).append("\"StatsConfig\":{\"statsLevel\":\"").append(this.statsLevel.getName()).append("\",\"enableSelfPrint\":").append(this.enableSelfPrint).append(",\"selfPrintPeriodMs\":").append(this.selfPrintPeriodMs).append(",\"forcedResetPeriodMs\":").append(this.forcedResetPeriodMs).append("}").toString();
    }
}

