/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.client.api;

import org.apache.pulsar.common.classification.InterfaceAudience;
import org.apache.pulsar.common.classification.InterfaceStability;

@InterfaceAudience.Public
@InterfaceStability.Stable
public class DeadLetterPolicy {
    private int maxRedeliverCount;
    private String retryLetterTopic;
    private String deadLetterTopic;

    DeadLetterPolicy(int maxRedeliverCount, String retryLetterTopic, String deadLetterTopic) {
        this.maxRedeliverCount = maxRedeliverCount;
        this.retryLetterTopic = retryLetterTopic;
        this.deadLetterTopic = deadLetterTopic;
    }

    public static DeadLetterPolicyBuilder builder() {
        return new DeadLetterPolicyBuilder();
    }

    public int getMaxRedeliverCount() {
        return this.maxRedeliverCount;
    }

    public String getRetryLetterTopic() {
        return this.retryLetterTopic;
    }

    public String getDeadLetterTopic() {
        return this.deadLetterTopic;
    }

    public void setMaxRedeliverCount(int maxRedeliverCount) {
        this.maxRedeliverCount = maxRedeliverCount;
    }

    public void setRetryLetterTopic(String retryLetterTopic) {
        this.retryLetterTopic = retryLetterTopic;
    }

    public void setDeadLetterTopic(String deadLetterTopic) {
        this.deadLetterTopic = deadLetterTopic;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DeadLetterPolicy)) {
            return false;
        }
        DeadLetterPolicy other = (DeadLetterPolicy)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getMaxRedeliverCount() != other.getMaxRedeliverCount()) {
            return false;
        }
        String this$retryLetterTopic = this.getRetryLetterTopic();
        String other$retryLetterTopic = other.getRetryLetterTopic();
        if (this$retryLetterTopic == null ? other$retryLetterTopic != null : !this$retryLetterTopic.equals(other$retryLetterTopic)) {
            return false;
        }
        String this$deadLetterTopic = this.getDeadLetterTopic();
        String other$deadLetterTopic = other.getDeadLetterTopic();
        return !(this$deadLetterTopic == null ? other$deadLetterTopic != null : !this$deadLetterTopic.equals(other$deadLetterTopic));
    }

    protected boolean canEqual(Object other) {
        return other instanceof DeadLetterPolicy;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getMaxRedeliverCount();
        String $retryLetterTopic = this.getRetryLetterTopic();
        result = result * 59 + ($retryLetterTopic == null ? 43 : $retryLetterTopic.hashCode());
        String $deadLetterTopic = this.getDeadLetterTopic();
        result = result * 59 + ($deadLetterTopic == null ? 43 : $deadLetterTopic.hashCode());
        return result;
    }

    public String toString() {
        return "DeadLetterPolicy(maxRedeliverCount=" + this.getMaxRedeliverCount() + ", retryLetterTopic=" + this.getRetryLetterTopic() + ", deadLetterTopic=" + this.getDeadLetterTopic() + ")";
    }

    public static class DeadLetterPolicyBuilder {
        private int maxRedeliverCount;
        private String retryLetterTopic;
        private String deadLetterTopic;

        DeadLetterPolicyBuilder() {
        }

        public DeadLetterPolicyBuilder maxRedeliverCount(int maxRedeliverCount) {
            this.maxRedeliverCount = maxRedeliverCount;
            return this;
        }

        public DeadLetterPolicyBuilder retryLetterTopic(String retryLetterTopic) {
            this.retryLetterTopic = retryLetterTopic;
            return this;
        }

        public DeadLetterPolicyBuilder deadLetterTopic(String deadLetterTopic) {
            this.deadLetterTopic = deadLetterTopic;
            return this;
        }

        public DeadLetterPolicy build() {
            return new DeadLetterPolicy(this.maxRedeliverCount, this.retryLetterTopic, this.deadLetterTopic);
        }

        public String toString() {
            return "DeadLetterPolicy.DeadLetterPolicyBuilder(maxRedeliverCount=" + this.maxRedeliverCount + ", retryLetterTopic=" + this.retryLetterTopic + ", deadLetterTopic=" + this.deadLetterTopic + ")";
        }
    }
}

