/*
 * Decompiled with CFR 0.152.
 */
package akka.util;

import scala.Function0;
import scala.Predef$;
import scala.Serializable;
import scala.math.package$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u000192a!\u0001\u0002\u0002\u0002\u00111!a\u0003+pW\u0016t')^2lKRT!a\u0001\u0003\u0002\tU$\u0018\u000e\u001c\u0006\u0002\u000b\u0005!\u0011m[6b'\t\u0001q\u0001\u0005\u0002\t\u00175\t\u0011BC\u0001\u000b\u0003\u0015\u00198-\u00197b\u0013\ta\u0011B\u0001\u0004B]f\u0014VM\u001a\u0005\t\u001d\u0001\u0011\t\u0011)A\u0005!\u0005A1-\u00199bG&$\u0018p\u0001\u0001\u0011\u0005!\t\u0012B\u0001\n\n\u0005\u0011auN\\4\t\u0011Q\u0001!\u0011!Q\u0001\nA\t!C\\1o_N\u0014U\r^<fK:$vn[3og\")a\u0003\u0001C\u0001/\u00051A(\u001b8jiz\"2\u0001\u0007\u000e\u001c!\tI\u0002!D\u0001\u0003\u0011\u0015qQ\u00031\u0001\u0011\u0011\u0015!R\u00031\u0001\u0011\u0011%i\u0002\u00011A\u0001B\u0003&\u0001#A\bbm\u0006LG.\u00192mKR{7.\u001a8t\u0011%y\u0002\u00011A\u0001B\u0003&\u0001#\u0001\u0006mCN$X\u000b\u001d3bi\u0016DQ!\t\u0001\u0005\u0002\t\nA!\u001b8jiR\t1\u0005\u0005\u0002\tI%\u0011Q%\u0003\u0002\u0005+:LG\u000fC\u0003(\u0001\u0019\u0005\u0001&A\u0006dkJ\u0014XM\u001c;US6,W#\u0001\t\t\u000b)\u0002A\u0011A\u0016\u0002\u000b=4g-\u001a:\u0015\u0005Aa\u0003\"B\u0017*\u0001\u0004\u0001\u0012\u0001B2pgR\u0004")
public abstract class TokenBucket {
    private final long capacity;
    private final long nanosBetweenTokens;
    private long availableTokens;
    private long lastUpdate;

    public void init() {
        this.availableTokens = this.capacity;
        this.lastUpdate = this.currentTime();
    }

    public abstract long currentTime();

    public long offer(long cost) {
        long l;
        long l2;
        if (cost < 0L) {
            throw new IllegalArgumentException("Cost must be non-negative");
        }
        long now = this.currentTime();
        long timeElapsed = now - this.lastUpdate;
        if (timeElapsed >= this.nanosBetweenTokens) {
            if (timeElapsed < this.nanosBetweenTokens * 2L) {
                this.lastUpdate += this.nanosBetweenTokens;
                l2 = 1;
            } else {
                long tokensArrived = timeElapsed / this.nanosBetweenTokens;
                this.lastUpdate += tokensArrived * this.nanosBetweenTokens;
                l2 = tokensArrived;
            }
        } else {
            l2 = 0L;
        }
        long tokensArrived = l2;
        this.availableTokens = package$.MODULE$.min(this.availableTokens + tokensArrived, this.capacity);
        if (cost <= this.availableTokens) {
            this.availableTokens -= cost;
            l = 0L;
        } else {
            long remainingCost = cost - this.availableTokens;
            long timeSinceTokenArrival = now - this.lastUpdate;
            long delay2 = remainingCost * this.nanosBetweenTokens - timeSinceTokenArrival;
            this.availableTokens = 0L;
            this.lastUpdate = now + delay2;
            l = delay2;
        }
        return l;
    }

    public TokenBucket(long capacity, long nanosBetweenTokens) {
        this.capacity = capacity;
        this.nanosBetweenTokens = nanosBetweenTokens;
        Predef$.MODULE$.require(capacity >= 0L, (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Capacity must be non-negative.";
            }
        });
        Predef$.MODULE$.require(nanosBetweenTokens > 0L, (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Time between tokens must be larger than zero nanoseconds.";
            }
        });
    }
}

