/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fury.collection;

import org.apache.fury.collection.FuryObjectMap;

public final class IdentityMap<K, V>
extends FuryObjectMap<K, V> {
    public IdentityMap() {
    }

    public IdentityMap(int initialCapacity) {
        super(initialCapacity);
    }

    public IdentityMap(int initialCapacity, float loadFactor) {
        super(initialCapacity, loadFactor);
    }

    @Override
    protected int place(K item) {
        return System.identityHashCode(item) & this.mask;
    }

    @Override
    public <T extends K> V get(T key) {
        int mask = this.mask;
        Object[] keyTable = this.keyTable;
        int i = this.place(key);
        Object other;
        while ((other = keyTable[i]) != null) {
            if (other == key) {
                return (V)this.valueTable[i];
            }
            i = i + 1 & mask;
        }
        return null;
    }

    @Override
    public V get(K key, V defaultValue) {
        int mask = this.mask;
        Object[] keyTable = this.keyTable;
        int i = this.place(key);
        Object other;
        while ((other = keyTable[i]) != null) {
            if (other == key) {
                return (V)this.valueTable[i];
            }
            i = i + 1 & mask;
        }
        return defaultValue;
    }

    @Override
    int locateKey(K key) {
        if (key == null) {
            throw new IllegalArgumentException("key cannot be null.");
        }
        Object[] keyTable = this.keyTable;
        int i = this.place(key);
        Object other;
        while ((other = keyTable[i]) != null) {
            if (other == key) {
                return i;
            }
            i = i + 1 & this.mask;
        }
        return -(i + 1);
    }

    @Override
    public int hashCode() {
        int h = this.size;
        Object[] keyTable = this.keyTable;
        Object[] valueTable = this.valueTable;
        int n = keyTable.length;
        for (int i = 0; i < n; ++i) {
            Object key = keyTable[i];
            if (key == null) continue;
            h += System.identityHashCode(key);
            Object value = valueTable[i];
            if (value == null) continue;
            h += value.hashCode();
        }
        return h;
    }
}

