/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seata.common.util;

import org.apache.seata.common.lock.ResourceLock;
import org.apache.seata.common.util.IdWorker;

public class UUIDGenerator {
    private static volatile IdWorker idWorker;
    private static final ResourceLock RESOURCE_LOCK;

    public static long generateUUID() {
        if (idWorker == null) {
            try (ResourceLock ignored = RESOURCE_LOCK.obtain();){
                if (idWorker == null) {
                    UUIDGenerator.init(null);
                }
            }
        }
        return idWorker.nextId();
    }

    public static void init(Long serverNode) {
        idWorker = new IdWorker(serverNode);
    }

    static {
        RESOURCE_LOCK = new ResourceLock();
    }
}

