/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.oidc.common.runtime;

import io.quarkus.oidc.common.runtime.config.OidcCommonConfig;
import java.nio.file.Path;
import java.time.Duration;
import java.util.Optional;
import java.util.OptionalInt;

public abstract class OidcCommonConfig
implements io.quarkus.oidc.common.runtime.config.OidcCommonConfig {
    @Deprecated(since="3.18", forRemoval=true)
    public Optional<String> authServerUrl = Optional.empty();
    @Deprecated(since="3.18", forRemoval=true)
    public Optional<Boolean> discoveryEnabled = Optional.empty();
    @Deprecated(since="3.18", forRemoval=true)
    public Optional<String> registrationPath = Optional.empty();
    @Deprecated(since="3.18", forRemoval=true)
    public Optional<Duration> connectionDelay = Optional.empty();
    @Deprecated(since="3.18", forRemoval=true)
    public int connectionRetryCount = 3;
    @Deprecated(since="3.18", forRemoval=true)
    public Duration connectionTimeout = Duration.ofSeconds(10L);
    @Deprecated(since="3.18", forRemoval=true)
    public boolean useBlockingDnsLookup;
    @Deprecated(since="3.18", forRemoval=true)
    public OptionalInt maxPoolSize = OptionalInt.empty();
    @Deprecated(since="3.18", forRemoval=true)
    public boolean followRedirects = true;
    @Deprecated(since="3.18", forRemoval=true)
    public Proxy proxy = new Proxy();
    @Deprecated(since="3.18", forRemoval=true)
    public Tls tls = new Tls();

    public OidcCommonConfig() {
    }

    protected OidcCommonConfig(io.quarkus.oidc.common.runtime.config.OidcCommonConfig mapping) {
        this.authServerUrl = mapping.authServerUrl();
        this.discoveryEnabled = mapping.discoveryEnabled();
        this.registrationPath = mapping.registrationPath();
        this.connectionDelay = mapping.connectionDelay();
        this.connectionRetryCount = mapping.connectionRetryCount();
        this.connectionTimeout = mapping.connectionTimeout();
        this.useBlockingDnsLookup = mapping.useBlockingDnsLookup();
        this.maxPoolSize = mapping.maxPoolSize();
        this.followRedirects = mapping.followRedirects();
        this.proxy.addConfigMappingValues(mapping.proxy());
        this.tls.addConfigMappingValues(mapping.tls());
    }

    @Override
    public Optional<String> authServerUrl() {
        return this.authServerUrl;
    }

    @Override
    public Optional<Boolean> discoveryEnabled() {
        return this.discoveryEnabled;
    }

    @Override
    public Optional<String> registrationPath() {
        return this.registrationPath;
    }

    @Override
    public Optional<Duration> connectionDelay() {
        return this.connectionDelay;
    }

    @Override
    public int connectionRetryCount() {
        return this.connectionRetryCount;
    }

    @Override
    public Duration connectionTimeout() {
        return this.connectionTimeout;
    }

    @Override
    public boolean useBlockingDnsLookup() {
        return this.useBlockingDnsLookup;
    }

    @Override
    public OptionalInt maxPoolSize() {
        return this.maxPoolSize;
    }

    @Override
    public boolean followRedirects() {
        return this.followRedirects;
    }

    @Override
    public OidcCommonConfig.Proxy proxy() {
        return this.proxy;
    }

    @Override
    public OidcCommonConfig.Tls tls() {
        return this.tls;
    }

    @Deprecated(since="3.18", forRemoval=true)
    public Optional<Duration> getConnectionDelay() {
        return this.connectionDelay;
    }

    @Deprecated(since="3.18", forRemoval=true)
    public void setConnectionDelay(Duration connectionDelay) {
        this.connectionDelay = Optional.of(connectionDelay);
    }

    @Deprecated(since="3.18", forRemoval=true)
    public Optional<String> getAuthServerUrl() {
        return this.authServerUrl;
    }

    @Deprecated(since="3.18", forRemoval=true)
    public void setAuthServerUrl(String authServerUrl) {
        this.authServerUrl = Optional.of(authServerUrl);
    }

    @Deprecated(since="3.18", forRemoval=true)
    public Optional<String> getRegistrationPath() {
        return this.registrationPath;
    }

    @Deprecated(since="3.18", forRemoval=true)
    public void setRegistrationPath(String registrationPath) {
        this.registrationPath = Optional.of(registrationPath);
    }

    @Deprecated(since="3.18", forRemoval=true)
    public Optional<Boolean> isDiscoveryEnabled() {
        return this.discoveryEnabled;
    }

    @Deprecated(since="3.18", forRemoval=true)
    public void setDiscoveryEnabled(boolean enabled) {
        this.discoveryEnabled = Optional.of(enabled);
    }

    @Deprecated(since="3.18", forRemoval=true)
    public Proxy getProxy() {
        return this.proxy;
    }

    @Deprecated(since="3.18", forRemoval=true)
    public void setProxy(Proxy proxy) {
        this.proxy = proxy;
    }

    @Deprecated(since="3.18", forRemoval=true)
    public Duration getConnectionTimeout() {
        return this.connectionTimeout;
    }

    @Deprecated(since="3.18", forRemoval=true)
    public void setConnectionTimeout(Duration connectionTimeout) {
        this.connectionTimeout = connectionTimeout;
    }

    @Deprecated(since="3.18", forRemoval=true)
    public OptionalInt getMaxPoolSize() {
        return this.maxPoolSize;
    }

    @Deprecated(since="3.18", forRemoval=true)
    public void setMaxPoolSize(int maxPoolSize) {
        this.maxPoolSize = OptionalInt.of(maxPoolSize);
    }

    @Deprecated(since="3.18", forRemoval=true)
    public Optional<Boolean> getDiscoveryEnabled() {
        return this.discoveryEnabled;
    }

    @Deprecated(since="3.18", forRemoval=true)
    public void setDiscoveryEnabled(Boolean discoveryEnabled) {
        this.discoveryEnabled = Optional.of(discoveryEnabled);
    }

    @Deprecated(since="3.18", forRemoval=true)
    public static class Proxy
    implements OidcCommonConfig.Proxy {
        public Optional<String> host = Optional.empty();
        public int port = 80;
        public Optional<String> username = Optional.empty();
        public Optional<String> password = Optional.empty();

        private void addConfigMappingValues(OidcCommonConfig.Proxy mapping) {
            this.host = mapping.host();
            this.port = mapping.port();
            this.username = mapping.username();
            this.password = mapping.password();
        }

        @Override
        public Optional<String> host() {
            return this.host;
        }

        @Override
        public int port() {
            return this.port;
        }

        @Override
        public Optional<String> username() {
            return this.username;
        }

        @Override
        public Optional<String> password() {
            return this.password;
        }
    }

    @Deprecated(since="3.18", forRemoval=true)
    public static class Tls
    implements OidcCommonConfig.Tls {
        Optional<String> tlsConfigurationName = Optional.empty();
        public Optional<Verification> verification = Optional.empty();
        public Optional<Path> keyStoreFile = Optional.empty();
        public Optional<String> keyStoreFileType = Optional.empty();
        public Optional<String> keyStoreProvider;
        public Optional<String> keyStorePassword;
        public Optional<String> keyStoreKeyAlias = Optional.empty();
        public Optional<String> keyStoreKeyPassword = Optional.empty();
        public Optional<Path> trustStoreFile = Optional.empty();
        public Optional<String> trustStorePassword = Optional.empty();
        public Optional<String> trustStoreCertAlias = Optional.empty();
        public Optional<String> trustStoreFileType = Optional.empty();
        public Optional<String> trustStoreProvider;

        private void addConfigMappingValues(OidcCommonConfig.Tls mapping) {
            this.tlsConfigurationName = mapping.tlsConfigurationName();
            this.verification = mapping.verification().map(Enum::toString).map(Verification::valueOf);
            this.keyStoreFile = mapping.keyStoreFile();
            this.keyStoreFileType = mapping.keyStoreFileType();
            this.keyStoreProvider = mapping.keyStoreProvider();
            this.keyStorePassword = mapping.keyStorePassword();
            this.keyStoreKeyAlias = mapping.keyStoreKeyAlias();
            this.keyStoreKeyPassword = mapping.keyStoreKeyPassword();
            this.trustStoreFile = mapping.trustStoreFile();
            this.trustStorePassword = mapping.trustStorePassword();
            this.trustStoreCertAlias = mapping.trustStoreCertAlias();
            this.trustStoreFileType = mapping.trustStoreFileType();
            this.trustStoreProvider = mapping.trustStoreProvider();
        }

        @Override
        public Optional<String> tlsConfigurationName() {
            return this.tlsConfigurationName;
        }

        @Override
        public Optional<OidcCommonConfig.Tls.Verification> verification() {
            return this.verification.map(Enum::toString).map(OidcCommonConfig.Tls.Verification::valueOf);
        }

        @Override
        public Optional<Path> keyStoreFile() {
            return this.keyStoreFile;
        }

        @Override
        public Optional<String> keyStoreFileType() {
            return this.keyStoreFileType;
        }

        @Override
        public Optional<String> keyStoreProvider() {
            return this.keyStoreProvider;
        }

        @Override
        public Optional<String> keyStorePassword() {
            return this.keyStorePassword;
        }

        @Override
        public Optional<String> keyStoreKeyAlias() {
            return this.keyStoreKeyAlias;
        }

        @Override
        public Optional<String> keyStoreKeyPassword() {
            return this.keyStoreKeyPassword;
        }

        @Override
        public Optional<Path> trustStoreFile() {
            return this.trustStoreFile;
        }

        @Override
        public Optional<String> trustStorePassword() {
            return this.trustStorePassword;
        }

        @Override
        public Optional<String> trustStoreCertAlias() {
            return this.trustStoreCertAlias;
        }

        @Override
        public Optional<String> trustStoreFileType() {
            return this.trustStoreFileType;
        }

        @Override
        public Optional<String> trustStoreProvider() {
            return this.trustStoreProvider;
        }

        public Optional<Verification> getVerification() {
            return this.verification;
        }

        public void setVerification(Verification verification) {
            this.verification = Optional.of(verification);
        }

        public Optional<Path> getTrustStoreFile() {
            return this.trustStoreFile;
        }

        public void setTrustStoreFile(Path trustStoreFile) {
            this.trustStoreFile = Optional.of(trustStoreFile);
        }

        public Optional<String> getTrustStorePassword() {
            return this.trustStorePassword;
        }

        public void setTrustStorePassword(String trustStorePassword) {
            this.trustStorePassword = Optional.of(trustStorePassword);
        }

        public Optional<String> getTrustStoreCertAlias() {
            return this.trustStoreCertAlias;
        }

        public void setTrustStoreCertAlias(String trustStoreCertAlias) {
            this.trustStoreCertAlias = Optional.of(trustStoreCertAlias);
        }

        public Optional<String> getKeyStoreProvider() {
            return this.keyStoreProvider;
        }

        public void setKeyStoreProvider(String keyStoreProvider) {
            this.keyStoreProvider = Optional.of(keyStoreProvider);
        }

        public Optional<String> getTrustStoreProvider() {
            return this.trustStoreProvider;
        }

        public void setTrustStoreProvider(String trustStoreProvider) {
            this.trustStoreProvider = Optional.of(trustStoreProvider);
        }

        public static enum Verification {
            REQUIRED,
            CERTIFICATE_VALIDATION,
            NONE;

        }
    }
}

