/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.exporter.internal.otlp.traces;

import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.exporter.internal.marshal.MarshalerContext;
import io.opentelemetry.exporter.internal.marshal.MarshalerUtil;
import io.opentelemetry.exporter.internal.marshal.ProtoEnumInfo;
import io.opentelemetry.exporter.internal.marshal.ProtoFieldInfo;
import io.opentelemetry.exporter.internal.marshal.Serializer;
import io.opentelemetry.exporter.internal.marshal.StatelessMarshaler;
import io.opentelemetry.exporter.internal.marshal.StatelessMarshaler2;
import io.opentelemetry.exporter.internal.marshal.StatelessMarshalerUtil;
import io.opentelemetry.exporter.internal.otlp.AttributeKeyValueStatelessMarshaler;
import io.opentelemetry.exporter.internal.otlp.traces.SpanEventStatelessMarshaler;
import io.opentelemetry.exporter.internal.otlp.traces.SpanFlags;
import io.opentelemetry.exporter.internal.otlp.traces.SpanLinkStatelessMarshaler;
import io.opentelemetry.exporter.internal.otlp.traces.SpanMarshaler;
import io.opentelemetry.exporter.internal.otlp.traces.SpanStatusStatelessMarshaler;
import io.opentelemetry.proto.trace.v1.internal.Span;
import io.opentelemetry.sdk.trace.data.SpanData;
import java.io.IOException;
import java.util.List;

final class SpanStatelessMarshaler
implements StatelessMarshaler<SpanData> {
    static final SpanStatelessMarshaler INSTANCE = new SpanStatelessMarshaler();

    private SpanStatelessMarshaler() {
    }

    public void writeTo(Serializer output, SpanData span, MarshalerContext context) throws IOException {
        output.serializeTraceId(Span.TRACE_ID, span.getTraceId(), context);
        output.serializeSpanId(Span.SPAN_ID, span.getSpanId(), context);
        byte[] traceStateUtf8 = (byte[])context.getData(byte[].class);
        output.serializeString(Span.TRACE_STATE, traceStateUtf8);
        String parentSpanId = span.getParentSpanContext().isValid() ? span.getParentSpanContext().getSpanId() : null;
        output.serializeSpanId(Span.PARENT_SPAN_ID, parentSpanId, context);
        output.serializeStringWithContext(Span.NAME, span.getName(), context);
        output.serializeEnum(Span.KIND, SpanMarshaler.toProtoSpanKind(span.getKind()));
        output.serializeFixed64(Span.START_TIME_UNIX_NANO, span.getStartEpochNanos());
        output.serializeFixed64(Span.END_TIME_UNIX_NANO, span.getEndEpochNanos());
        output.serializeRepeatedMessageWithContext(Span.ATTRIBUTES, span.getAttributes(), (StatelessMarshaler2)AttributeKeyValueStatelessMarshaler.INSTANCE, context);
        int droppedAttributesCount = span.getTotalAttributeCount() - span.getAttributes().size();
        output.serializeUInt32(Span.DROPPED_ATTRIBUTES_COUNT, droppedAttributesCount);
        output.serializeRepeatedMessageWithContext(Span.EVENTS, span.getEvents(), (StatelessMarshaler)SpanEventStatelessMarshaler.INSTANCE, context);
        int droppedEventsCount = span.getTotalRecordedEvents() - span.getEvents().size();
        output.serializeUInt32(Span.DROPPED_EVENTS_COUNT, droppedEventsCount);
        output.serializeRepeatedMessageWithContext(Span.LINKS, span.getLinks(), (StatelessMarshaler)SpanLinkStatelessMarshaler.INSTANCE, context);
        int droppedLinksCount = span.getTotalRecordedLinks() - span.getLinks().size();
        output.serializeUInt32(Span.DROPPED_LINKS_COUNT, droppedLinksCount);
        output.serializeMessageWithContext(Span.STATUS, (Object)span.getStatus(), (StatelessMarshaler)SpanStatusStatelessMarshaler.INSTANCE, context);
        output.serializeFixed32(Span.FLAGS, SpanFlags.withParentIsRemoteFlags(span.getSpanContext().getTraceFlags(), span.getParentSpanContext().isRemote()));
    }

    public int getBinarySerializedSize(SpanData span, MarshalerContext context) {
        int size = 0;
        size += MarshalerUtil.sizeTraceId((ProtoFieldInfo)Span.TRACE_ID, (String)span.getTraceId());
        size += MarshalerUtil.sizeSpanId((ProtoFieldInfo)Span.SPAN_ID, (String)span.getSpanId());
        byte[] traceStateUtf8 = SpanMarshaler.encodeSpanTraceState(span);
        context.addData((Object)traceStateUtf8);
        size += MarshalerUtil.sizeBytes((ProtoFieldInfo)Span.TRACE_STATE, (byte[])traceStateUtf8);
        String parentSpanId = span.getParentSpanContext().isValid() ? span.getParentSpanContext().getSpanId() : null;
        size += MarshalerUtil.sizeSpanId((ProtoFieldInfo)Span.PARENT_SPAN_ID, (String)parentSpanId);
        size += StatelessMarshalerUtil.sizeStringWithContext((ProtoFieldInfo)Span.NAME, (String)span.getName(), (MarshalerContext)context);
        size += MarshalerUtil.sizeEnum((ProtoFieldInfo)Span.KIND, (ProtoEnumInfo)SpanMarshaler.toProtoSpanKind(span.getKind()));
        size += MarshalerUtil.sizeFixed64((ProtoFieldInfo)Span.START_TIME_UNIX_NANO, (long)span.getStartEpochNanos());
        size += MarshalerUtil.sizeFixed64((ProtoFieldInfo)Span.END_TIME_UNIX_NANO, (long)span.getEndEpochNanos());
        size += StatelessMarshalerUtil.sizeRepeatedMessageWithContext((ProtoFieldInfo)Span.ATTRIBUTES, (Attributes)span.getAttributes(), (StatelessMarshaler2)AttributeKeyValueStatelessMarshaler.INSTANCE, (MarshalerContext)context);
        int droppedAttributesCount = span.getTotalAttributeCount() - span.getAttributes().size();
        size += MarshalerUtil.sizeUInt32((ProtoFieldInfo)Span.DROPPED_ATTRIBUTES_COUNT, (int)droppedAttributesCount);
        size += StatelessMarshalerUtil.sizeRepeatedMessageWithContext((ProtoFieldInfo)Span.EVENTS, (List)span.getEvents(), (StatelessMarshaler)SpanEventStatelessMarshaler.INSTANCE, (MarshalerContext)context);
        int droppedEventsCount = span.getTotalRecordedEvents() - span.getEvents().size();
        size += MarshalerUtil.sizeUInt32((ProtoFieldInfo)Span.DROPPED_EVENTS_COUNT, (int)droppedEventsCount);
        size += StatelessMarshalerUtil.sizeRepeatedMessageWithContext((ProtoFieldInfo)Span.LINKS, (List)span.getLinks(), (StatelessMarshaler)SpanLinkStatelessMarshaler.INSTANCE, (MarshalerContext)context);
        int droppedLinksCount = span.getTotalRecordedLinks() - span.getLinks().size();
        size += MarshalerUtil.sizeUInt32((ProtoFieldInfo)Span.DROPPED_LINKS_COUNT, (int)droppedLinksCount);
        size += StatelessMarshalerUtil.sizeMessageWithContext((ProtoFieldInfo)Span.STATUS, (Object)span.getStatus(), (StatelessMarshaler)SpanStatusStatelessMarshaler.INSTANCE, (MarshalerContext)context);
        return size += MarshalerUtil.sizeFixed32((ProtoFieldInfo)Span.FLAGS, (int)SpanFlags.withParentIsRemoteFlags(span.getSpanContext().getTraceFlags(), span.getParentSpanContext().isRemote()));
    }
}

