/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.data;

import java.nio.ByteBuffer;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.Types;
import org.apache.iceberg.util.ByteBuffers;
import org.apache.iceberg.util.DateTimeUtil;

public class GenericDataUtil {
    private GenericDataUtil() {
    }

    public static Object internalToGeneric(Type type, Object value) {
        if (null == value) {
            return null;
        }
        switch (type.typeId()) {
            case DATE: {
                return DateTimeUtil.dateFromDays((int)((Integer)value));
            }
            case TIME: {
                return DateTimeUtil.timeFromMicros((long)((Long)value));
            }
            case TIMESTAMP: {
                if (((Types.TimestampType)type).shouldAdjustToUTC()) {
                    return DateTimeUtil.timestamptzFromMicros((long)((Long)value));
                }
                return DateTimeUtil.timestampFromMicros((long)((Long)value));
            }
            case FIXED: {
                return ByteBuffers.toByteArray((ByteBuffer)((ByteBuffer)value));
            }
        }
        return value;
    }
}

