/*
 * Decompiled with CFR 0.152.
 */
package org.apache.polaris.core.secrets;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class UserSecretReference {
    @JsonProperty(value="urn")
    private final String urn;
    @JsonProperty(value="referencePayload")
    private final Map<String, String> referencePayload;

    public UserSecretReference(@JsonProperty(value="urn", required=true) @Nonnull String urn, @JsonProperty(value="referencePayload") @Nullable Map<String, String> referencePayload) {
        Preconditions.checkArgument((urn.startsWith("urn:polaris-secret:") && urn.split(":").length >= 4 ? 1 : 0) != 0, (String)"Invalid secret URN '%s'; must be of the form 'urn:polaris-secret:<secret-manager-type>:<type-specific-identifier>'", (Object)urn);
        this.urn = urn;
        this.referencePayload = Objects.requireNonNullElse(referencePayload, new HashMap());
    }

    @JsonIgnore
    public String getUserSecretManagerTypeFromUrn() {
        return this.urn.split(":")[2];
    }

    @Nonnull
    public String getUrn() {
        return this.urn;
    }

    @Nonnull
    public Map<String, String> getReferencePayload() {
        return this.referencePayload;
    }

    public int hashCode() {
        return Objects.hash(this.getUrn(), this.getReferencePayload());
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof UserSecretReference)) {
            return false;
        }
        UserSecretReference that = (UserSecretReference)obj;
        return Objects.equals(this.getUrn(), that.getUrn()) && Objects.equals(this.getReferencePayload(), that.getReferencePayload());
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("urn", (Object)this.getUrn()).add("referencePayload", (Object)String.format("<num entries: %d>", this.getReferencePayload().size())).toString();
    }
}

