/*
 * Decompiled with CFR 0.152.
 */
package org.apache.livy.rsc.driver;

import java.lang.reflect.Method;
import java.util.concurrent.TimeUnit;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkContext;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.sql.SQLContext;
import org.apache.spark.sql.hive.HiveContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SparkEntries {
    private static final Logger LOG = LoggerFactory.getLogger(SparkEntries.class);
    private volatile JavaSparkContext sc;
    private final SparkConf conf;
    private volatile SQLContext sqlctx;
    private volatile HiveContext hivectx;
    private volatile Object sparksession;

    public SparkEntries(SparkConf conf) {
        this.conf = conf;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JavaSparkContext sc() {
        if (this.sc == null) {
            SparkEntries sparkEntries = this;
            synchronized (sparkEntries) {
                if (this.sc == null) {
                    long t1 = System.nanoTime();
                    LOG.info("Starting Spark context...");
                    SparkContext scalaSc = SparkContext.getOrCreate((SparkConf)this.conf);
                    this.sc = new JavaSparkContext(scalaSc);
                    LOG.info("Spark context finished initialization in {}ms", (Object)TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - t1));
                }
            }
        }
        return this.sc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object sparkSession() throws Exception {
        if (this.sparksession == null) {
            SparkEntries sparkEntries = this;
            synchronized (sparkEntries) {
                if (this.sparksession == null) {
                    try {
                        Class<?> clz = Class.forName("org.apache.spark.sql.SparkSession$");
                        Object spark = clz.getField("MODULE$").get(null);
                        Method m = clz.getMethod("builder", new Class[0]);
                        Object builder = m.invoke(spark, new Object[0]);
                        builder.getClass().getMethod("sparkContext", SparkContext.class).invoke(builder, this.sc().sc());
                        SparkConf conf = this.sc().getConf();
                        if (conf.get("spark.sql.catalogImplementation", "in-memory").toLowerCase().equals("hive")) {
                            if (((Boolean)clz.getMethod("hiveClassesArePresent", new Class[0]).invoke(spark, new Object[0])).booleanValue()) {
                                ClassLoader loader;
                                ClassLoader classLoader = loader = Thread.currentThread().getContextClassLoader() != null ? Thread.currentThread().getContextClassLoader() : this.getClass().getClassLoader();
                                if (loader.getResource("hive-site.xml") == null) {
                                    LOG.warn("livy.repl.enable-hive-context is true but no hive-site.xml found on classpath");
                                }
                                builder.getClass().getMethod("enableHiveSupport", new Class[0]).invoke(builder, new Object[0]);
                                this.sparksession = builder.getClass().getMethod("getOrCreate", new Class[0]).invoke(builder, new Object[0]);
                                LOG.info("Created Spark session (with Hive support).");
                            } else {
                                builder.getClass().getMethod("config", String.class, String.class).invoke(builder, "spark.sql.catalogImplementation", "in-memory");
                                this.sparksession = builder.getClass().getMethod("getOrCreate", new Class[0]).invoke(builder, new Object[0]);
                                LOG.info("Created Spark session.");
                            }
                        } else {
                            this.sparksession = builder.getClass().getMethod("getOrCreate", new Class[0]).invoke(builder, new Object[0]);
                            LOG.info("Created Spark session.");
                        }
                    }
                    catch (Exception e) {
                        LOG.warn("SparkSession is not supported", (Throwable)e);
                        throw e;
                    }
                }
            }
        }
        return this.sparksession;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SQLContext sqlctx() {
        if (this.sqlctx == null) {
            SparkEntries sparkEntries = this;
            synchronized (sparkEntries) {
                if (this.sqlctx == null) {
                    this.sqlctx = new SQLContext(this.sc());
                    LOG.info("Created SQLContext.");
                }
            }
        }
        return this.sqlctx;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HiveContext hivectx() {
        if (this.hivectx == null) {
            SparkEntries sparkEntries = this;
            synchronized (sparkEntries) {
                SparkConf conf;
                if (this.hivectx == null && ((conf = this.sc.getConf()).getBoolean("spark.repl.enableHiveContext", false) || conf.get("spark.sql.catalogImplementation", "in-memory").toLowerCase().equals("hive"))) {
                    ClassLoader loader;
                    ClassLoader classLoader = loader = Thread.currentThread().getContextClassLoader() != null ? Thread.currentThread().getContextClassLoader() : this.getClass().getClassLoader();
                    if (loader.getResource("hive-site.xml") == null) {
                        LOG.warn("livy.repl.enable-hive-context is true but no hive-site.xml found on classpath.");
                    }
                    this.hivectx = new HiveContext(this.sc().sc());
                    LOG.info("Created HiveContext.");
                }
            }
        }
        return this.hivectx;
    }

    public synchronized void stop() {
        if (this.sc != null) {
            this.sc.stop();
        }
    }
}

