import { jsx as _jsx, Fragment as _Fragment } from "react/jsx-runtime";
import { useMemo } from "react";
import { TextField, TextFieldType } from "./Fields";
import { useDmnEditorStore } from "../../store/StoreContext";
import { useBoxedExpressionUpdater } from "./useBoxedExpressionUpdater";
export function InvocationFunctionCallCell(props) {
    var _a, _b, _c, _d;
    var selectedObjectId = useDmnEditorStore(function (s) { return s.boxedExpressionEditor.selectedObjectId; });
    var selectedObjectInfos = useMemo(function () { var _a; return (_a = props.boxedExpressionIndex) === null || _a === void 0 ? void 0 : _a.get(selectedObjectId !== null && selectedObjectId !== void 0 ? selectedObjectId : ""); }, [props.boxedExpressionIndex, selectedObjectId]);
    var updater = useBoxedExpressionUpdater((_a = selectedObjectInfos === null || selectedObjectInfos === void 0 ? void 0 : selectedObjectInfos.expressionPath) !== null && _a !== void 0 ? _a : []);
    var cell = useMemo(function () { return selectedObjectInfos === null || selectedObjectInfos === void 0 ? void 0 : selectedObjectInfos.cell; }, [selectedObjectInfos === null || selectedObjectInfos === void 0 ? void 0 : selectedObjectInfos.cell]);
    return (_jsx(_Fragment, { children: _jsx(TextField, { type: TextFieldType.TEXT_INPUT, title: "Function to be called", placeholder: "Enter the function name...", isReadonly: props.isReadonly, initialValue: (_c = (_b = cell.text) === null || _b === void 0 ? void 0 : _b.__$$text) !== null && _c !== void 0 ? _c : "", expressionPath: (_d = selectedObjectInfos === null || selectedObjectInfos === void 0 ? void 0 : selectedObjectInfos.expressionPath) !== null && _d !== void 0 ? _d : [], onChange: function (newDescription) {
                return updater(function (dmnObject) {
                    dmnObject.text = { __$$text: newDescription };
                });
            } }) }));
}
//# sourceMappingURL=InvocationFunctionCallCell.js.map