var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __values = (this && this.__values) || function(o) {
    var s = typeof Symbol === "function" && Symbol.iterator, m = s && o[s], i = 0;
    if (m) return m.call(o);
    if (o && typeof o.length === "number") return {
        next: function () {
            if (o && i >= o.length) o = void 0;
            return { value: o && o[i++], done: !o };
        }
    };
    throw new TypeError(s ? "Object is not iterable." : "Symbol.iterator is not defined.");
};
var __read = (this && this.__read) || function (o, n) {
    var m = typeof Symbol === "function" && o[Symbol.iterator];
    if (!m) return o;
    var i = m.call(o), r, ar = [], e;
    try {
        while ((n === void 0 || n-- > 0) && !(r = i.next()).done) ar.push(r.value);
    }
    catch (error) { e = { error: error }; }
    finally {
        try {
            if (r && !r.done && (m = i["return"])) m.call(i);
        }
        finally { if (e) throw e.error; }
    }
    return ar;
};
var __spreadArray = (this && this.__spreadArray) || function (to, from, pack) {
    if (pack || arguments.length === 2) for (var i = 0, l = from.length, ar; i < l; i++) {
        if (ar || !(i in from)) {
            if (!ar) ar = Array.prototype.slice.call(from, 0, i);
            ar[i] = from[i];
        }
    }
    return to.concat(ar || Array.prototype.slice.call(from));
};
import { jsx as _jsx, jsxs as _jsxs, Fragment as _Fragment } from "react/jsx-runtime";
import { generateUuid, } from "@kie-tools/boxed-expression-component/dist/api";
import { BoxedExpressionEditor } from "@kie-tools/boxed-expression-component/dist/BoxedExpressionEditor";
import { FeelVariables } from "@kie-tools/dmn-feel-antlr4-parser";
import { PMMLDocumentData } from "@kie-tools/pmml-editor-marshaller/dist/api";
import { PMMLFieldData } from "@kie-tools/pmml-editor-marshaller/dist/api/PMMLFieldData";
import { PMMLModelData } from "@kie-tools/pmml-editor-marshaller/dist/api/PMMLModelData";
import { AnomalyDetectionModel, AssociationModel, BaselineModel, BayesianNetworkModel, ClusteringModel, GaussianProcessModel, GeneralRegressionModel, MiningModel, NaiveBayesModel, NearestNeighborModel, NeuralNetwork, RegressionModel, RuleSetModel, Scorecard, SequenceModel, SupportVectorMachineModel, TextModel, TimeSeriesModel, TreeModel, } from "@kie-tools/pmml-editor-marshaller/dist/marshaller/model/pmml4_4";
import { Label } from "@patternfly/react-core/dist/js/components/Label";
import { Text, TextContent, TextVariants } from "@patternfly/react-core/dist/js/components/Text";
import { Flex, FlexItem } from "@patternfly/react-core/dist/js/layouts/Flex";
import { ArrowRightIcon } from "@patternfly/react-icons/dist/js/icons/arrow-right-icon";
import { InfoIcon } from "@patternfly/react-icons/dist/js/icons/info-icon";
import { useCallback, useEffect, useMemo, useRef } from "react";
import { builtInFeelTypes } from "../dataTypes/BuiltInFeelTypes";
import { isStruct } from "../dataTypes/DataTypeSpec";
import { getNodeTypeFromDmnObject } from "../diagram/maths/DmnMaths";
import { NodeIcon } from "../icons/Icons";
import { useExternalModels } from "../includedModels/DmnEditorDependenciesContext";
import { updateExpression } from "../mutations/updateExpression";
import { updateExpressionWidths } from "../mutations/updateExpressionWidths";
import { DmnEditorTab } from "../store/Store";
import { useDmnEditorStore, useDmnEditorStoreApi } from "../store/StoreContext";
import { getDefaultColumnWidth } from "./getDefaultColumnWidth";
import { getDefaultBoxedExpression } from "./getDefaultBoxedExpression";
export function BoxedExpressionScreen(_a) {
    var _b, _c, _d, _e, _f, _g;
    var container = _a.container;
    var externalModelsByNamespace = useExternalModels().externalModelsByNamespace;
    var dmnEditorStoreApi = useDmnEditorStoreApi();
    var thisDmn = useDmnEditorStore(function (s) { return s.dmn; });
    var diagram = useDmnEditorStore(function (s) { return s.diagram; });
    var activeDrgElementId = useDmnEditorStore(function (s) { return s.boxedExpressionEditor.activeDrgElementId; });
    var isPropertiesPanelOpen = useDmnEditorStore(function (s) { return s.boxedExpressionEditor.propertiesPanel.isOpen; });
    var externalDmnsByNamespace = useDmnEditorStore(function (s) { return s.computed(s).getExternalModelTypesByNamespace(externalModelsByNamespace).dmns; });
    var dataTypesTree = useDmnEditorStore(function (s) { return s.computed(s).getDataTypes(externalModelsByNamespace).dataTypesTree; });
    var importsByNamespace = useDmnEditorStore(function (s) { return s.computed(s).importsByNamespace(); });
    var externalPmmlsByNamespace = useDmnEditorStore(function (s) { return s.computed(s).getExternalModelTypesByNamespace(externalModelsByNamespace).pmmls; });
    var isAlternativeInputDataShape = useDmnEditorStore(function (s) { return s.computed(s).isAlternativeInputDataShape(); });
    var drdIndex = useDmnEditorStore(function (s) { return s.computed(s).getDrdIndex(); });
    var onRequestFeelVariables = useCallback(function () {
        var e_1, _a;
        var externalModels = new Map();
        try {
            for (var externalDmnsByNamespace_1 = __values(externalDmnsByNamespace), externalDmnsByNamespace_1_1 = externalDmnsByNamespace_1.next(); !externalDmnsByNamespace_1_1.done; externalDmnsByNamespace_1_1 = externalDmnsByNamespace_1.next()) {
                var _b = __read(externalDmnsByNamespace_1_1.value, 2), key = _b[0], externalDmn = _b[1];
                externalModels.set(key, externalDmn.model);
            }
        }
        catch (e_1_1) { e_1 = { error: e_1_1 }; }
        finally {
            try {
                if (externalDmnsByNamespace_1_1 && !externalDmnsByNamespace_1_1.done && (_a = externalDmnsByNamespace_1.return)) _a.call(externalDmnsByNamespace_1);
            }
            finally { if (e_1) throw e_1.error; }
        }
        return new FeelVariables(dmnEditorStoreApi.getState().dmn.model.definitions, externalModels);
    }, [dmnEditorStoreApi, externalDmnsByNamespace]);
    var drgElementIndex = useMemo(function () {
        var _a;
        if (!activeDrgElementId) {
            return undefined;
        }
        return ((_a = thisDmn.model.definitions.drgElement) !== null && _a !== void 0 ? _a : []).findIndex(function (e) { return e["@_id"] === activeDrgElementId; });
    }, [activeDrgElementId, thisDmn.model.definitions.drgElement]);
    var drgElement = useMemo(function () {
        var _a;
        if (drgElementIndex === undefined) {
            return undefined;
        }
        var drgElement = (_a = thisDmn.model.definitions.drgElement) === null || _a === void 0 ? void 0 : _a[drgElementIndex];
        if (!((drgElement === null || drgElement === void 0 ? void 0 : drgElement.__$$element) === "decision" || (drgElement === null || drgElement === void 0 ? void 0 : drgElement.__$$element) === "businessKnowledgeModel")) {
            return undefined;
        }
        return drgElement;
    }, [drgElementIndex, thisDmn.model.definitions.drgElement]);
    var widthsById = useMemo(function () {
        var _a, _b, _c, _d, _e;
        return ((_e = (_d = (_c = (_b = (_a = thisDmn.model.definitions["dmndi:DMNDI"]) === null || _a === void 0 ? void 0 : _a["dmndi:DMNDiagram"]) === null || _b === void 0 ? void 0 : _b[drdIndex]["di:extension"]) === null || _c === void 0 ? void 0 : _c["kie:ComponentsWidthsExtension"]) === null || _d === void 0 ? void 0 : _d["kie:ComponentWidths"]) !== null && _e !== void 0 ? _e : []).reduce(function (acc, c) {
            var _a;
            if (c["@_dmnElementRef"] === undefined) {
                return acc;
            }
            else {
                return acc.set(c["@_dmnElementRef"], ((_a = c["kie:width"]) !== null && _a !== void 0 ? _a : []).map(function (vv) { return vv.__$$text; }));
            }
        }, new Map());
    }, [drdIndex, thisDmn.model.definitions]);
    var expression = useMemo(function () {
        if (!drgElement) {
            return undefined;
        }
        return {
            boxedExpression: drgElementToBoxedExpression(drgElement),
            drgElementIndex: drgElementIndex,
            drgElement: drgElement,
            drgElementType: drgElement.__$$element,
        };
    }, [drgElement, drgElementIndex]);
    var widthsByIdRef = useRef(widthsById);
    var boxedExpressionRef = useRef(expression === null || expression === void 0 ? void 0 : expression.boxedExpression);
    useEffect(function () {
        widthsByIdRef.current = widthsById;
    }, [widthsById]);
    useEffect(function () {
        boxedExpressionRef.current = expression === null || expression === void 0 ? void 0 : expression.boxedExpression;
    }, [expression === null || expression === void 0 ? void 0 : expression.boxedExpression]);
    var onWidthsChange = useCallback(function (newWidthsByIdAction) {
        dmnEditorStoreApi.setState(function (state) {
            var _a;
            var newWidthsById = typeof newWidthsByIdAction === "function"
                ? newWidthsByIdAction((_a = widthsByIdRef.current) !== null && _a !== void 0 ? _a : new Map())
                : newWidthsByIdAction;
            widthsByIdRef.current = newWidthsById;
            updateExpressionWidths({
                definitions: state.dmn.model.definitions,
                drdIndex: state.computed(state).getDrdIndex(),
                widthsById: newWidthsById,
            });
        });
    }, [dmnEditorStoreApi]);
    var onExpressionChange = useCallback(function (newExpressionAction) {
        dmnEditorStoreApi.setState(function (state) {
            var _a, _b;
            var newExpression = typeof newExpressionAction === "function"
                ? newExpressionAction((_a = boxedExpressionRef.current) !== null && _a !== void 0 ? _a : undefined)
                : newExpressionAction;
            boxedExpressionRef.current = newExpression;
            updateExpression({
                definitions: state.dmn.model.definitions,
                expression: newExpression,
                drgElementIndex: (_b = expression === null || expression === void 0 ? void 0 : expression.drgElementIndex) !== null && _b !== void 0 ? _b : 0,
            });
        });
    }, [dmnEditorStoreApi, expression === null || expression === void 0 ? void 0 : expression.drgElementIndex]);
    var isResetSupportedOnRootExpression = useMemo(function () {
        return (expression === null || expression === void 0 ? void 0 : expression.drgElementType) === "decision";
    }, [expression === null || expression === void 0 ? void 0 : expression.drgElementType]);
    var dataTypes = useMemo(function () {
        var customDataTypes = dataTypesTree.map(function (d) { return ({
            isCustom: true,
            name: d.feelName,
        }); });
        return __spreadArray(__spreadArray([], __read(builtInFeelTypes), false), __read(customDataTypes), false);
    }, [dataTypesTree]);
    var pmmlDocuments = useMemo(function () {
        return __spreadArray([], __read(externalPmmlsByNamespace.entries()), false).flatMap(function (_a) {
            var _b = __read(_a, 2), namespace = _b[0], pmml = _b[1];
            var documentData = getPmmlDocumentData(pmml.model);
            var _import = importsByNamespace.get(namespace);
            if (!_import) {
                return [];
            }
            return {
                document: _import["@_name"],
                modelsFromDocument: documentData.models.map(function (m) { return ({
                    model: m.modelName,
                    parametersFromModel: m.fields.map(function (f) { return ({
                        "@_id": generateUuid(),
                        "@_name": f.fieldName,
                        description: { __$$text: f.fieldName },
                    }); }),
                }); }),
            };
        });
    }, [importsByNamespace, externalPmmlsByNamespace]);
    var beeGwtService = useMemo(function () {
        return {
            getDefaultExpressionDefinition: function (logicType, typeRef, isRoot) {
                var s = dmnEditorStoreApi.getState();
                var c = s.computed(s);
                var allTopLevelDataTypesByFeelName = c.getDataTypes(externalModelsByNamespace).allTopLevelDataTypesByFeelName;
                var nodesById = c.getDiagramData(externalModelsByNamespace).nodesById;
                var defaultWidthsById = new Map();
                var defaultExpression = getDefaultBoxedExpression({
                    logicType: logicType,
                    typeRef: typeRef,
                    allTopLevelDataTypesByFeelName: allTopLevelDataTypesByFeelName,
                    widthsById: defaultWidthsById,
                    getDefaultColumnWidth: getDefaultColumnWidth,
                    getInputs: function () {
                        var _a;
                        var drgElement = (_a = s.dmn.model.definitions.drgElement) === null || _a === void 0 ? void 0 : _a[drgElementIndex !== null && drgElementIndex !== void 0 ? drgElementIndex : 0];
                        if (!isRoot || (drgElement === null || drgElement === void 0 ? void 0 : drgElement.__$$element) !== "decision") {
                            return undefined;
                        }
                        else {
                            return determineInputsForDecision(drgElement, allTopLevelDataTypesByFeelName, nodesById);
                        }
                    },
                });
                return {
                    expression: defaultExpression,
                    widthsById: defaultWidthsById,
                };
            },
            selectObject: function (uuid) {
                dmnEditorStoreApi.setState(function (state) {
                    state.boxedExpressionEditor.selectedObjectId = uuid;
                });
            },
            openDataTypePage: function () {
                dmnEditorStoreApi.setState(function (state) {
                    state.navigation.tab = DmnEditorTab.DATA_TYPES;
                });
            },
        };
    }, [dmnEditorStoreApi, drgElementIndex, externalModelsByNamespace]);
    var Icon = useMemo(function () {
        if (!drgElement) {
            throw new Error("A node Icon must exist for all types of node");
        }
        var nodeType = getNodeTypeFromDmnObject(drgElement);
        if (nodeType === undefined) {
            throw new Error("Can't determine node icon with undefined node type");
        }
        return NodeIcon({ nodeType: nodeType, isAlternativeInputDataShape: isAlternativeInputDataShape });
    }, [drgElement, isAlternativeInputDataShape]);
    return (_jsx(_Fragment, { children: _jsxs(_Fragment, { children: [_jsxs(Flex, __assign({ className: "kie-dmn-editor--sticky-top-glass-header kie-dmn-editor--boxed-expression-header", justifyContent: { default: "justifyContentSpaceBetween" }, alignItems: { default: "alignItemsCenter" }, direction: { default: "row" } }, { children: [_jsx(FlexItem, { children: _jsxs(Label, __assign({ className: "kie-dmn-editor--boxed-expression-back", onClick: function () {
                                    dmnEditorStoreApi.setState(function (state) {
                                        state.dispatch(state).boxedExpressionEditor.close();
                                    });
                                } }, { children: [_jsx(ArrowRightIcon, { style: { transform: "scale(-1, -1)", marginRight: "12px" } }), _jsx("p", { children: "Back to Diagram" })] })) }), _jsx(FlexItem, { children: _jsxs(Flex, __assign({ flexWrap: { default: "nowrap" }, justifyContent: { default: "justifyContentSpaceBetween" }, alignItems: { default: "alignItemsCenter" } }, { children: [_jsx(FlexItem, { children: _jsx("div", __assign({ style: { height: "40px", width: "40px" } }, { children: _jsx(Icon, {}) })) }), _jsx(FlexItem, { children: _jsx(TextContent, { children: _jsx(Text, __assign({ component: TextVariants.h2 }, { children: expression === null || expression === void 0 ? void 0 : expression.drgElement["@_name"] })) }) }), _jsx(FlexItem, { style: { width: "105px" } })] })) }), _jsx("aside", __assign({ className: "kie-dmn-editor--properties-panel-toggle", style: { visibility: isPropertiesPanelOpen ? "hidden" : undefined } }, { children: _jsx("button", __assign({ className: "kie-dmn-editor--properties-panel-toggle-button", title: "Properties panel", onClick: function () {
                                    dmnEditorStoreApi.setState(function (state) {
                                        state.boxedExpressionEditor.propertiesPanel.isOpen =
                                            !state.boxedExpressionEditor.propertiesPanel.isOpen;
                                    });
                                } }, { children: _jsx(InfoIcon, { size: "sm" }) })) }))] })), _jsx("div", __assign({ style: { flexGrow: 1 } }, { children: _jsx(BoxedExpressionEditor, { beeGwtService: beeGwtService, pmmlDocuments: pmmlDocuments, isResetSupportedOnRootExpression: isResetSupportedOnRootExpression, expressionHolderId: activeDrgElementId, expressionHolderName: (_d = (_c = (_b = drgElement === null || drgElement === void 0 ? void 0 : drgElement.variable) === null || _b === void 0 ? void 0 : _b["@_name"]) !== null && _c !== void 0 ? _c : drgElement === null || drgElement === void 0 ? void 0 : drgElement["@_name"]) !== null && _d !== void 0 ? _d : "", expressionHolderTypeRef: (_f = (_e = drgElement === null || drgElement === void 0 ? void 0 : drgElement.variable) === null || _e === void 0 ? void 0 : _e["@_typeRef"]) !== null && _f !== void 0 ? _f : (_g = expression === null || expression === void 0 ? void 0 : expression.boxedExpression) === null || _g === void 0 ? void 0 : _g["@_typeRef"], expression: expression === null || expression === void 0 ? void 0 : expression.boxedExpression, onExpressionChange: onExpressionChange, dataTypes: dataTypes, scrollableParentRef: container, onRequestFeelVariables: onRequestFeelVariables, widthsById: widthsById, onWidthsChange: onWidthsChange }) }))] }) }));
}
export function drgElementToBoxedExpression(expressionHolder) {
    var _a, _b, _c, _d, _e, _f, _g;
    if (expressionHolder.__$$element === "businessKnowledgeModel") {
        return expressionHolder.encapsulatedLogic
            ? __assign({ __$$element: "functionDefinition", "@_label": (_a = expressionHolder.encapsulatedLogic["@_label"]) !== null && _a !== void 0 ? _a : expressionHolder["@_name"], "@_typeRef": (_b = expressionHolder.encapsulatedLogic["@_typeRef"]) !== null && _b !== void 0 ? _b : (_c = expressionHolder.variable) === null || _c === void 0 ? void 0 : _c["@_typeRef"] }, expressionHolder.encapsulatedLogic) : {
            __$$element: "functionDefinition",
            "@_id": generateUuid(),
            "@_kind": "FEEL",
            expression: undefined,
            formalParameter: [],
            "@_label": expressionHolder["@_name"],
            "@_typeRef": (_d = expressionHolder.variable) === null || _d === void 0 ? void 0 : _d["@_typeRef"],
        };
    }
    else if (expressionHolder.__$$element === "decision") {
        return expressionHolder.expression
            ? __assign(__assign({}, expressionHolder.expression), { "@_label": (_g = (_f = (_e = expressionHolder === null || expressionHolder === void 0 ? void 0 : expressionHolder.variable) === null || _e === void 0 ? void 0 : _e["@_name"]) !== null && _f !== void 0 ? _f : expressionHolder.expression["@_label"]) !== null && _g !== void 0 ? _g : expressionHolder === null || expressionHolder === void 0 ? void 0 : expressionHolder["@_name"], "@_typeRef": (expressionHolder === null || expressionHolder === void 0 ? void 0 : expressionHolder.variable)
                    ? expressionHolder === null || expressionHolder === void 0 ? void 0 : expressionHolder.variable["@_typeRef"]
                    : expressionHolder.expression["@_typeRef"] }) : undefined;
    }
    else {
        throw new Error("Unknown __$$element of expressionHolder that has an expression '".concat(expressionHolder.__$$element, "'."));
    }
}
function determineInputsForDecision(decision, allTopLevelDataTypesByFeelName, nodesById) {
    var _a;
    try {
        var ret = ((_a = decision.informationRequirement) !== null && _a !== void 0 ? _a : []).flatMap(function (s) {
            var _a, _b, _c, _d, _e;
            var dmnObject = nodesById.get(((_b = (_a = s.requiredDecision) === null || _a === void 0 ? void 0 : _a["@_href"]) !== null && _b !== void 0 ? _b : (_c = s.requiredInput) === null || _c === void 0 ? void 0 : _c["@_href"])).data.dmnObject;
            if (!((dmnObject === null || dmnObject === void 0 ? void 0 : dmnObject.__$$element) === "inputData" || (dmnObject === null || dmnObject === void 0 ? void 0 : dmnObject.__$$element) === "decision")) {
                throw new Error("DMN EDITOR: Information requirement can't ever point to anything other than an InputData or a Decision");
            }
            var dataType = allTopLevelDataTypesByFeelName.get(dmnObject.variable["@_typeRef"]);
            return dataType && isStruct(dataType.itemDefinition)
                ? ((_d = dataType.itemDefinition.itemComponent) !== null && _d !== void 0 ? _d : []).flatMap(function (ic) {
                    return flattenItemComponents({
                        itemDefinition: ic,
                        acc: dmnObject.variable["@_name"],
                    });
                })
                : [
                    {
                        name: dmnObject.variable["@_name"],
                        typeRef: (_e = dmnObject.variable) === null || _e === void 0 ? void 0 : _e["@_typeRef"],
                    },
                ];
        });
        if (ret.length === 0) {
            return undefined;
        }
        return ret;
    }
    catch (e) {
        console.error("DMN EDITOR: Error suggesting imports for root expression on '".concat(decision["@_name"], "'."), e);
        return undefined;
    }
}
function flattenItemComponents(_a) {
    var _b, _c;
    var itemDefinition = _a.itemDefinition, acc = _a.acc;
    if (!isStruct(itemDefinition)) {
        return [
            {
                name: "".concat(acc, ".").concat(itemDefinition["@_name"]),
                typeRef: (_b = itemDefinition.typeRef) === null || _b === void 0 ? void 0 : _b.__$$text,
            },
        ];
    }
    return ((_c = itemDefinition.itemComponent) !== null && _c !== void 0 ? _c : []).flatMap(function (ic) {
        return flattenItemComponents({ itemDefinition: ic, acc: "".concat(acc, ".").concat(itemDefinition["@_name"]) });
    });
}
export function getPmmlDocumentData(pmml) {
    var models = [];
    var document = new PMMLDocumentData(models);
    if (pmml.models) {
        pmml.models.forEach(function (model) {
            var modelData = retrieveModelData(model);
            if (modelData) {
                models.push(modelData);
            }
        });
    }
    return document;
}
export function retrieveModelData(model) {
    var e_2, _a;
    var modelsTypes = [
        AnomalyDetectionModel,
        AssociationModel,
        BayesianNetworkModel,
        BaselineModel,
        ClusteringModel,
        GaussianProcessModel,
        GeneralRegressionModel,
        MiningModel,
        NaiveBayesModel,
        NearestNeighborModel,
        NeuralNetwork,
        RegressionModel,
        RuleSetModel,
        SequenceModel,
        Scorecard,
        SupportVectorMachineModel,
        TextModel,
        TimeSeriesModel,
        TreeModel,
    ];
    var modelData;
    try {
        for (var modelsTypes_1 = __values(modelsTypes), modelsTypes_1_1 = modelsTypes_1.next(); !modelsTypes_1_1.done; modelsTypes_1_1 = modelsTypes_1.next()) {
            var type = modelsTypes_1_1.value;
            if (model instanceof type) {
                var modelFields = model.MiningSchema.MiningField.map(function (field) { return new PMMLFieldData(field.name.toString(), field.usageType); });
                modelData = new PMMLModelData(model.modelName == null ? "" : model.modelName, modelFields);
            }
        }
    }
    catch (e_2_1) { e_2 = { error: e_2_1 }; }
    finally {
        try {
            if (modelsTypes_1_1 && !modelsTypes_1_1.done && (_a = modelsTypes_1.return)) _a.call(modelsTypes_1);
        }
        finally { if (e_2) throw e_2.error; }
    }
    return modelData;
}
//# sourceMappingURL=BoxedExpressionScreen.js.map