import { OperationType } from "@kie-tools/runtime-tools-shared-gateway-api/dist/types";
import { BulkWorkflowInstanceActionResponse, WorkflowInstance, WorkflowInstanceFilter, WorkflowListSortBy } from "@kie-tools/runtime-tools-swf-gateway-api/dist/types";
export interface WorkflowListChannelApi {
    workflowList__initialLoad(filter: WorkflowInstanceFilter, sortBy: WorkflowListSortBy): Promise<void>;
    workflowList__openWorkflow(workflow: WorkflowInstance): Promise<void>;
    workflowList__applyFilter(filter: WorkflowInstanceFilter): Promise<void>;
    workflowList__applySorting(sortBy: WorkflowListSortBy): Promise<void>;
    workflowList__handleWorkflowSkip(workflowInstance: WorkflowInstance): Promise<void>;
    workflowList__handleWorkflowRetry(workflowInstance: WorkflowInstance): Promise<void>;
    workflowList__handleWorkflowAbort(workflowInstance: WorkflowInstance): Promise<void>;
    workflowList__handleWorkflowMultipleAction(workflowInstances: WorkflowInstance[], operationType: OperationType): Promise<BulkWorkflowInstanceActionResponse>;
    workflowList__query(offset: number, limit: number): Promise<WorkflowInstance[]>;
    workflowList__getChildWorkflowsQuery(rootWorkflowInstanceId: string): Promise<WorkflowInstance[]>;
    workflowList__openTriggerCloudEvent(workflowInstance?: WorkflowInstance): void;
}
//# sourceMappingURL=WorkflowListChannelApi.d.ts.map