import React from "react";
import { CardBody, Card, CardHeader } from "@patternfly/react-core/dist/js/components/Card";
import { Label } from "@patternfly/react-core/dist/js/components/Label";
import { Tooltip } from "@patternfly/react-core/dist/js/components/Tooltip";
import { Title } from "@patternfly/react-core/dist/js/components/Title";
import { TextContent, TextVariants, Text } from "@patternfly/react-core/dist/js/components/Text";
import { componentOuiaProps } from "@kie-tools/runtime-tools-components/dist/ouiaTools";
import { InfoCircleIcon } from "@patternfly/react-icons/dist/js/icons/info-circle-icon";
import "../styles.css";
const WorkflowDetailsMilestonesPanel = ({ ouiaId, ouiaSafe, milestones }) => {
    var _a;
    const handleStatus = (status) => {
        switch (status) {
            case "AVAILABLE":
                return React.createElement(Label, { icon: React.createElement(InfoCircleIcon, null) }, "Available");
            case "ACTIVE":
                return (React.createElement(Label, { color: "blue", icon: React.createElement(InfoCircleIcon, null) }, "Active"));
            case "COMPLETED":
                return (React.createElement(Label, { color: "green", icon: React.createElement(InfoCircleIcon, null) }, "Completed"));
            default:
                break;
        }
    };
    const compareObjs = (firstEle, secondEle) => {
        if (firstEle.status < secondEle.status) {
            return -1;
        }
        if (firstEle.status > secondEle.status) {
            return 1;
        }
        return 0;
    };
    const sortedMilestones = (_a = milestones === null || milestones === void 0 ? void 0 : milestones.sort(compareObjs)) !== null && _a !== void 0 ? _a : [];
    return (React.createElement(Card, Object.assign({}, componentOuiaProps(ouiaId, "milestones", ouiaSafe)),
        React.createElement(CardHeader, null,
            React.createElement(Title, { headingLevel: "h3", size: "xl" }, "Milestones")),
        React.createElement(CardBody, null,
            React.createElement(TextContent, { className: "kogito-process-details--milestones__nameText" }, sortedMilestones.map((milestone, index) => {
                if (milestone.name.length > 45) {
                    return (React.createElement(Tooltip, { content: milestone.name, key: index },
                        React.createElement(Text, { component: milestone.status === "COMPLETED" ? TextVariants.blockquote : TextVariants.p },
                            React.createElement("span", { className: "kogito-process-details--milestones__nameTextEllipses" }, milestone.name),
                            " ",
                            handleStatus(milestone.status))));
                }
                else {
                    return (React.createElement(Text, { component: milestone.status === "COMPLETED" ? TextVariants.blockquote : TextVariants.p, key: index },
                        milestone.name,
                        " ",
                        handleStatus(milestone.status)));
                }
            })))));
};
export default WorkflowDetailsMilestonesPanel;
//# sourceMappingURL=WorkflowDetailsMilestonesPanel.js.map