"use strict";
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.HeaderKeys = exports.HttpMethod = exports.ContentTypes = void 0;
var dist_1 = require("@kie-tools/cors-proxy-api/dist");
var ContentTypes;
(function (ContentTypes) {
    ContentTypes["APPLICATION_JSON"] = "application/json";
    ContentTypes["APPLICATION_YAML"] = "application/yaml";
    ContentTypes["APPLICATION_ZIP"] = "application/zip";
})(ContentTypes = exports.ContentTypes || (exports.ContentTypes = {}));
var HttpMethod;
(function (HttpMethod) {
    HttpMethod["GET"] = "GET";
    HttpMethod["POST"] = "POST";
    HttpMethod["PUT"] = "PUT";
    HttpMethod["PATCH"] = "PATCH";
    HttpMethod["DELETE"] = "DELETE";
})(HttpMethod = exports.HttpMethod || (exports.HttpMethod = {}));
exports.HeaderKeys = __assign({ AUTHORIZATION: "Authorization", ACCEPT: "Accept", CONTENT_TYPE: "Content-Type" }, dist_1.CorsProxyHeaderKeys);
//# sourceMappingURL=FetchConstants.js.map