/*
 * Decompiled with CFR 0.152.
 */
package com.hankcs.hanlp.model.perceptron.model;

import com.hankcs.hanlp.model.perceptron.feature.FeatureMap;
import com.hankcs.hanlp.model.perceptron.instance.Instance;
import com.hankcs.hanlp.model.perceptron.model.LinearModel;
import com.hankcs.hanlp.model.perceptron.tagset.TagSet;

public class StructuredPerceptron
extends LinearModel {
    public StructuredPerceptron(FeatureMap featureMap, float[] parameter) {
        super(featureMap, parameter);
    }

    public StructuredPerceptron(FeatureMap featureMap) {
        super(featureMap);
    }

    public void update(int[] goldIndex, int[] predictIndex) {
        for (int i = 0; i < goldIndex.length; ++i) {
            if (goldIndex[i] == predictIndex[i]) continue;
            int n = goldIndex[i];
            this.parameter[n] = this.parameter[n] + 1.0f;
            if (predictIndex[i] >= 0 && predictIndex[i] < this.parameter.length) {
                int n2 = predictIndex[i];
                this.parameter[n2] = this.parameter[n2] - 1.0f;
                continue;
            }
            throw new IllegalArgumentException("\u66f4\u65b0\u53c2\u6570\u65f6\u4f20\u5165\u4e86\u975e\u6cd5\u7684\u4e0b\u6807");
        }
    }

    public void update(Instance instance) {
        int[] guessLabel = new int[instance.length()];
        this.viterbiDecode(instance, guessLabel);
        TagSet tagSet = this.featureMap.tagSet;
        for (int i = 0; i < instance.length(); ++i) {
            int[] featureVector = instance.getFeatureAt(i);
            int[] goldFeature = new int[featureVector.length];
            int[] predFeature = new int[featureVector.length];
            for (int j = 0; j < featureVector.length - 1; ++j) {
                goldFeature[j] = featureVector[j] * tagSet.size() + instance.tagArray[i];
                predFeature[j] = featureVector[j] * tagSet.size() + guessLabel[i];
            }
            goldFeature[featureVector.length - 1] = (i == 0 ? tagSet.bosId() : instance.tagArray[i - 1]) * tagSet.size() + instance.tagArray[i];
            predFeature[featureVector.length - 1] = (i == 0 ? tagSet.bosId() : guessLabel[i - 1]) * tagSet.size() + guessLabel[i];
            this.update(goldFeature, predFeature);
        }
    }
}

