/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.store.client.grpc;

import io.grpc.ManagedChannel;
import io.grpc.ManagedChannelBuilder;
import io.grpc.stub.AbstractAsyncStub;
import io.grpc.stub.AbstractBlockingStub;
import io.grpc.stub.AbstractStub;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.IntStream;
import org.apache.hugegraph.store.client.util.ExecutorPool;
import org.apache.hugegraph.store.client.util.HgStoreClientConfig;
import org.apache.hugegraph.store.term.HgPair;

public abstract class AbstractGrpcClient {
    private static Map<String, ManagedChannel[]> channels = new ConcurrentHashMap<String, ManagedChannel[]>();
    private static int n = 5;
    private static int concurrency = 1 << n;
    private static AtomicLong counter = new AtomicLong(0L);
    private static long limit = 0x3FFFFFFFFFFFFFFFL;
    private static HgStoreClientConfig config = HgStoreClientConfig.of();
    private Map<String, HgPair<ManagedChannel, AbstractBlockingStub>[]> blockingStubs = new ConcurrentHashMap<String, HgPair<ManagedChannel, AbstractBlockingStub>[]>();
    private Map<String, HgPair<ManagedChannel, AbstractAsyncStub>[]> asyncStubs = new ConcurrentHashMap<String, HgPair<ManagedChannel, AbstractAsyncStub>[]>();
    private ThreadPoolExecutor executor = ExecutorPool.createExecutor("common", 60L, concurrency, concurrency);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ManagedChannel[] getChannels(String target) {
        ManagedChannel[] tc = channels.get(target);
        if (tc == null) {
            Map<String, ManagedChannel[]> map = channels;
            synchronized (map) {
                tc = channels.get(target);
                if (tc == null) {
                    try {
                        ManagedChannel[] value = new ManagedChannel[concurrency];
                        CountDownLatch latch = new CountDownLatch(concurrency);
                        int i = 0;
                        while (i < concurrency) {
                            int fi = i++;
                            this.executor.execute(() -> {
                                try {
                                    value[fi] = this.getManagedChannel(target);
                                }
                                catch (Exception e) {
                                    throw new RuntimeException(e);
                                }
                                finally {
                                    latch.countDown();
                                }
                            });
                        }
                        latch.await();
                        tc = value;
                        channels.put(target, value);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            }
        }
        return tc;
    }

    public abstract AbstractBlockingStub getBlockingStub(ManagedChannel var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AbstractBlockingStub getBlockingStub(String target) {
        ManagedChannel[] channels = this.getChannels(target);
        HgPair<ManagedChannel, AbstractBlockingStub>[] pairs = this.blockingStubs.get(target);
        long l = counter.getAndIncrement();
        if (l >= limit) {
            counter.set(0L);
        }
        int index = (int)(l & (long)(concurrency - 1));
        if (pairs == null) {
            Map<String, HgPair<ManagedChannel, AbstractBlockingStub>[]> map = this.blockingStubs;
            synchronized (map) {
                pairs = this.blockingStubs.get(target);
                if (pairs == null) {
                    HgPair[] value = new HgPair[concurrency];
                    IntStream.range(0, concurrency).forEach(i -> {
                        ManagedChannel channel = channels[index];
                        AbstractBlockingStub stub = this.getBlockingStub(channel);
                        value[i] = new HgPair((Object)channel, (Object)stub);
                    });
                    this.blockingStubs.put(target, value);
                    AbstractBlockingStub stub = (AbstractBlockingStub)value[index].getValue();
                    return (AbstractBlockingStub)this.setBlockingStubOption(stub);
                }
            }
        }
        return (AbstractBlockingStub)this.setBlockingStubOption((AbstractBlockingStub)pairs[index].getValue());
    }

    private AbstractStub setBlockingStubOption(AbstractBlockingStub stub) {
        return stub.withDeadlineAfter((long)config.getGrpcTimeoutSeconds().intValue(), TimeUnit.SECONDS).withMaxInboundMessageSize(config.getGrpcMaxInboundMessageSize().intValue()).withMaxOutboundMessageSize(config.getGrpcMaxOutboundMessageSize().intValue());
    }

    public AbstractAsyncStub getAsyncStub(ManagedChannel channel) {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AbstractAsyncStub getAsyncStub(String target) {
        ManagedChannel[] channels = this.getChannels(target);
        HgPair<ManagedChannel, AbstractAsyncStub>[] pairs = this.asyncStubs.get(target);
        long l = counter.getAndIncrement();
        if (l >= limit) {
            counter.set(0L);
        }
        int index = (int)(l & (long)(concurrency - 1));
        if (pairs == null) {
            Map<String, HgPair<ManagedChannel, AbstractAsyncStub>[]> map = this.asyncStubs;
            synchronized (map) {
                pairs = this.asyncStubs.get(target);
                if (pairs == null) {
                    HgPair[] value = new HgPair[concurrency];
                    IntStream.range(0, concurrency).parallel().forEach(i -> {
                        ManagedChannel channel = channels[index];
                        AbstractAsyncStub stub = this.getAsyncStub(channel);
                        value[i] = new HgPair((Object)channel, (Object)stub);
                    });
                    this.asyncStubs.put(target, value);
                    AbstractAsyncStub stub = (AbstractAsyncStub)this.setStubOption((AbstractStub)value[index].getValue());
                    return stub;
                }
            }
        }
        return (AbstractAsyncStub)this.setStubOption((AbstractStub)pairs[index].getValue());
    }

    private AbstractStub setStubOption(AbstractStub value) {
        return value.withMaxInboundMessageSize(config.getGrpcMaxInboundMessageSize().intValue()).withMaxOutboundMessageSize(config.getGrpcMaxOutboundMessageSize().intValue());
    }

    private ManagedChannel getManagedChannel(String target) {
        return ManagedChannelBuilder.forTarget((String)target).usePlaintext().build();
    }
}

