/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.store.node.grpc;

import io.grpc.stub.StreamObserver;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.hugegraph.store.grpc.state.NodeStateRes;
import org.apache.hugegraph.store.grpc.state.NodeStateType;
import org.apache.hugegraph.store.node.util.HgAssert;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class HgStoreStateSubject {
    private static final Logger log = LoggerFactory.getLogger(HgStoreStateSubject.class);
    public static final Map<String, StreamObserver<NodeStateRes>> subObserverHolder = new ConcurrentHashMap();

    public static void addObserver(String subId, StreamObserver<NodeStateRes> observer) {
        HgAssert.isArgumentValid((String)subId, (String)"subId");
        HgAssert.isArgumentNotNull((Object)(observer == null ? 1 : 0), (String)"observer");
        subObserverHolder.put(subId, observer);
    }

    public static void removeObserver(String subId) {
        HgAssert.isArgumentValid((String)subId, (String)"subId");
        subObserverHolder.remove(subId);
    }

    public static void notifyAll(NodeStateType nodeState) {
        HgAssert.isArgumentNotNull((Object)(nodeState == null ? 1 : 0), (String)"nodeState");
        NodeStateRes res = NodeStateRes.newBuilder().setState(nodeState).build();
        Iterator iter = subObserverHolder.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            try {
                ((StreamObserver)entry.getValue()).onNext((Object)res);
            }
            catch (Throwable e) {
                log.error("Failed to send node-state[" + nodeState + "] to subscriber[" + (String)entry.getKey() + "].", e);
                iter.remove();
                log.error("Removed the subscriber[" + (String)entry.getKey() + "].", e);
            }
        }
    }
}

