/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.store.node.controller;

import com.taobao.arthas.agent.attach.ArthasAgent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.hugegraph.pd.common.PDException;
import org.apache.hugegraph.rocksdb.access.RocksDBSession;
import org.apache.hugegraph.rocksdb.access.ScanIterator;
import org.apache.hugegraph.store.HgStoreEngine;
import org.apache.hugegraph.store.PartitionEngine;
import org.apache.hugegraph.store.business.BusinessHandler;
import org.apache.hugegraph.store.business.InnerKeyCreator;
import org.apache.hugegraph.store.meta.Partition;
import org.apache.hugegraph.store.node.AppConfig;
import org.apache.hugegraph.store.node.controller.PartitionAPI;
import org.apache.hugegraph.store.node.grpc.HgStoreNodeService;
import org.apache.hugegraph.util.Bytes;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/v1"})
public class PartitionAPI {
    private static final Logger log = LoggerFactory.getLogger(PartitionAPI.class);
    @Autowired
    HgStoreNodeService nodeService;
    @Autowired
    AppConfig appConfig;

    @GetMapping(value={"/partitions"}, produces={"application/json"})
    public Map<String, Object> getPartitions(@RequestParam(required=false, defaultValue="") String flags) {
        List<String> flagList;
        boolean accurate = false;
        if (!flags.isEmpty() && (flagList = Arrays.asList(flags.split(","))).contains("accurate")) {
            accurate = true;
        }
        ArrayList<Raft> rafts = new ArrayList<Raft>();
        HgStoreEngine storeEngine = this.nodeService.getStoreEngine();
        BusinessHandler businessHandler = storeEngine.getBusinessHandler();
        Map partitionEngines = storeEngine.getPartitionEngines();
        for (Map.Entry engineEntry : partitionEngines.entrySet()) {
            PartitionEngine engine = (PartitionEngine)engineEntry.getValue();
            Raft raft = new Raft(this);
            raft.setGroupId(engine.getGroupId().intValue());
            raft.setLeader(engine.getLeader());
            raft.setRole(engine.getRaftNode().getNodeState().name());
            raft.setConf(engine.getCurrentConf().toString());
            if (engine.isLeader()) {
                raft.setPeers(engine.getRaftNode().listPeers());
                raft.setLearners(engine.getRaftNode().listLearners());
            }
            raft.setTerm(engine.getLeaderTerm());
            raft.setLogIndex(engine.getCommittedIndex());
            raft.setPartitionCount(engine.getPartitions().size());
            for (Map.Entry partitionEntry : engine.getPartitions().entrySet()) {
                String graphName = (String)partitionEntry.getKey();
                Partition pt = (Partition)partitionEntry.getValue();
                PartitionInfo partition = new PartitionInfo(this, pt);
                businessHandler.getLatestSequenceNumber(graphName, pt.getId());
                partition.setMetric(businessHandler.getPartitionMetric(graphName, pt.getId(), accurate));
                partition.setLeader(pt.isLeader() == engine.isLeader() ? "OK" : "Error");
                raft.getPartitions().add(partition);
            }
            rafts.add(raft);
        }
        return this.okMap("partitions", rafts);
    }

    @GetMapping(value={"/partition/{id}"}, produces={"application/json"})
    public Raft getPartition(@PathVariable(value="id") int id) {
        HgStoreEngine storeEngine = this.nodeService.getStoreEngine();
        BusinessHandler businessHandler = storeEngine.getBusinessHandler();
        PartitionEngine engine = storeEngine.getPartitionEngine(Integer.valueOf(id));
        Raft raft = new Raft(this);
        raft.setGroupId(engine.getGroupId().intValue());
        raft.setLeader(engine.getLeader());
        raft.setRole(engine.getRaftNode().getNodeState().name());
        if (engine.isLeader()) {
            raft.setPeers(engine.getRaftNode().listPeers());
            raft.setLearners(engine.getRaftNode().listLearners());
        }
        raft.setLogIndex(engine.getCommittedIndex());
        for (Map.Entry partitionEntry : engine.getPartitions().entrySet()) {
            String graphName = (String)partitionEntry.getKey();
            Partition pt = (Partition)partitionEntry.getValue();
            PartitionInfo partition = new PartitionInfo(this, pt);
            partition.setMetric(businessHandler.getPartitionMetric(graphName, pt.getId(), false));
            raft.getPartitions().add(partition);
        }
        return raft;
    }

    @GetMapping(value={"/partition/dump/{id}"}, produces={"application/json"})
    public Map<String, Object> dumpPartition(@PathVariable(value="id") int id) throws PDException {
        HgStoreEngine storeEngine = this.nodeService.getStoreEngine();
        BusinessHandler handler = storeEngine.getBusinessHandler();
        InnerKeyCreator innerKeyCreator = new InnerKeyCreator(handler);
        storeEngine.getPartitionEngine(Integer.valueOf(id)).getPartitions().forEach((graph, partition) -> {
            log.info("{}----------------------------", graph);
            ScanIterator cfIterator = handler.scanRaw(graph, partition.getId(), 0L);
            while (cfIterator.hasNext()) {
                ScanIterator iterator = (ScanIterator)cfIterator.next();
                try {
                    byte[] cfName = cfIterator.position();
                    log.info("\t{}", (Object)new String(cfName));
                    while (iterator.hasNext()) {
                        RocksDBSession.BackendColumn col = (RocksDBSession.BackendColumn)iterator.next();
                        int keyCode = innerKeyCreator.parseKeyCode(col.name);
                        log.info("\t\t{} --key={}, code={} ", new Object[]{new String(col.name), Bytes.toHex((byte[])col.name), keyCode});
                    }
                }
                finally {
                    if (iterator == null) continue;
                    iterator.close();
                }
            }
            cfIterator.close();
        });
        return this.okMap("ok", null);
    }

    @GetMapping(value={"/partition/clean/{id}"}, produces={"application/json"})
    public Map<String, Object> cleanPartition(@PathVariable(value="id") int id) throws PDException {
        HgStoreEngine storeEngine = this.nodeService.getStoreEngine();
        BusinessHandler handler = storeEngine.getBusinessHandler();
        storeEngine.getPartitionEngine(Integer.valueOf(id)).getPartitions().forEach((graph, partition) -> handler.cleanPartition(graph, id));
        return this.okMap("ok", null);
    }

    @GetMapping(value={"/arthasstart"}, produces={"application/json"})
    public Map<String, Object> arthasstart(@RequestParam(required=false, defaultValue="") String flags) {
        HashMap<String, String> configMap = new HashMap<String, String>();
        configMap.put("arthas.telnetPort", this.appConfig.getArthasConfig().getTelnetPort());
        configMap.put("arthas.httpPort", this.appConfig.getArthasConfig().getHttpPort());
        configMap.put("arthas.ip", this.appConfig.getArthasConfig().getArthasip());
        configMap.put("arthas.disabledCommands", this.appConfig.getArthasConfig().getDisCmd());
        ArthasAgent.attach(configMap);
        ArrayList<String> ret = new ArrayList<String>();
        ret.add("Arthas started successfully");
        return this.okMap("arthasstart", ret);
    }

    public Map<String, Object> okMap(String k, Object v) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("status", 0);
        map.put(k, v);
        return map;
    }
}

