/*
 * Decompiled with CFR 0.152.
 */
package jflex.core;

import java.util.Objects;
import jflex.exceptions.GeneratorException;
import jflex.logging.Out;

public final class Action {
    public static final int NORMAL = 0;
    public static final int FIXED_BASE = 1;
    public static final int FIXED_LOOK = 2;
    public static final int FINITE_CHOICE = 3;
    public static final int GENERAL_LOOK = 4;
    public static final int FORWARD_ACTION = 5;
    public static final int BACKWARD_ACTION = 6;
    public final String content;
    public final int priority;
    private int kind = 0;
    private int len;
    private int entryState;

    public Action(String content, int priority) {
        this.content = content.trim();
        this.priority = priority;
    }

    public Action(int kind) {
        if (kind != 5 && kind != 6) {
            throw new GeneratorException();
        }
        this.content = "";
        this.priority = Integer.MAX_VALUE;
        this.kind = kind;
    }

    public Action getHigherPriority(Action other) {
        if (other == null) {
            return this;
        }
        if (other.priority > this.priority) {
            return this;
        }
        return other;
    }

    public String toString() {
        return "Action (priority " + this.priority + ", lookahead " + this.kind + ") :" + Out.NL + this.content;
    }

    public boolean isEquiv(Action a) {
        return Objects.equals(this.content, a.content) && this.kind == a.kind && this.len == a.len && this.entryState == a.entryState;
    }

    public int hashCode() {
        return this.content.hashCode();
    }

    public boolean equals(Object o) {
        if (o instanceof Action) {
            if (o == this) {
                return true;
            }
            return this.isEquiv((Action)o);
        }
        return false;
    }

    public boolean isGenLookAction() {
        return this.kind == 4;
    }

    public boolean isEmittable() {
        return this.kind != 6 && this.kind != 5;
    }

    public int lookAhead() {
        return this.kind;
    }

    public void setLookAction(int kind, int data) {
        this.kind = kind;
        this.len = data;
    }

    public int getLookLength() {
        return this.len;
    }

    public int getEntryState() {
        return this.entryState;
    }

    public void setEntryState(int entryState) {
        this.entryState = entryState;
    }

    public Action copyChoice(int length) {
        Action a = new Action(this.content, this.priority);
        a.setLookAction(3, length);
        return a;
    }

    public String lookString() {
        switch (this.kind) {
            case 0: {
                return "";
            }
            case 6: {
                return "LOOK_BACK";
            }
            case 1: {
                return "FIXED_BASE";
            }
            case 2: {
                return "FIXED_LOOK";
            }
            case 3: {
                return "FINITE_CHOICE";
            }
            case 5: {
                return "LOOK_FORWARD";
            }
            case 4: {
                return "LOOK_ACTION";
            }
        }
        return "unknown lookahead type";
    }
}

