/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.rpc.codec.msgpack;

import com.alipay.sofa.rpc.codec.AbstractSerializer;
import com.alipay.sofa.rpc.codec.msgpack.MsgPackHelper;
import com.alipay.sofa.rpc.common.struct.ConcurrentHashSet;
import com.alipay.sofa.rpc.common.utils.CodecUtils;
import com.alipay.sofa.rpc.config.ConfigUniqueNameGenerator;
import com.alipay.sofa.rpc.context.RpcInvokeContext;
import com.alipay.sofa.rpc.core.exception.SofaRpcException;
import com.alipay.sofa.rpc.core.request.SofaRequest;
import com.alipay.sofa.rpc.core.response.SofaResponse;
import com.alipay.sofa.rpc.ext.Extension;
import com.alipay.sofa.rpc.transport.AbstractByteBuf;
import com.alipay.sofa.rpc.transport.ByteArrayWrapperByteBuf;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.msgpack.MessagePack;

@Extension(value="msgpack", code=13)
public class MsgPackSerializer
extends AbstractSerializer {
    private final MessagePack messagePack = new MessagePack();
    private final MsgPackHelper helper = new MsgPackHelper();
    private final Set<Class<?>> registerSet = new ConcurrentHashSet();

    @Override
    public AbstractByteBuf encode(Object object, Map<String, String> context) throws SofaRpcException {
        if (object == null) {
            throw this.buildSerializeError("Unsupported null message!");
        }
        if (object instanceof SofaRequest) {
            return this.encodeSofaRequest((SofaRequest)object, context);
        }
        if (object instanceof SofaResponse) {
            return this.encodeSofaResponse((SofaResponse)object, context);
        }
        if (this.helper.isJavaClass(object)) {
            try {
                return new ByteArrayWrapperByteBuf(this.messagePack.write(object));
            }
            catch (IOException e) {
                throw this.buildSerializeError(e.getMessage());
            }
        }
        try {
            Class<?> clazz = object.getClass();
            this.registerClass(clazz);
            return new ByteArrayWrapperByteBuf(this.messagePack.write(object));
        }
        catch (IOException e) {
            throw this.buildSerializeError(e.getMessage());
        }
    }

    private void registerClass(Class<?> clazz) {
        if (!this.registerSet.contains(clazz)) {
            this.messagePack.register(clazz);
            this.registerSet.add(clazz);
        }
    }

    @Override
    public Object decode(AbstractByteBuf data, Class clazz, Map<String, String> context) throws SofaRpcException {
        Object result = null;
        if (clazz == null) {
            throw this.buildDeserializeError("class is null!");
        }
        if (data.readableBytes() <= 0) {
            try {
                result = clazz.newInstance();
            }
            catch (IllegalAccessException | InstantiationException e) {
                throw this.buildDeserializeError(e.getMessage());
            }
            return result;
        }
        if (this.helper.isJavaClass(clazz)) {
            try {
                return this.messagePack.read(data.array(), clazz);
            }
            catch (IOException e) {
                throw this.buildDeserializeError(e.getMessage());
            }
        }
        try {
            this.registerClass(clazz);
            return this.messagePack.read(data.array(), clazz);
        }
        catch (IOException e) {
            throw this.buildDeserializeError(e.getMessage());
        }
    }

    @Override
    public void decode(AbstractByteBuf data, Object template, Map<String, String> context) throws SofaRpcException {
        if (template == null) {
            throw this.buildDeserializeError("template is null!");
        }
        if (template instanceof SofaRequest) {
            this.decodeSofaRequest(data, (SofaRequest)template, context);
        } else if (template instanceof SofaResponse) {
            this.decodeSofaResponse(data, (SofaResponse)template, context);
        } else {
            throw this.buildDeserializeError("Only support decode from SofaRequest and SofaResponse template");
        }
    }

    protected AbstractByteBuf encodeSofaRequest(SofaRequest sofaRequest, Map<String, String> context) throws SofaRpcException {
        Object[] args = sofaRequest.getMethodArgs();
        if (args.length > 1) {
            throw this.buildSerializeError("Msgpack only support one parameter!");
        }
        return this.encode(args[0], context);
    }

    protected AbstractByteBuf encodeSofaResponse(SofaResponse sofaResponse, Map<String, String> context) throws SofaRpcException {
        Object appResponse;
        AbstractByteBuf byteBuf = sofaResponse.isError() ? this.encode(sofaResponse.getErrorMsg(), context) : ((appResponse = sofaResponse.getAppResponse()) instanceof Throwable ? this.encode(((Throwable)appResponse).getMessage(), context) : this.encode(appResponse, context));
        return byteBuf;
    }

    private void decodeSofaRequest(AbstractByteBuf data, SofaRequest sofaRequest, Map<String, String> head) {
        if (head == null) {
            throw this.buildDeserializeError("head is null!");
        }
        String targetService = head.remove("sofa_head_target_service");
        if (targetService == null) {
            throw this.buildDeserializeError("HEAD_TARGET_SERVICE is null");
        }
        sofaRequest.setTargetServiceUniqueName(targetService);
        String interfaceName = ConfigUniqueNameGenerator.getInterfaceName(targetService);
        sofaRequest.setInterfaceName(interfaceName);
        String methodName = head.remove("sofa_head_method_name");
        if (methodName == null) {
            throw this.buildDeserializeError("HEAD_METHOD_NAME is null");
        }
        sofaRequest.setMethodName(methodName);
        String targetApp = head.remove("sofa_head_target_app");
        if (targetApp != null) {
            sofaRequest.setTargetAppName(targetApp);
        }
        this.parseRequestHeader("rpc_trace_context", head, sofaRequest);
        if (RpcInvokeContext.isBaggageEnable()) {
            this.parseRequestHeader("rpc_req_baggage", head, sofaRequest);
        }
        for (Map.Entry<String, String> entry : head.entrySet()) {
            sofaRequest.addRequestProp(entry.getKey(), entry.getValue());
        }
        Class requestClass = this.helper.getReqClass(targetService, sofaRequest.getMethodName());
        Object pbReq = this.decode(data, requestClass, head);
        sofaRequest.setMethodArgs(new Object[]{pbReq});
        sofaRequest.setMethodArgSigs(new String[]{requestClass.getName()});
    }

    private void parseRequestHeader(String key, Map<String, String> headerMap, SofaRequest sofaRequest) {
        HashMap<String, String> traceMap = new HashMap<String, String>(8);
        CodecUtils.treeCopyTo(key + ".", headerMap, traceMap, true);
        if (!traceMap.isEmpty()) {
            sofaRequest.addRequestProp(key, traceMap);
        }
    }

    private void decodeSofaResponse(AbstractByteBuf data, SofaResponse sofaResponse, Map<String, String> head) {
        if (head == null) {
            throw this.buildDeserializeError("head is null!");
        }
        String targetService = head.remove("sofa_head_target_service");
        if (targetService == null) {
            throw this.buildDeserializeError("HEAD_TARGET_SERVICE is null");
        }
        String methodName = head.remove("sofa_head_method_name");
        if (methodName == null) {
            throw this.buildDeserializeError("HEAD_METHOD_NAME is null");
        }
        boolean isError = false;
        if ("true".equals(head.remove("sofa_head_response_error"))) {
            isError = true;
        }
        if (!head.isEmpty()) {
            sofaResponse.setResponseProps(head);
        }
        if (isError) {
            String errorMessage = (String)this.decode(data, String.class, head);
            sofaResponse.setErrorMsg(errorMessage);
        } else {
            Class responseClass = this.helper.getResClass(targetService, methodName);
            Object pbRes = this.decode(data, responseClass, head);
            sofaResponse.setAppResponse(pbRes);
        }
    }
}

